set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8229218';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-7-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      '3403240',
      NULL,
      0.628399,
      2,
      0,
      '2420',
      0,
      NULL,
      NULL,
      NULL,
      ' 5-11-2003',
      21,
      NULL,
      NULL,
      0.939929,
      1,
      ' 9-13-2001',
      NULL,
      1.895254,
      NULL,
      67.396858,
      3.926469,
      NULL,
      ' 9- 2-2000',
      '11-11-1989',
      NULL,
      1,
      0,
      2,
      NULL,
      1.836966,
      0,
      2,
      NULL,
      NULL,
      NULL,
      7,
      0.892883,
      24,
      12.736167,
      3.387549,
      16.683837,
      0.241023,
      3,
      7,
      0.164904,
      2.478499,
      0.248211,
      1,
      1.188777,
      1.013781,
      1.980342,
      1.491019,
      0,
      0,
      0,
      0,
      5.745040,
      1,
      1.446577,
      0,
      0,
      1,
      0,
      1,
      5,
      3,
      NULL,
      0.427397,
      3.682891,
      3,
      1.456471,
      NULL,
      0.917076,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      2,
      1.789633,
      0.066459,
      NULL,
      1,
      0.016195,
      NULL,
      NULL,
      1.408514,
      0,
      1,
      3.573785,
      0.715326,
      3.420910,
      3,
      1,
      1,
      0,
      3,
      1.571272,
      0.227307,
      0.090847,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.000779,
      NULL,
      NULL,
      0.167927,
      1,
      0.237965,
      1,
      4,
      NULL,
      NULL,
      0.545821,
      4.112596,
      NULL,
      0,
      0,
      1.478672,
      1,
      NULL,
      1.424679,
      2,
      NULL,
      1,
      0,
      1,
      4,
      NULL,
      NULL,
      NULL,
      3,
      0.066444,
      NULL,
      4.418296,
      0,
      1,
      4.484899,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      2.241873,
      1.603544,
      0.813556,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.622987,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.517123,
      1.866825,
      0,
      0,
      1.864407,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.830097,
      NULL,
      NULL,
      NULL,
      NULL,
      5.977544,
      1.363574,
      0,
      1.022803,
      0,
      2.866723,
      0.276960,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.977572,
      1.270854,
      1,
      3,
      5.061954,
      1.837368,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.707856,
      1.634716,
      0.103937,
      0.114401,
      0.097973,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.357977,
      0,
      NULL,
      NULL,
      2,
      0,
      0,
      1.123025,
      2,
      1,
      0.852727,
      0,
      0,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.751439,
      1.316817,
      0,
      1,
      0.696092,
      NULL,
      3,
      0,
      NULL,
      7,
      6.234268,
      4.647325,
      9.873047,
      9.438797,
      NULL,
      5,
      3.564385,
      NULL,
      0.070603,
      2.904428,
      3.877654,
      22,
      2.289250,
      2.926648,
      NULL,
      81.733036,
      NULL,
      79,
      5.334353,
      1.674133,
      0.780848,
      '21203',
      '',
      '',
      1.481328,
      '41133',
      '',
      '',
      1.226082,
      NULL,
      '',
      '',
      1.349355,
      27.936513,
      251.327152,
      47,
      1.845653,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.163160,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.140781,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.095924,
      1,
      NULL,
      1.367372,
      NULL,
      0,
      NULL,
      NULL,
      0.703332,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.464125,
      3.631196,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.488312,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.834207,
      0.250624,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      1,
      0,
      0.516690,
      0.323557,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.382483,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.823113,
      NULL,
      6.674521,
      1.547457,
      0.871006,
      3.526406,
      1.769367,
      1.956524,
      0,
      NULL,
      NULL,
      1,
      NULL,
      4.205544,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.140125,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.281452,
      NULL,
      NULL,
      1,
      0,
      3.063420,
      NULL,
      1,
      3.508098,
      4.477141,
      2.287271,
      3.457960,
      NULL,
      4.946419,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.214994,
      3.817669,
      NULL,
      2,
      1.579545,
      3.020140,
      NULL,
      2.550895,
      3.748124,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.370645,
      NULL,
      0,
      NULL,
      3.942072,
      0.329607,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.425174,
      NULL,
      NULL,
      1.903955,
      0,
      1.554468,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.228052,
      0.653991,
      0,
      0,
      NULL,
      0.966226,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.387400,
      NULL,
      NULL,
      NULL,
      3.093548,
      0.153783,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.794102,
      NULL,
      NULL,
      1.590143,
      NULL,
      1.261025,
      6.407612,
      0.743675,
      0,
      0.595447,
      0.622157,
      1.505611,
      1.313245,
      0,
      0,
      1.759775,
      1.146915,
      0,
      0.628205,
      0.888704,
      0.264822,
      1.155411,
      1,
      1,
      1.303125,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.593719,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.960765,
      5,
      NULL,
      7,
      0.792320,
      4,
      NULL,
      4,
      0,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.806737,
      NULL,
      NULL,
      3.089053,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.040827,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.129321,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.613139,
      NULL,
      1,
      NULL,
      1.687298,
      7,
      3.086995,
      3,
      0.250532,
      3,
      49,
      90.218143,
      2,
      1,
      0.233137,
      '44113',
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      1.695909,
      '',
      NULL,
      NULL);
commit;
end;
/


