set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9038203';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-7-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '3',
      NULL,
      NULL,
      '3443433',
      1,
      0.350822,
      NULL,
      1,
      '0401',
      3.123131,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.438785,
      1.748853,
      NULL,
      NULL,
      27,
      3.001518,
      134.915689,
      38.585680,
      1,
      ' 9-26-1974',
      '11-19-1982',
      ' 9- 5-1991',
      0.951289,
      1,
      3,
      0,
      0,
      1.376772,
      3.907913,
      NULL,
      1,
      3.675686,
      0,
      0.517793,
      6.589292,
      1,
      24,
      NULL,
      18,
      3,
      4.817222,
      NULL,
      1.620508,
      3.489235,
      1.605447,
      0,
      1.007446,
      0,
      1.167318,
      3.768052,
      1.392292,
      1.013519,
      NULL,
      NULL,
      2.638530,
      0,
      NULL,
      0.779147,
      0.386950,
      1,
      0.834126,
      1,
      1,
      4,
      2.363392,
      1.320030,
      7.392310,
      NULL,
      3,
      2,
      1.366345,
      NULL,
      4,
      4,
      0,
      NULL,
      NULL,
      0.462880,
      NULL,
      NULL,
      5.694601,
      8,
      2.811942,
      NULL,
      NULL,
      1,
      0,
      1.028888,
      NULL,
      1.692663,
      0.275478,
      1.061619,
      1.924235,
      1.651601,
      3,
      1.425151,
      0,
      0.899669,
      NULL,
      1,
      NULL,
      3,
      5,
      3.487396,
      1,
      2,
      1,
      NULL,
      NULL,
      0.875589,
      NULL,
      NULL,
      NULL,
      4.589690,
      1.805052,
      NULL,
      2.072422,
      1,
      0.972283,
      1,
      NULL,
      1,
      0,
      0.068362,
      1,
      0,
      NULL,
      1.991014,
      1.598197,
      1,
      1,
      NULL,
      NULL,
      4.428175,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1.974964,
      NULL,
      2,
      NULL,
      2,
      NULL,
      4.283924,
      7,
      0,
      3.664253,
      4.341007,
      NULL,
      1,
      4,
      2,
      NULL,
      NULL,
      NULL,
      4.776305,
      NULL,
      2.440057,
      ' 1-24-1990',
      25.474267,
      NULL,
      NULL,
      3.860687,
      0.782384,
      0,
      4.321640,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.175431,
      1.942049,
      NULL,
      0,
      0,
      1,
      0.687232,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.878198,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      1.832880,
      1,
      0,
      1,
      0.462974,
      2.880436,
      0.164413,
      NULL,
      NULL,
      NULL,
      5.325199,
      0,
      8.590733,
      2,
      2.967753,
      8.250446,
      1,
      NULL,
      NULL,
      NULL,
      0.887514,
      0.046117,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.507687,
      0,
      NULL,
      1,
      33,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.312212,
      NULL,
      NULL,
      2.490456,
      0,
      0.364964,
      2.584012,
      2.811025,
      1.982614,
      NULL,
      0.514780,
      3,
      1.186662,
      2.954604,
      3.670558,
      11,
      NULL,
      NULL,
      1.184061,
      2.999852,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.741912,
      0,
      0.038054,
      NULL,
      1,
      4.293151,
      0,
      0.173760,
      2.493229,
      6,
      NULL,
      0.574140,
      0.426235,
      1.890461,
      1,
      3,
      NULL,
      19.094199,
      NULL,
      NULL,
      NULL,
      31,
      59,
      42,
      2.813320,
      1,
      1.314093,
      '04102',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.178762,
      2,
      2,
      NULL,
      1.495464,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.082573,
      0,
      NULL,
      NULL,
      1.149418,
      NULL,
      NULL,
      0.506221,
      NULL,
      1.664304,
      NULL,
      0,
      1,
      0.687056,
      1.043142,
      0.737451,
      1.443520,
      NULL,
      NULL,
      0,
      NULL,
      0.772853,
      1.392517,
      1.726861,
      0.435220,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.676189,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      1.348398,
      1.201438,
      6,
      NULL,
      1.628450,
      0,
      0,
      1.158820,
      NULL,
      0,
      1,
      NULL,
      0.148637,
      1.052131,
      NULL,
      1,
      0,
      NULL,
      1.732944,
      3,
      NULL,
      3.211114,
      NULL,
      NULL,
      0.007210,
      1.495473,
      NULL,
      1.557527,
      3,
      NULL,
      NULL,
      1.697779,
      NULL,
      NULL,
      1.727585,
      NULL,
      0.466265,
      3,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      6,
      0.732118,
      4,
      1.196129,
      NULL,
      NULL,
      57.987558,
      39.069708,
      NULL,
      1,
      2,
      '34221',
      '',
      '',
      0,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '',
      '');
commit;
end;
/


