set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9753470';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-2-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1.096419,
      2.053019,
      NULL,
      3,
      5,
      2.672502,
      NULL,
      0.009977,
      '231',
      '22241142',
      33,
      61,
      NULL,
      1,
      NULL,
      0,
      0,
      '4204',
      0,
      1,
      NULL,
      NULL,
      ' 0- 2-1984',
      NULL,
      36.358072,
      NULL,
      1.007562,
      2.816210,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '10-22-2002',
      ' 0-12-2003',
      ' 8-26-1977',
      3,
      1,
      1,
      1.738608,
      1,
      NULL,
      0,
      1,
      0.477622,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      0.794646,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.699767,
      3.554599,
      2.703612,
      0,
      7.720717,
      1.757279,
      1.317931,
      NULL,
      3,
      4,
      1,
      1,
      0,
      1.807934,
      2,
      1.881672,
      4,
      1.814899,
      2.544966,
      1.060282,
      3.224969,
      1.348505,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.350691,
      0,
      1.994890,
      2,
      0,
      1.864275,
      NULL,
      2,
      0.818722,
      1.094908,
      0.618833,
      0,
      1,
      1.151616,
      1.084597,
      0,
      3.564332,
      3.165300,
      1,
      1,
      1,
      0.051510,
      8,
      NULL,
      0.248538,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.906422,
      1,
      NULL,
      0.386706,
      NULL,
      NULL,
      2,
      0.409802,
      NULL,
      1,
      0,
      3.800330,
      1,
      5,
      0,
      0.163895,
      1.664423,
      NULL,
      1.339093,
      NULL,
      1,
      NULL,
      0.835731,
      1,
      1.487358,
      1,
      0.225546,
      NULL,
      0.177937,
      NULL,
      NULL,
      NULL,
      NULL,
      2.066473,
      1.655763,
      0,
      NULL,
      4.067682,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      6,
      3,
      1.641938,
      NULL,
      1.522060,
      ' 3-22-1977',
      NULL,
      ' 8- 6-1978',
      220.064657,
      0,
      NULL,
      NULL,
      NULL,
      0.625909,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.946141,
      1.897825,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      3.945136,
      0.299448,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.885925,
      1.670917,
      NULL,
      NULL,
      NULL,
      0.914597,
      0,
      0,
      3,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      3.862670,
      0.211829,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.155153,
      NULL,
      0,
      1,
      1,
      1.478117,
      1.129184,
      0.050863,
      0,
      1.880832,
      0.608618,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      3,
      1.537744,
      2.643245,
      2,
      3.971212,
      2.215323,
      0,
      2,
      1,
      1.952574,
      0.010283,
      0,
      4,
      2,
      0,
      0.471600,
      0,
      0,
      NULL,
      2.575018,
      0.609528,
      NULL,
      NULL,
      NULL,
      1.459938,
      3.014331,
      NULL,
      2.635394,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      52.807818,
      NULL,
      NULL,
      7.647938,
      NULL,
      3.968749,
      NULL,
      '11101',
      '04410',
      NULL,
      1,
      NULL,
      '',
      '',
      0.498546,
      '',
      '',
      '',
      1.817664,
      2.972898,
      194,
      11,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.863487,
      0,
      1,
      1.052970,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      2,
      NULL,
      1.072509,
      3.710014,
      0,
      0.817307,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.913431,
      0.287807,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.007537,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      0.299864,
      NULL,
      0.269936,
      NULL,
      NULL,
      1.177635,
      NULL,
      1,
      0.374359,
      1.843395,
      NULL,
      1.792507,
      2,
      1,
      1.358982,
      2,
      1.887684,
      NULL,
      3.170982,
      2,
      2.469909,
      1.025671,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.771068,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.870777,
      0,
      1.521656,
      1,
      NULL,
      NULL,
      5.087378,
      0,
      0.167411,
      0.863082,
      0.629262,
      0.807999,
      0.157534,
      NULL,
      NULL,
      1,
      1,
      0,
      1.002375,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.909349,
      NULL,
      NULL,
      1.864437,
      NULL,
      NULL,
      7.677579,
      1,
      3.636277,
      0.372645,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.746333,
      NULL,
      0,
      3,
      2,
      NULL,
      5.261850,
      6.468371,
      2.396325,
      0,
      2.353354,
      2,
      2.547957,
      NULL,
      3,
      0.389397,
      NULL,
      1,
      2.557456,
      1.429450,
      0,
      3,
      NULL,
      NULL,
      1.136912,
      0.571638,
      2,
      2.366668,
      1,
      NULL,
      0.008906,
      NULL,
      1.716947,
      0,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.044730,
      NULL,
      NULL,
      1.238164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.328935,
      NULL,
      NULL,
      0.302613,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.574637,
      NULL,
      NULL,
      3,
      2,
      3.061966,
      1,
      0.083001,
      1.591842,
      1,
      2.653194,
      NULL,
      4.209239,
      NULL,
      25,
      NULL,
      189.999871,
      NULL,
      2,
      NULL,
      2.611870,
      NULL,
      2.239400,
      NULL,
      3.462618,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.824759,
      NULL,
      0.681174,
      NULL,
      0,
      NULL,
      3.636343,
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.550320,
      NULL,
      0,
      NULL,
      0.188068,
      NULL,
      0.338665,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.409630,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.054811,
      NULL,
      1.883069,
      NULL,
      3,
      NULL,
      0.452056,
      NULL,
      3,
      NULL,
      3.974916,
      NULL,
      1,
      NULL,
      1,
      NULL,
      3.446215,
      NULL,
      14.729000,
      NULL,
      0,
      NULL,
      0.824521,
      NULL,
      NULL,
      NULL,
      0.744380,
      NULL,
      1.445143,
      3.102178,
      1.600730,
      NULL,
      NULL,
      NULL,
      NULL,
      0.220949,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      7.525084,
      0.370703,
      0.810640,
      NULL,
      0.374631,
      0,
      0.348612,
      0.262950,
      1.077034,
      1.184191,
      1.734850,
      NULL,
      0.941398,
      1,
      1,
      0.806224,
      1,
      0.382077,
      2,
      NULL,
      1,
      NULL,
      0.828649,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.463542,
      NULL,
      NULL,
      NULL,
      1,
      15,
      NULL,
      NULL,
      3.392480,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.173667,
      NULL,
      1.790161,
      NULL,
      1.984006,
      NULL,
      0,
      NULL,
      0.578193,
      NULL,
      1.581331,
      NULL,
      1,
      NULL,
      0.607205,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      1.540232,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1,
      NULL,
      0,
      NULL,
      185.654724,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.554521,
      NULL,
      2.906111,
      NULL,
      3.836666,
      NULL,
      8,
      NULL,
      3,
      NULL,
      1.194975,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      2.359584,
      NULL,
      NULL,
      NULL,
      1.899455,
      NULL,
      3,
      NULL,
      0.286496,
      NULL,
      3.605101,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3,
      NULL,
      15,
      2,
      1.909531,
      3.624073,
      2,
      NULL,
      NULL,
      2,
      1,
      2.907519,
      1,
      NULL,
      0.182766,
      NULL,
      1.595413,
      3,
      1.031306,
      1,
      1.221784,
      NULL,
      1.300681,
      0.596965,
      3.157682,
      0.510543,
      0.943675,
      NULL,
      1,
      0,
      NULL,
      0,
      1.549429,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0,
      0,
      NULL,
      1.936766,
      0,
      0.862814,
      0,
      NULL,
      1,
      0,
      0,
      0.917342,
      0,
      3.391041,
      0.407506,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      7.348944,
      5,
      6,
      2.990244,
      NULL,
      2.667791,
      57.801413,
      NULL,
      4,
      NULL,
      NULL,
      '13044',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


