set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8930175';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-6-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '3',
      NULL,
      NULL,
      '4023044',
      0,
      1.665970,
      2,
      0,
      '2112',
      2,
      NULL,
      NULL,
      NULL,
      ' 3-23-1977',
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      ' 8-12-1979',
      57.052195,
      NULL,
      NULL,
      135.626846,
      5.805193,
      NULL,
      NULL,
      ' 7- 9-1979',
      3,
      0,
      1,
      2,
      1.002507,
      0.354016,
      0.890499,
      NULL,
      0,
      NULL,
      8.943011,
      2,
      8.628631,
      13.241926,
      1.518635,
      0,
      27.705061,
      6,
      3,
      7,
      0,
      1,
      NULL,
      1.471026,
      NULL,
      1.691243,
      0,
      1.555940,
      1.478014,
      1.219648,
      1.972695,
      1.979376,
      1,
      3.435890,
      1.302978,
      0.538005,
      0.225269,
      5.251538,
      NULL,
      NULL,
      7.326033,
      9.971422,
      1,
      0,
      6,
      1,
      0,
      NULL,
      NULL,
      5.670091,
      1,
      1.779462,
      1.218942,
      NULL,
      NULL,
      0.106872,
      NULL,
      NULL,
      3.317851,
      1.021567,
      0.342437,
      2,
      1.363064,
      0,
      0.810199,
      2.814437,
      1.239752,
      0,
      2.451178,
      0,
      0.108432,
      2.203339,
      NULL,
      NULL,
      2,
      0,
      1,
      NULL,
      1.411136,
      2,
      5,
      1,
      4,
      0,
      0,
      NULL,
      NULL,
      1.319480,
      NULL,
      NULL,
      1.167779,
      1.919330,
      0,
      0.756377,
      0.353117,
      2,
      0.263678,
      NULL,
      1.202220,
      3,
      0.720943,
      2.313406,
      0.074581,
      2,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.183647,
      7.976943,
      NULL,
      1,
      3,
      NULL,
      5.394538,
      3.189198,
      6,
      5,
      0,
      6.159078,
      1.926409,
      1,
      NULL,
      NULL,
      NULL,
      8,
      0.968422,
      6.478208,
      0.234963,
      NULL,
      8,
      6.035468,
      6.907137,
      7.509115,
      6.642577,
      3.263077,
      ' 2- 6-1993',
      14.469449,
      NULL,
      136.825150,
      NULL,
      0.428724,
      0,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.909224,
      1,
      NULL,
      0,
      1.099802,
      2,
      1.813616,
      1.932019,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.364255,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      1.368530,
      3.868537,
      1.570312,
      0,
      6,
      NULL,
      0.324834,
      NULL,
      NULL,
      NULL,
      3.104305,
      NULL,
      7.054442,
      2,
      5,
      5,
      4,
      0.384186,
      NULL,
      NULL,
      0.659676,
      13,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1.207671,
      1.553355,
      1.856605,
      NULL,
      0.127034,
      0,
      NULL,
      1,
      NULL,
      13,
      31,
      13.938451,
      2,
      1,
      0,
      0.052573,
      NULL,
      2.440130,
      0.338436,
      3.055890,
      1.239468,
      0.129740,
      1,
      2.028148,
      NULL,
      NULL,
      0,
      1.028975,
      0.244675,
      1.479279,
      0,
      NULL,
      1,
      0.696493,
      0.628736,
      NULL,
      1.662013,
      0,
      NULL,
      0.199677,
      3,
      1.894549,
      0,
      1.259761,
      11,
      8.396439,
      4,
      7.365186,
      2.281548,
      2,
      1.806826,
      3,
      1,
      3.892763,
      3,
      2,
      NULL,
      0,
      0.485844,
      53,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.480544,
      '12422',
      NULL,
      NULL,
      1,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      3.644410,
      22.629630,
      27.344463,
      NULL,
      2,
      46,
      4,
      3,
      4.566091,
      0,
      1.589573,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      0.516697,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.363749,
      1,
      NULL,
      3.077090,
      2.276642,
      3.077078,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.681411,
      0.913948,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.193237,
      NULL,
      7.280927,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.698422,
      0,
      3.257840,
      NULL,
      NULL,
      NULL,
      0.631243,
      NULL,
      NULL,
      1.486533,
      NULL,
      0,
      NULL,
      3,
      0,
      0,
      0,
      NULL,
      2.385024,
      2.888704,
      1,
      0.708858,
      1.031873,
      0,
      1,
      0.515929,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.175140,
      NULL,
      0,
      1.692772,
      8,
      0,
      0.742159,
      0.753772,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1.950182,
      NULL,
      1.665826,
      1.127331,
      3.888314,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.960347,
      1.290832,
      0,
      2,
      1.328088,
      0,
      0,
      NULL,
      NULL,
      1.331071,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.625466,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.025633,
      3.382168,
      1.040285,
      0,
      NULL,
      1,
      6,
      3.383826,
      7.782755,
      1.480047,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.799063,
      3,
      NULL,
      0,
      2,
      NULL,
      2.337476,
      NULL,
      5,
      2.580405,
      1.221714,
      0,
      3.905776,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.224864,
      0.471858,
      9,
      NULL,
      NULL,
      2.381450,
      2.831392,
      5.643258,
      NULL,
      2.926726,
      NULL,
      1.638111,
      0,
      0,
      0,
      NULL,
      3.120471,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.914441,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.663493,
      NULL,
      NULL,
      1.424061,
      NULL,
      NULL,
      0.023734,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1.948290,
      1.896585,
      NULL,
      NULL,
      NULL,
      3.349644,
      NULL,
      NULL,
      NULL,
      1.033603,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.509297,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.080757,
      NULL,
      NULL,
      NULL,
      1.205272,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      3.618379,
      1.311290,
      NULL,
      NULL,
      3,
      0.119120,
      NULL,
      NULL,
      2.204335,
      0,
      NULL,
      NULL,
      NULL,
      0.873361,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.653915,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0.254054,
      2.981670,
      1.383653,
      80.723150,
      10,
      3,
      28.677054,
      NULL,
      2,
      71,
      7,
      2,
      11.942309,
      5.940286,
      0,
      13,
      3.866625,
      NULL,
      NULL,
      NULL,
      0.701481,
      NULL,
      0,
      156.372517,
      1.523157,
      1,
      1,
      0,
      0.209495,
      0,
      1,
      NULL,
      0.582506,
      1,
      1,
      1,
      1,
      1,
      0.430995,
      1,
      1.874934,
      0.596954,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.075113,
      1.531020,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.482165,
      1.422007,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.004633,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.441810,
      NULL,
      NULL,
      NULL,
      0.729640,
      NULL,
      51,
      NULL,
      1.256311,
      NULL,
      0.600350,
      NULL,
      1,
      0.663475,
      2,
      20.399091,
      11.171256,
      NULL,
      NULL,
      NULL,
      NULL,
      0.952464,
      NULL,
      0.918397,
      1.796680,
      NULL,
      1.244025,
      0.692188,
      NULL,
      4,
      NULL,
      3,
      1.985347,
      1,
      NULL,
      1,
      0.053013,
      0.870023,
      0,
      1,
      1,
      1.190494,
      NULL,
      0,
      0.678204,
      1.904660,
      2.732391,
      1.461185,
      2.658986,
      0,
      1.766866,
      0.475992,
      2.223164,
      NULL,
      0,
      1.594617,
      0,
      0.277070,
      0,
      0,
      1.395631,
      NULL,
      0.854869,
      NULL,
      0.714590,
      0,
      3,
      1,
      0.417223,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.256524,
      0.545308,
      NULL,
      NULL,
      0,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      52,
      3,
      1,
      NULL,
      '43310',
      '30120',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


