set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9107982';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-2-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      '3232',
      2,
      3.012514,
      0.063142,
      33,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      ' 7-11-1984',
      127,
      3,
      303.604444,
      114,
      1.355341,
      NULL,
      NULL,
      ' 1- 8-1975',
      2.706063,
      0,
      0,
      0.551757,
      1.372266,
      1,
      3,
      0.216216,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.995263,
      2.377330,
      4,
      10.549171,
      3.954115,
      0,
      0.629076,
      0,
      0.532276,
      3.138667,
      0.675314,
      0.198729,
      0,
      0,
      1.757531,
      1,
      1.207424,
      NULL,
      0.520744,
      NULL,
      3,
      1.196481,
      0,
      NULL,
      0.824879,
      1,
      0,
      1,
      NULL,
      1.852611,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.461806,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.702098,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.580653,
      NULL,
      0.842266,
      NULL,
      1,
      0.505522,
      0.202611,
      0.249866,
      NULL,
      1,
      NULL,
      0,
      0.823881,
      0.218615,
      0.646021,
      NULL,
      1,
      0.267950,
      NULL,
      1,
      0.321070,
      0.299027,
      0.126870,
      NULL,
      0,
      1,
      0,
      1.619450,
      0.853261,
      1,
      0.173738,
      0.012548,
      1.187049,
      0,
      0,
      1.217226,
      1.775994,
      2,
      1,
      NULL,
      0.231251,
      NULL,
      1,
      1.806988,
      NULL,
      1.169958,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.854261,
      NULL,
      0.834803,
      1.532991,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.065870,
      NULL,
      NULL,
      NULL,
      1.212133,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.296762,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.220451,
      NULL,
      4,
      NULL,
      2.195090,
      0,
      NULL,
      NULL,
      NULL,
      1.337262,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.641038,
      1.744946,
      1,
      1,
      0.700638,
      1.406267,
      0.933282,
      0,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1.799804,
      1,
      3,
      1.504718,
      2,
      2.935566,
      NULL,
      0,
      1.746370,
      1,
      NULL,
      0,
      1,
      2.362252,
      9.179497,
      1,
      4.714515,
      1,
      NULL,
      0.641386,
      0,
      1,
      5,
      0,
      NULL,
      NULL,
      0,
      1.659778,
      2,
      0,
      3,
      0.444982,
      10.050817,
      5.526369,
      NULL,
      2.829447,
      4,
      1.504304,
      1,
      NULL,
      4,
      0,
      2.582716,
      1.798030,
      36,
      NULL,
      1.529634,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.839536,
      1,
      '11011',
      '',
      '',
      0,
      NULL,
      '',
      '',
      0.043491,
      '14333',
      '3422',
      '0332',
      NULL,
      38,
      NULL,
      50.968349,
      2,
      67.202743,
      2,
      2.165965,
      0,
      1.325771,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.241584,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.188693,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.581040,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.509866,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.853214,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.460391,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.290910,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.343827,
      NULL,
      NULL,
      1.829703,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.173268,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.005856,
      NULL,
      NULL,
      0.168363,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.774778,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.191737,
      NULL,
      NULL,
      0.452448,
      NULL,
      NULL,
      0.636591,
      NULL,
      NULL,
      1.397839,
      NULL,
      NULL,
      0.925247,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.525336,
      NULL,
      NULL,
      1.084216,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.158524,
      NULL,
      NULL,
      1.381867,
      NULL,
      NULL,
      0.098494,
      NULL,
      NULL,
      NULL,
      1.104693,
      1.552384,
      0,
      0.616956,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.554827,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.817118,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.967017,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.001016,
      NULL,
      NULL,
      NULL,
      2.739571,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.980646,
      NULL,
      NULL,
      NULL,
      1.890589,
      NULL,
      NULL,
      NULL,
      2.757214,
      NULL,
      NULL,
      NULL,
      2.059074,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.223913,
      NULL,
      4.385433,
      0,
      NULL,
      NULL,
      NULL,
      309,
      NULL,
      1.825638,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1.213759,
      0,
      1,
      1.398153,
      0,
      1,
      1,
      1,
      1,
      NULL,
      1,
      0.396627,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.725502,
      2,
      1.648301,
      1,
      1,
      2.895741,
      1.126085,
      NULL,
      1,
      NULL,
      0.297165,
      0.874753,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.361083,
      0,
      1,
      0.511099,
      1.311083,
      NULL,
      NULL,
      1,
      0,
      0.190101,
      1,
      NULL,
      0.515986,
      0.724496,
      NULL,
      0.475037,
      0,
      0.277067,
      1,
      NULL,
      NULL,
      1,
      0.072840,
      0.264358,
      0.422738,
      0.016691,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.785392,
      NULL,
      1,
      NULL,
      2.047909,
      NULL,
      0.799335,
      NULL,
      1.367724,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.387608,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.349998,
      NULL,
      1.880000,
      NULL,
      1,
      NULL,
      0.121907,
      25.655304,
      NULL,
      NULL,
      1,
      0,
      0.918255,
      2.306162,
      NULL,
      1.653086,
      0,
      0.757550,
      6.334415,
      1.096962,
      NULL,
      NULL,
      31,
      5.035830,
      NULL,
      1,
      1.858151,
      '03223',
      '03400',
      '',
      0.089189,
      '',
      '',
      NULL,
      NULL,
      '23244',
      '4133',
      '1423');
commit;
end;
/


