set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7901496';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-6-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      '0124142',
      NULL,
      1,
      2,
      NULL,
      NULL,
      2.763720,
      1.600946,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      1.166197,
      1.183001,
      ' 3-25-2002',
      33,
      NULL,
      206,
      126.044786,
      0.971424,
      ' 0-29-1975',
      ' 0-12-2002',
      ' 1- 8-1998',
      2,
      1.865087,
      0.391122,
      1,
      1.724842,
      0,
      1.108209,
      1,
      NULL,
      NULL,
      13,
      6,
      8,
      1,
      139.338881,
      2.516936,
      9,
      9.038533,
      6,
      6.146438,
      0,
      0,
      0,
      NULL,
      0.714241,
      NULL,
      1.822117,
      NULL,
      1,
      1,
      189.404783,
      15.974632,
      5,
      NULL,
      1.206458,
      NULL,
      NULL,
      NULL,
      2.960066,
      0,
      0.585047,
      0,
      NULL,
      NULL,
      0.866315,
      0.233709,
      NULL,
      4.929419,
      0,
      3,
      0.342686,
      2,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0.299980,
      0,
      0.891382,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.788112,
      0.361496,
      3.097592,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.220538,
      3.695558,
      NULL,
      0.446809,
      NULL,
      NULL,
      2,
      2,
      3.445993,
      4,
      1,
      0.605298,
      0.042027,
      3,
      NULL,
      1,
      NULL,
      0,
      1.514896,
      NULL,
      1,
      1.104860,
      7.719236,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.701225,
      3,
      4.459925,
      0.720499,
      0,
      4,
      7.036292,
      NULL,
      NULL,
      NULL,
      4,
      5.075811,
      NULL,
      NULL,
      NULL,
      3,
      2.679183,
      5.928594,
      NULL,
      0,
      NULL,
      NULL,
      '11-26-1993',
      164.280492,
      2,
      0,
      NULL,
      5.062759,
      2,
      3.707259,
      NULL,
      NULL,
      2,
      1,
      0.996860,
      1.204607,
      0.625098,
      0,
      1,
      0.580661,
      1.078889,
      1.053417,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.166816,
      NULL,
      NULL,
      NULL,
      NULL,
      1.583636,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.480725,
      0,
      0.360025,
      NULL,
      NULL,
      2.243074,
      NULL,
      NULL,
      NULL,
      NULL,
      1.132296,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.396501,
      1.887435,
      3,
      1.423019,
      0,
      1,
      2,
      2603.218372,
      0,
      0.215565,
      NULL,
      NULL,
      NULL,
      0,
      0.729215,
      3.724143,
      2.032508,
      0,
      3.069411,
      0,
      3,
      0,
      2.338541,
      NULL,
      3.922958,
      0,
      1.282338,
      NULL,
      10,
      191.798772,
      74.399729,
      NULL,
      186.277034,
      12.700762,
      70,
      1,
      1,
      1.123795,
      1.862323,
      0.250753,
      1,
      0,
      1,
      9.921688,
      0.089947,
      1,
      10.479502,
      7.907239,
      1,
      3.506995,
      NULL,
      3.641635,
      3.491200,
      1,
      0.687080,
      1,
      1,
      40,
      0.960130,
      3.807332,
      NULL,
      40,
      NULL,
      46,
      NULL,
      NULL,
      5,
      '11022',
      '41233',
      NULL,
      0.505096,
      '00231',
      NULL,
      NULL,
      0,
      '',
      '',
      '',
      NULL,
      13.301637,
      46,
      4.919615,
      NULL,
      17,
      1,
      1.884339,
      5,
      0.038487,
      2.026874,
      NULL,
      NULL,
      NULL,
      NULL,
      0.305360,
      NULL,
      NULL,
      1.263034,
      NULL,
      NULL,
      1.836673,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.918382,
      2.721536,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.005850,
      NULL,
      NULL,
      1.223124,
      NULL,
      NULL,
      6.946211,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.659970,
      NULL,
      NULL,
      1.126948,
      NULL,
      NULL,
      0.351512,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.904747,
      NULL,
      NULL,
      0.687853,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.978456,
      NULL,
      NULL,
      1,
      3,
      3.468576,
      1,
      0.616617,
      2,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      2,
      2.016393,
      0.126383,
      3,
      0.747469,
      NULL,
      NULL,
      6,
      2.336875,
      4,
      0.971708,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.721849,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.363193,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.968730,
      0,
      6.983268,
      1.706445,
      NULL,
      NULL,
      2,
      5.562266,
      5,
      0.263498,
      NULL,
      NULL,
      2,
      1.618368,
      1,
      NULL,
      NULL,
      NULL,
      7.161869,
      2,
      3.820976,
      1,
      NULL,
      NULL,
      2.563589,
      2.653998,
      1,
      0,
      1.798942,
      2.211018,
      2.771075,
      1.249099,
      0,
      3.369227,
      5.444622,
      0,
      6.223556,
      NULL,
      4,
      0,
      3,
      5,
      0.457297,
      0,
      1.459091,
      0,
      1.038505,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.166872,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.301697,
      NULL,
      NULL,
      1.039573,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.007871,
      0,
      0,
      1,
      NULL,
      1.091238,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.405022,
      NULL,
      NULL,
      NULL,
      0.606470,
      NULL,
      NULL,
      NULL,
      2.389986,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.172306,
      NULL,
      NULL,
      NULL,
      2.177051,
      0,
      1.793316,
      1.751833,
      1,
      22.467872,
      12,
      2,
      3.822178,
      0.920894,
      1.501025,
      NULL,
      NULL,
      2.837727,
      1,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      241,
      2,
      0.514115,
      1.775918,
      1,
      0,
      0,
      1.490162,
      NULL,
      1,
      1.214953,
      0,
      0,
      NULL,
      1.257335,
      0.798826,
      1,
      0,
      0.142942,
      1.097314,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3,
      0,
      0,
      1,
      4,
      NULL,
      7,
      NULL,
      NULL,
      0,
      0,
      0.388717,
      NULL,
      3,
      2,
      NULL,
      3,
      0.265416,
      NULL,
      1.090970,
      NULL,
      NULL,
      0,
      0,
      NULL,
      3,
      NULL,
      NULL,
      0.997065,
      0.747314,
      NULL,
      NULL,
      0.739510,
      NULL,
      3,
      0.651663,
      NULL,
      1.916809,
      NULL,
      NULL,
      1.068764,
      1,
      NULL,
      NULL,
      0.444711,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.002426,
      NULL,
      0,
      NULL,
      5.192109,
      2,
      NULL,
      NULL,
      2.193771,
      1,
      41,
      NULL,
      3,
      0.130374,
      1.919514,
      '31031',
      '02433',
      '',
      0.075935,
      '43343',
      '',
      '',
      NULL,
      '',
      '',
      NULL);
commit;
end;
/


