set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9433292';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-11-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      '2210131',
      2,
      1.399623,
      NULL,
      1,
      '0200',
      3,
      1,
      NULL,
      NULL,
      ' 7-24-1984',
      27,
      NULL,
      5.254699,
      0.960751,
      1,
      NULL,
      30,
      0.283308,
      187.670345,
      66.306727,
      NULL,
      NULL,
      ' 4-23-1975',
      ' 9-11-2003',
      NULL,
      2,
      2,
      0.982028,
      1.535769,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      9.689279,
      2,
      4,
      NULL,
      NULL,
      15,
      3,
      3,
      5,
      1,
      0.822877,
      1.340922,
      1.192092,
      1.987547,
      1,
      NULL,
      3.629006,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.915602,
      2.942959,
      NULL,
      1,
      2.247075,
      3.674409,
      NULL,
      3,
      7.787495,
      3,
      2,
      1.699402,
      0,
      0.954876,
      NULL,
      0.886997,
      3,
      0,
      NULL,
      1.917553,
      NULL,
      NULL,
      0.640626,
      NULL,
      NULL,
      2,
      1.060848,
      NULL,
      1.771126,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.317572,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.210998,
      0.579162,
      0.144833,
      0.370589,
      0,
      1,
      NULL,
      0.543722,
      0,
      NULL,
      0.509144,
      0.045543,
      0,
      1.875347,
      0.183675,
      0.866410,
      NULL,
      0.285047,
      0.217165,
      NULL,
      1,
      1.255693,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      0.648532,
      0.715919,
      0.182311,
      1.322713,
      1,
      1,
      1,
      3,
      3.717822,
      1,
      2,
      NULL,
      NULL,
      0.655362,
      6.389548,
      1.890561,
      1,
      1,
      1,
      1,
      ' 0-22-1993',
      49.440433,
      ' 9-27-2000',
      4.858634,
      1.942927,
      1.018733,
      2.104377,
      9,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      4,
      NULL,
      1.353320,
      1.627700,
      1.165751,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.264614,
      NULL,
      1.819317,
      1,
      3.865666,
      0.750100,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      3.979604,
      NULL,
      1,
      NULL,
      1.090787,
      0.818476,
      7.909244,
      3,
      5,
      3.100952,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1.213599,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      1.845046,
      0.688690,
      20,
      NULL,
      0.312991,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      0,
      2,
      NULL,
      5.579842,
      0,
      2.425132,
      3.579916,
      4.736298,
      0.758456,
      0.136104,
      NULL,
      0,
      3.900856,
      1,
      2.364228,
      2.917621,
      0.743655,
      1,
      NULL,
      1.040879,
      NULL,
      1.617411,
      0,
      0.608306,
      0,
      0,
      1,
      3,
      4,
      0.185666,
      3.478472,
      10.116381,
      0,
      8.370115,
      10.418134,
      4,
      4,
      1.685481,
      0.163696,
      2,
      3,
      3.494464,
      18,
      2,
      0.252399,
      NULL,
      67.451971,
      NULL,
      11.307447,
      0.784468,
      1,
      1,
      '34211',
      '04020',
      '',
      0,
      '',
      '',
      '',
      1.649520,
      NULL,
      NULL,
      '',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.698841,
      0.434393,
      1.145212,
      NULL,
      NULL,
      NULL,
      0.732819,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.248268,
      NULL,
      NULL,
      1.014119,
      NULL,
      NULL,
      0.690449,
      NULL,
      0.904018,
      448,
      5,
      3.135376,
      0,
      NULL,
      1,
      0.087416,
      0.366742,
      0.462202,
      1.341865,
      1.706134,
      0.681244,
      NULL,
      0,
      0.079231,
      1,
      1,
      0.498208,
      2.795784,
      NULL,
      1,
      NULL,
      0.840930,
      NULL,
      0.878961,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.650645,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.263374,
      0.144279,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1.865675,
      1,
      0,
      1.369425,
      NULL,
      NULL,
      1,
      1.497497,
      NULL,
      0,
      1.261599,
      1,
      1,
      1.429293,
      1.165365,
      2,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.540256,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.247143,
      NULL,
      0.562778,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2.518093,
      NULL,
      1.718314,
      NULL,
      598.092385,
      NULL,
      1,
      NULL,
      0.852912,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.933774,
      1.182201,
      0.203548,
      1,
      1.914308,
      NULL,
      0,
      NULL,
      2,
      0,
      NULL,
      0,
      0,
      0,
      1,
      1.693465,
      0,
      1,
      1.106104,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.061367,
      0,
      NULL,
      1,
      0.472763,
      NULL,
      1,
      0,
      0.153719,
      3,
      NULL,
      NULL,
      3,
      1.101121,
      0.608365,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.502139,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.832198,
      1,
      1,
      1,
      0.534754,
      NULL,
      6.992898,
      4,
      1.353034,
      NULL,
      NULL,
      NULL,
      19.817228,
      3.640547,
      0,
      5.360477,
      '02332',
      NULL,
      '',
      0.973126,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


