set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8404232';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-8-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '0',
      NULL,
      NULL,
      '2041341',
      0,
      0,
      NULL,
      2,
      '2241',
      0.040467,
      0,
      NULL,
      NULL,
      ' 2-27-1989',
      NULL,
      NULL,
      NULL,
      1,
      6,
      ' 6-16-1986',
      11,
      2.250748,
      279.785837,
      122,
      2,
      ' 1-27-1992',
      ' 2- 1-1999',
      ' 3- 1-1992',
      0,
      0.208101,
      1,
      1.638370,
      0.489224,
      1.855603,
      1.098523,
      3.853906,
      NULL,
      NULL,
      NULL,
      0.849957,
      4.966654,
      2.964167,
      6.159841,
      4,
      25,
      3.316700,
      1.200405,
      3.406668,
      1.920359,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      3,
      1,
      NULL,
      0.350661,
      2.072332,
      1,
      1.012120,
      0.752761,
      NULL,
      0.215801,
      1,
      1,
      0.761987,
      0,
      7,
      0.878502,
      1,
      NULL,
      1.516598,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.663175,
      NULL,
      1,
      1.987111,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.863922,
      NULL,
      0,
      0.372997,
      0.769113,
      4,
      0,
      0,
      2,
      1,
      4,
      1,
      1.861468,
      2.827766,
      1,
      0,
      1,
      1.821584,
      0,
      NULL,
      0,
      NULL,
      0,
      1.545301,
      NULL,
      1.087000,
      NULL,
      NULL,
      0.833818,
      0.276933,
      0,
      0,
      0,
      0,
      3,
      NULL,
      2.588385,
      1.881434,
      2,
      7.223095,
      NULL,
      1.051029,
      NULL,
      4.222661,
      NULL,
      0,
      0.367613,
      2.502636,
      NULL,
      NULL,
      NULL,
      4,
      0,
      3.693526,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.300110,
      0,
      3,
      1.692814,
      5,
      4,
      NULL,
      4,
      5,
      2.879362,
      4.998318,
      0,
      4.770841,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      5.259882,
      0,
      1.091363,
      NULL,
      2.910733,
      6,
      7,
      0,
      3.850155,
      0,
      0.221265,
      0.567470,
      4,
      0.021576,
      0,
      3.429437,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      7.263347,
      1.202405,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.900243,
      0,
      1.420665,
      0.805681,
      1,
      1,
      1,
      10.486430,
      0.296365,
      1.481683,
      NULL,
      NULL,
      NULL,
      3,
      1.724408,
      2,
      1.862016,
      NULL,
      NULL,
      1.008762,
      1.537211,
      NULL,
      1,
      1,
      3,
      NULL,
      0,
      1.022329,
      0,
      3,
      NULL,
      0.503947,
      0,
      1.087624,
      1.837630,
      1,
      NULL,
      1.167481,
      0.945200,
      0,
      0,
      NULL,
      NULL,
      2,
      1.386188,
      1,
      7.761287,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      2.714869,
      NULL,
      NULL,
      3.320663,
      17.742490,
      0.270790,
      3.981667,
      NULL,
      14,
      62,
      NULL,
      0.835406,
      1.032913,
      3.556029,
      '34214',
      NULL,
      '',
      1.078468,
      '',
      '',
      '',
      0.027544,
      '',
      NULL,
      '',
      2,
      3.420571,
      129,
      NULL,
      3,
      23,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1,
      1.533124,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.394418,
      3,
      4.826504,
      0.763213,
      1.969751,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.196408,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.901504,
      NULL,
      NULL,
      0.613225,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.098875,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.789626,
      NULL,
      NULL,
      0.928613,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.080920,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.349834,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.185034,
      NULL,
      2.597450,
      5.414172,
      3.315195,
      NULL,
      0.717143,
      2.515449,
      1,
      NULL,
      NULL,
      NULL,
      3.272797,
      1,
      NULL,
      NULL,
      1.710135,
      1.871680,
      3,
      1.446345,
      NULL,
      3,
      2.034653,
      0.822855,
      NULL,
      3.641054,
      NULL,
      0.847809,
      0,
      1.246880,
      1,
      NULL,
      NULL,
      0.534606,
      NULL,
      NULL,
      4.806883,
      5.443743,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.847508,
      1,
      1,
      1.667334,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.695836,
      2.328357,
      0,
      2,
      0.861391,
      1,
      0.081675,
      NULL,
      NULL,
      NULL,
      NULL,
      0.010240,
      NULL,
      NULL,
      NULL,
      0.613946,
      NULL,
      NULL,
      NULL,
      0.856646,
      NULL,
      NULL,
      NULL,
      0.366622,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.256268,
      NULL,
      NULL,
      NULL,
      0.168330,
      NULL,
      NULL,
      NULL,
      0.717239,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.092426,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.837001,
      NULL,
      NULL,
      NULL,
      1.246029,
      NULL,
      NULL,
      NULL,
      2.345693,
      NULL,
      NULL,
      NULL,
      0.246427,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      0.807247,
      NULL,
      3.320175,
      NULL,
      4.493474,
      3.217461,
      2,
      1,
      0,
      0.511309,
      NULL,
      NULL,
      0.857485,
      NULL,
      NULL,
      1.056142,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.005106,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.548099,
      1,
      1,
      0,
      1.190823,
      0.985417,
      1,
      NULL,
      0.578639,
      1,
      1.966551,
      1.215963,
      0,
      0.613304,
      1.028322,
      0.764471,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.800912,
      0,
      NULL,
      1.436573,
      3,
      1.815424,
      NULL,
      4.779606,
      1,
      2.365811,
      0.706879,
      0.135259,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.485709,
      NULL,
      NULL,
      2,
      2,
      NULL,
      1.712022,
      0,
      NULL,
      0.169774,
      0.684379,
      NULL,
      0.801370,
      0.269385,
      NULL,
      0.514158,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      0.755079,
      0,
      1.863092,
      0,
      NULL,
      0.273610,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.626036,
      NULL,
      2,
      NULL,
      1.148867,
      NULL,
      NULL,
      NULL,
      0.935043,
      NULL,
      2,
      NULL,
      0,
      NULL,
      3.348158,
      NULL,
      31.522762,
      2.719603,
      NULL,
      3.520084,
      0,
      NULL,
      3.191815,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.454639,
      NULL,
      NULL,
      NULL,
      1.411217,
      NULL,
      1.957974,
      NULL,
      3,
      NULL,
      1.494708,
      NULL,
      NULL,
      NULL,
      1.397514,
      NULL,
      NULL,
      1,
      NULL,
      0.054597,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.486524,
      2.200231,
      5.367773,
      1.335325,
      NULL,
      NULL,
      91,
      89.452028,
      5.922354,
      1.940538,
      NULL,
      '14323',
      '11422',
      '20314',
      0,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '');
commit;
end;
/


