set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9730010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-10-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2.122568,
      2,
      4.075599,
      2,
      7.213049,
      0.240994,
      3.322599,
      NULL,
      '22',
      NULL,
      42.918552,
      3,
      '2240031',
      2.143358,
      0,
      0,
      NULL,
      '0024',
      NULL,
      0.840770,
      NULL,
      NULL,
      ' 3-20-2003',
      NULL,
      144,
      NULL,
      0,
      2.999322,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 7-22-1995',
      ' 5-22-1998',
      ' 7-25-1986',
      NULL,
      0,
      3,
      3.540116,
      0,
      3,
      9,
      0.877262,
      1.142300,
      50.315009,
      NULL,
      10.839214,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.555923,
      6,
      3.943318,
      3.576652,
      0.485843,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.187100,
      0.997472,
      3.278601,
      1,
      0,
      9.986167,
      0.742527,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      2,
      0,
      1.941824,
      0,
      NULL,
      1,
      2.970540,
      0,
      3.000850,
      NULL,
      1,
      0,
      1.766354,
      1,
      NULL,
      NULL,
      1,
      0.976012,
      NULL,
      0,
      NULL,
      1,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.660513,
      NULL,
      0.321855,
      0.926643,
      0,
      4.988623,
      NULL,
      1.812639,
      1.660350,
      2.011813,
      1,
      0.070936,
      NULL,
      3,
      0.089740,
      1.564156,
      1.080028,
      1,
      NULL,
      NULL,
      1,
      1.300418,
      0.396369,
      5.156487,
      0,
      0.224428,
      9,
      1,
      0,
      1.324661,
      1,
      0.417060,
      1,
      5,
      0,
      9.472678,
      6,
      2.581989,
      5.021318,
      0.688670,
      3,
      7.326869,
      4.047178,
      0,
      5,
      0.446707,
      3,
      3.386293,
      ' 9-28-1976',
      703,
      ' 1-23-2000',
      263,
      0,
      NULL,
      0.331156,
      NULL,
      1.016707,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.798396,
      1.374705,
      1,
      1.571799,
      0.936732,
      NULL,
      1.979364,
      1.431561,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.851124,
      1.556327,
      1.777039,
      0.753583,
      NULL,
      2.049275,
      0,
      3,
      1.826558,
      0.006642,
      3.366349,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.148749,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.066355,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.423297,
      0,
      0,
      0,
      3.890573,
      0,
      0.288327,
      NULL,
      0.106636,
      3.317306,
      2.210588,
      2,
      1,
      1.096072,
      NULL,
      0,
      NULL,
      2.796948,
      1.471464,
      0.196852,
      1.517181,
      NULL,
      1,
      2.976746,
      1.231453,
      1,
      1,
      1,
      2,
      0.172232,
      9,
      6,
      NULL,
      0,
      11,
      2.592309,
      NULL,
      2,
      4.678482,
      3.724172,
      2.887403,
      0,
      NULL,
      0,
      3.234234,
      16,
      NULL,
      NULL,
      59.937222,
      0.145032,
      4.685320,
      1,
      NULL,
      '',
      '',
      0.272634,
      NULL,
      '',
      '',
      0,
      '',
      '',
      NULL,
      NULL,
      NULL,
      264,
      NULL,
      1.839481,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.520945,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.796327,
      NULL,
      NULL,
      NULL,
      1.065921,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.809796,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      0,
      3,
      1,
      4.201952,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.985600,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.288523,
      NULL,
      NULL,
      0.461759,
      NULL,
      NULL,
      NULL,
      0.673643,
      0,
      3.423818,
      NULL,
      3.766103,
      0,
      0.084898,
      NULL,
      0.071663,
      0,
      0,
      2,
      NULL,
      0.362520,
      0,
      1.195216,
      NULL,
      NULL,
      1.425190,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.634573,
      0,
      1.754316,
      1.387099,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.822296,
      NULL,
      NULL,
      1.907012,
      NULL,
      NULL,
      0,
      3.801809,
      0,
      NULL,
      NULL,
      NULL,
      0.793100,
      2,
      2,
      0,
      1.323782,
      1.419468,
      0.689309,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.623422,
      NULL,
      NULL,
      0.032156,
      NULL,
      NULL,
      1.290858,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.115692,
      0.624610,
      3,
      5,
      0,
      7,
      NULL,
      NULL,
      1.972794,
      0.656809,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      3,
      0,
      1.744786,
      NULL,
      NULL,
      2.681510,
      NULL,
      7.145117,
      1.684905,
      2,
      1.135133,
      0,
      0,
      NULL,
      3,
      2,
      1,
      0,
      3,
      3.503746,
      1,
      0,
      7.161948,
      0,
      NULL,
      NULL,
      2.169448,
      NULL,
      NULL,
      0,
      0.923681,
      0,
      1,
      1.501443,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.026874,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.173060,
      NULL,
      NULL,
      0.134083,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.237405,
      3,
      1.541499,
      NULL,
      NULL,
      3.404916,
      1,
      NULL,
      NULL,
      0.746882,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.315639,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.230956,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.172441,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.989429,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.961709,
      NULL,
      NULL,
      NULL,
      2.726890,
      2.651510,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.685024,
      NULL,
      1,
      NULL,
      0.086252,
      0,
      1,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      0.739052,
      0.443896,
      1,
      1,
      0,
      0.103502,
      0,
      0.184057,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.212825,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      2,
      5,
      NULL,
      2,
      3.962109,
      1.674204,
      NULL,
      2.025916,
      NULL,
      NULL,
      0.460483,
      NULL,
      1.498016,
      0.617512,
      NULL,
      NULL,
      2.845540,
      NULL,
      0.069028,
      1,
      NULL,
      1.163230,
      NULL,
      NULL,
      0.972195,
      0.318514,
      NULL,
      2.125948,
      0,
      NULL,
      0.185633,
      1.829431,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3.161302,
      NULL,
      NULL,
      1.852329,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.652130,
      NULL,
      4,
      4,
      5.362173,
      1.022771,
      NULL,
      0.773762,
      25,
      2,
      3.583102,
      1.871858,
      3,
      '11243',
      '',
      '',
      1,
      '',
      '',
      NULL,
      0.597884,
      NULL,
      '',
      '');
commit;
end;
/


