set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9611946';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-6-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3,
      '2020',
      3.828906,
      0,
      NULL,
      NULL,
      ' 3- 8-1984',
      95.407128,
      NULL,
      3.202288,
      1,
      0.356538,
      ' 4- 2-1989',
      4.539021,
      3,
      107,
      73,
      1.042813,
      ' 2-16-1985',
      ' 1- 9-1976',
      ' 1-26-2000',
      2.379631,
      0,
      3.220016,
      0,
      1,
      NULL,
      2.484283,
      1,
      NULL,
      NULL,
      5.067320,
      7.470230,
      4,
      8,
      14.890144,
      6,
      27,
      NULL,
      1,
      0.040555,
      3.045688,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      6,
      1.162064,
      3,
      1.028809,
      3.891971,
      3,
      5,
      4.392727,
      NULL,
      3.075500,
      1,
      1.389113,
      2,
      NULL,
      NULL,
      1.669359,
      NULL,
      0.362499,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.862572,
      2,
      7.971203,
      NULL,
      NULL,
      1,
      0,
      0.877994,
      2,
      NULL,
      3.922177,
      1,
      NULL,
      2.990170,
      0.377399,
      2,
      3,
      1.372186,
      0,
      2.197394,
      2.449246,
      NULL,
      NULL,
      NULL,
      2.047729,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.305618,
      0,
      3,
      4.872101,
      NULL,
      5,
      3,
      0,
      1,
      NULL,
      1.806028,
      5.769236,
      1.441426,
      6,
      NULL,
      0.926232,
      1,
      0.443477,
      0.379775,
      NULL,
      0.666314,
      NULL,
      0.842263,
      3.686376,
      1,
      1,
      3,
      NULL,
      1,
      0.844971,
      1,
      0.437535,
      0.006691,
      6,
      2.417170,
      5.573218,
      NULL,
      6,
      8,
      3,
      NULL,
      NULL,
      5.523690,
      3.034009,
      NULL,
      0.843316,
      1.697203,
      NULL,
      NULL,
      520.940776,
      '11-12-1977',
      660.630398,
      1,
      1,
      1.733630,
      0.981987,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      3,
      1,
      NULL,
      1,
      1.031272,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.863958,
      NULL,
      NULL,
      NULL,
      NULL,
      2.221317,
      NULL,
      0.389109,
      NULL,
      0,
      1.828335,
      NULL,
      0,
      NULL,
      0.896818,
      1,
      NULL,
      2.758599,
      0,
      8.247307,
      4.273335,
      NULL,
      0.448372,
      0,
      NULL,
      NULL,
      NULL,
      0.349514,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.819127,
      NULL,
      0,
      NULL,
      1.644645,
      1,
      1,
      0.353693,
      46,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.243765,
      0,
      0.614018,
      2.031942,
      3,
      NULL,
      0,
      5,
      1,
      3.923290,
      NULL,
      1.437178,
      2.579062,
      0.453961,
      1.770439,
      0,
      8,
      1,
      1.041652,
      0.038423,
      NULL,
      NULL,
      1.563064,
      NULL,
      0.449183,
      1,
      NULL,
      1,
      0.470725,
      5,
      10.043385,
      6.667360,
      1.956640,
      8,
      NULL,
      1,
      1.223073,
      7.105982,
      2.866394,
      3.071629,
      1.368818,
      9,
      1.959174,
      NULL,
      NULL,
      10,
      44.861123,
      28.243905,
      1,
      1.457868,
      2.603034,
      '23313',
      '',
      '',
      0,
      '',
      '',
      NULL,
      NULL,
      '24441',
      '10000',
      '',
      3.584704,
      NULL,
      500.770031,
      12,
      2,
      30,
      NULL,
      NULL,
      4,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.128157,
      NULL,
      NULL,
      2.714494,
      NULL,
      NULL,
      3.886001,
      0.084582,
      1.950906,
      2,
      0.566044,
      1.748996,
      1.321575,
      2,
      NULL,
      NULL,
      0.805705,
      1,
      1.470311,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.534665,
      3,
      1.495802,
      3.828475,
      0,
      0,
      5,
      0.315397,
      4.211177,
      1.466126,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.652455,
      3.279744,
      1.643836,
      3,
      0,
      1,
      NULL,
      NULL,
      2,
      2.177404,
      2.623918,
      2.344176,
      2,
      0.167293,
      1,
      0,
      2.794178,
      1,
      0,
      NULL,
      0.225954,
      NULL,
      2,
      1,
      1.884828,
      NULL,
      NULL,
      3.699101,
      3,
      0,
      3,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      0.830414,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      1,
      NULL,
      0.765892,
      NULL,
      NULL,
      7,
      NULL,
      1,
      NULL,
      0.186525,
      1,
      0,
      0,
      3.779130,
      5.798899,
      2,
      2,
      1.088385,
      NULL,
      NULL,
      0.359267,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.359946,
      NULL,
      NULL,
      1.785147,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.504494,
      NULL,
      1,
      3,
      2,
      0.077286,
      0,
      3.059127,
      NULL,
      7.381570,
      4,
      4.562812,
      1,
      NULL,
      1.157029,
      2.865804,
      0.330793,
      NULL,
      NULL,
      NULL,
      3.834453,
      3,
      2.652365,
      0.482712,
      3,
      2.067166,
      7.979403,
      NULL,
      NULL,
      NULL,
      1.545888,
      2,
      1.600550,
      2,
      NULL,
      3,
      1,
      3,
      2.584376,
      0.255489,
      9.831942,
      4,
      1.533067,
      3.325162,
      4.988794,
      0.116185,
      1,
      3,
      1.741759,
      NULL,
      1,
      0.003471,
      NULL,
      1.871148,
      NULL,
      NULL,
      0.692368,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.115549,
      NULL,
      NULL,
      2.251337,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.357817,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      1.502995,
      3.470271,
      0,
      1.268754,
      0.474083,
      1,
      1.150624,
      NULL,
      NULL,
      6.354642,
      NULL,
      NULL,
      NULL,
      2.090975,
      NULL,
      NULL,
      NULL,
      3.562982,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.161369,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.454430,
      NULL,
      NULL,
      NULL,
      3.155555,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.559332,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.693445,
      NULL,
      NULL,
      NULL,
      2.856730,
      NULL,
      NULL,
      NULL,
      3.175021,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3.866611,
      2.601341,
      NULL,
      580,
      1,
      219,
      29,
      0,
      NULL,
      NULL,
      3.758477,
      61,
      20.276310,
      1.100414,
      NULL,
      NULL,
      1.616626,
      186.678407,
      44,
      1.971016,
      NULL,
      1.203173,
      NULL,
      2,
      1.325991,
      NULL,
      1,
      1,
      NULL,
      0.409147,
      0.312640,
      0.506186,
      NULL,
      1.175068,
      0,
      NULL,
      0,
      0,
      NULL,
      0.213745,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.992873,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.803581,
      1,
      0.428695,
      NULL,
      0.683881,
      0,
      2,
      2,
      2.849656,
      2.687464,
      1,
      0.891408,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.985896,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      0.063910,
      1.837424,
      NULL,
      0,
      0.271976,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.222932,
      NULL,
      1,
      1.989750,
      NULL,
      0.069107,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.372905,
      NULL,
      6,
      0,
      4,
      0,
      NULL,
      NULL,
      NULL,
      65,
      NULL,
      4,
      1,
      '42212',
      '',
      '',
      1.121317,
      NULL,
      NULL,
      '',
      5.058410,
      NULL,
      '13221',
      NULL);
commit;
end;
/


