set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9655708';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-4-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '43',
      '11',
      32,
      1,
      '2424141',
      0.735887,
      1,
      0,
      2,
      '3221',
      2.986823,
      0,
      NULL,
      NULL,
      ' 5-11-1997',
      38.332512,
      6.888524,
      NULL,
      3.881192,
      0.093685,
      ' 0-13-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      2.493079,
      NULL,
      ' 0-18-1982',
      ' 8-14-1982',
      0.593701,
      NULL,
      2,
      1.539860,
      0.436709,
      NULL,
      1.615105,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.517604,
      NULL,
      0,
      NULL,
      0.113495,
      0,
      0,
      NULL,
      1,
      0.054394,
      0.486390,
      0.101487,
      0,
      NULL,
      5.505504,
      5.624180,
      NULL,
      0.675868,
      NULL,
      0.995582,
      0.932588,
      0.923821,
      0,
      0,
      1,
      NULL,
      NULL,
      1.771681,
      0.764844,
      3.612194,
      0.808188,
      1,
      0.468505,
      1.741564,
      1.946404,
      NULL,
      NULL,
      1.248325,
      NULL,
      NULL,
      4.573414,
      1.743052,
      1.658899,
      2.075802,
      1.208426,
      1,
      2.071354,
      NULL,
      NULL,
      0,
      1,
      1.545429,
      1.689215,
      2,
      1.690607,
      0.531893,
      NULL,
      NULL,
      0.420952,
      1,
      NULL,
      1.370739,
      3.761125,
      1,
      2.480102,
      0.707778,
      0,
      NULL,
      NULL,
      1.867413,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.922719,
      1,
      1,
      1.985022,
      0,
      0,
      0,
      0.309209,
      0,
      1.364052,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.820310,
      0.282816,
      0,
      0.169532,
      1.124950,
      1.881470,
      0.319156,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      3.248888,
      1.991898,
      2,
      8,
      0.497689,
      1,
      0,
      2,
      1.516538,
      7,
      0.882406,
      3.478708,
      1,
      5,
      0.765797,
      ' 9- 2-1998',
      5,
      ' 3-11-1979',
      2.306339,
      1,
      1,
      NULL,
      7.330987,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.738958,
      1.712521,
      0.657140,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.582730,
      NULL,
      0,
      2,
      1.125946,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1.732966,
      NULL,
      3.345631,
      5.912411,
      1,
      1.373022,
      0,
      0.559605,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.235634,
      0.306534,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.240353,
      0.996152,
      1,
      3,
      3.834582,
      3,
      0.228110,
      NULL,
      NULL,
      NULL,
      NULL,
      0.461825,
      NULL,
      0.882120,
      2,
      1,
      1.108545,
      0.956956,
      0,
      4.030591,
      4,
      5,
      4.573625,
      3,
      0.956669,
      2,
      0.809275,
      2,
      0.465749,
      0,
      NULL,
      1,
      NULL,
      1.009925,
      1.539972,
      1,
      1.463348,
      1,
      1.209801,
      3,
      5.971481,
      1,
      NULL,
      NULL,
      2,
      1.497021,
      4,
      NULL,
      3.558204,
      0,
      4.927939,
      1,
      NULL,
      2.556360,
      5,
      0.427434,
      NULL,
      31.818740,
      NULL,
      18,
      NULL,
      0.027969,
      3,
      1.543978,
      '34201',
      '',
      '',
      1,
      NULL,
      '',
      '',
      0,
      '',
      NULL,
      '',
      NULL,
      16.532063,
      NULL,
      29,
      NULL,
      24,
      NULL,
      0.837502,
      NULL,
      3,
      0,
      NULL,
      1.919885,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.284000,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.207607,
      NULL,
      NULL,
      3.741142,
      3.968639,
      1,
      2,
      NULL,
      0,
      1.153205,
      NULL,
      NULL,
      1.465341,
      NULL,
      NULL,
      0.824611,
      NULL,
      NULL,
      0.492003,
      NULL,
      NULL,
      3.245862,
      5.048818,
      1.558124,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.411589,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.374356,
      1.859213,
      3,
      0,
      NULL,
      NULL,
      1.151881,
      2,
      3,
      0.856105,
      0.244148,
      NULL,
      3,
      1.034686,
      NULL,
      NULL,
      NULL,
      0.742114,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.064269,
      4,
      0,
      1.055960,
      0.733838,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.687046,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.765463,
      NULL,
      NULL,
      0.464896,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.024810,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.747836,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.325670,
      NULL,
      NULL,
      1.414832,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      0.570519,
      0,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      0.140568,
      2,
      0,
      NULL,
      NULL,
      NULL,
      2,
      4.152353,
      3.725980,
      2,
      1.865708,
      0,
      0.170324,
      2,
      1,
      2,
      NULL,
      2.539929,
      1.197335,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      3.619215,
      1,
      1.354359,
      NULL,
      2,
      5.024493,
      NULL,
      1,
      0,
      NULL,
      0.577637,
      2.549341,
      NULL,
      NULL,
      0.983260,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.816995,
      NULL,
      NULL,
      1.892617,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.642978,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.998348,
      3.999530,
      1.208929,
      0.372086,
      1,
      0,
      3.389130,
      NULL,
      NULL,
      6.445093,
      5,
      NULL,
      NULL,
      1,
      17.374092,
      NULL,
      NULL,
      1.760252,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.210960,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.160941,
      NULL,
      NULL,
      NULL,
      0.270886,
      NULL,
      NULL,
      NULL,
      1.089237,
      NULL,
      NULL,
      NULL,
      0,
      1.849972,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      2,
      0.131642,
      NULL,
      NULL,
      1.762930,
      1.221186,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      3.766779,
      1.698485,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      3.062269,
      0,
      3,
      NULL,
      1,
      13.976084,
      2380,
      NULL,
      5.785027,
      NULL,
      0.896147,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.066855,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.215355,
      NULL,
      1,
      96,
      NULL,
      0,
      0.098819,
      0,
      0,
      1.657656,
      1,
      1.981332,
      1.888456,
      NULL,
      1.730281,
      0.940359,
      1,
      1.423696,
      0.592100,
      1,
      NULL,
      0.294893,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.751644,
      3,
      4,
      5,
      NULL,
      5.212828,
      0,
      NULL,
      1.860610,
      1,
      1.780651,
      0.445033,
      1.003741,
      0.622365,
      0.669991,
      0,
      NULL,
      1.356543,
      1,
      NULL,
      0,
      0,
      0.867173,
      0,
      NULL,
      1.663672,
      0.342605,
      NULL,
      0.736233,
      0.851697,
      0.393607,
      0.017763,
      NULL,
      NULL,
      1.687117,
      0,
      NULL,
      1,
      1.969382,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.098383,
      0,
      1.006299,
      NULL,
      1,
      2,
      1,
      3.047110,
      1.217523,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      '',
      '',
      0.529931,
      NULL,
      '',
      '',
      0,
      '',
      '',
      NULL);
commit;
end;
/


