set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9101607';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-7-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '3',
      NULL,
      NULL,
      '4442240',
      3.019292,
      0.997849,
      3,
      NULL,
      '1124',
      0,
      1.909635,
      NULL,
      NULL,
      ' 0-24-2002',
      18.698832,
      NULL,
      2,
      0,
      1.422561,
      ' 6-25-1974',
      5.873857,
      2.512185,
      150.176708,
      NULL,
      NULL,
      NULL,
      ' 5- 0-1976',
      ' 2-18-1992',
      0.544086,
      1.393799,
      3,
      NULL,
      0.804573,
      0,
      3,
      0.886453,
      1,
      2,
      5.689271,
      NULL,
      1,
      7,
      NULL,
      3.301248,
      20,
      6,
      NULL,
      2.061481,
      1.614341,
      2,
      0,
      0,
      0,
      NULL,
      1.720494,
      1.028569,
      1,
      1,
      0,
      1.876313,
      5.278548,
      0,
      3.334861,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      3.622793,
      NULL,
      1.806707,
      0,
      NULL,
      0.093622,
      2,
      0,
      3.878114,
      1.829790,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1.494047,
      2,
      3.783383,
      1.042951,
      1.484997,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      7.060000,
      0,
      NULL,
      2.336361,
      0.285735,
      NULL,
      NULL,
      NULL,
      1.987153,
      NULL,
      NULL,
      1.137680,
      0,
      0,
      0.194444,
      1,
      7.076706,
      0.178878,
      0,
      3.032413,
      3,
      NULL,
      0.713394,
      1.808599,
      NULL,
      NULL,
      0,
      1.656287,
      0,
      1.558317,
      NULL,
      NULL,
      1,
      NULL,
      3.925159,
      4,
      4,
      3.814050,
      4.963530,
      NULL,
      1,
      2,
      NULL,
      4,
      6.742744,
      7.766300,
      1.164395,
      1,
      9,
      NULL,
      4,
      1.991209,
      NULL,
      0,
      6,
      5,
      NULL,
      7.755389,
      0.875132,
      ' 5-21-1996',
      NULL,
      ' 0-10-1987',
      30,
      NULL,
      1.310530,
      0.955278,
      1,
      1.619887,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.487588,
      3,
      5.472809,
      1.449062,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      22.487906,
      1.431403,
      2.279952,
      4.717219,
      1.566637,
      0,
      0,
      0,
      0.028900,
      2.230002,
      NULL,
      NULL,
      3.658497,
      1.739864,
      1,
      1,
      1.926617,
      3.229909,
      7,
      1,
      7,
      1,
      0,
      NULL,
      NULL,
      3.409685,
      10,
      2,
      0.483499,
      5,
      1,
      NULL,
      ' 6-23-1989',
      1,
      ' 3-18-2000',
      NULL,
      NULL,
      0,
      1,
      NULL,
      2,
      0,
      NULL,
      0,
      3,
      3.549223,
      0,
      2.548586,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0.133831,
      1.734867,
      NULL,
      3,
      3.333805,
      7,
      3.702398,
      2,
      2,
      0.742610,
      1.442353,
      0,
      0.018182,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.836534,
      NULL,
      NULL,
      0.496133,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      1.324216,
      2,
      3,
      1.486622,
      7,
      11,
      2.679799,
      9,
      4.721934,
      6,
      0.835525,
      2,
      5.345918,
      NULL,
      0.475563,
      2.447179,
      23.697174,
      3,
      NULL,
      NULL,
      4,
      51.273149,
      NULL,
      2.547796,
      NULL,
      3,
      '10201',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      0.638471,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0,
      NULL,
      2,
      0.623990,
      NULL,
      NULL,
      0,
      1.954305,
      1.494087,
      1,
      NULL,
      NULL,
      0.571880,
      3.765003,
      0,
      0,
      14.303557,
      1.073695,
      57.142349,
      0.993052,
      1.582711,
      NULL,
      1,
      1.682794,
      0,
      1.857668,
      NULL,
      1,
      0.976056,
      0.472915,
      NULL,
      0.445644,
      NULL,
      1.373305,
      NULL,
      0.837124,
      0,
      0.903020,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.095876,
      NULL,
      NULL,
      3.462111,
      5.069487,
      1.680815,
      NULL,
      6,
      NULL,
      0.983784,
      NULL,
      0.763438,
      1.869675,
      NULL,
      0,
      0.600522,
      NULL,
      0.422671,
      0,
      NULL,
      0,
      0.619861,
      NULL,
      0.813946,
      0.286007,
      NULL,
      1,
      1.262633,
      NULL,
      1.075956,
      0.050104,
      NULL,
      NULL,
      NULL,
      NULL,
      0.682557,
      1,
      NULL,
      1.195122,
      0.313756,
      NULL,
      1.276776,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.571104,
      NULL,
      1,
      NULL,
      1.202274,
      NULL,
      NULL,
      6.104918,
      5,
      1,
      NULL,
      NULL,
      NULL,
      111.290083,
      NULL,
      NULL,
      0.901349,
      '43424',
      '',
      NULL,
      1.802604,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


