set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9101607';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-2-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      '0022232',
      2.678010,
      0,
      1,
      NULL,
      '4311',
      3,
      NULL,
      NULL,
      NULL,
      ' 8-23-1994',
      53.792245,
      NULL,
      3.118934,
      1,
      0.605446,
      ' 3- 3-1978',
      29.250225,
      NULL,
      313,
      NULL,
      3,
      ' 2-16-1996',
      NULL,
      ' 7-16-1989',
      0,
      NULL,
      1,
      2.870120,
      1.694089,
      1.231099,
      0,
      0.264678,
      1,
      NULL,
      NULL,
      9.360913,
      NULL,
      20.390139,
      3,
      NULL,
      25,
      NULL,
      4.944730,
      NULL,
      1.895905,
      2,
      1,
      1,
      NULL,
      0.853283,
      1.911753,
      4.722477,
      0,
      0.021196,
      0.148035,
      3.220358,
      2.921260,
      3,
      0,
      8.505671,
      0,
      4,
      1,
      NULL,
      0.572651,
      NULL,
      0.511019,
      0,
      1,
      0,
      0.909148,
      4.141552,
      0.655880,
      1,
      0.037062,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.913030,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.551625,
      1.167723,
      NULL,
      7.762302,
      0,
      3.457094,
      1.274145,
      NULL,
      NULL,
      NULL,
      1.775979,
      NULL,
      NULL,
      0.231555,
      0,
      3.680466,
      1,
      NULL,
      NULL,
      1.150821,
      0,
      0.270693,
      1,
      NULL,
      1.695445,
      0,
      4.325719,
      1,
      1,
      0,
      1.361274,
      NULL,
      NULL,
      0.397010,
      0,
      1,
      1.462583,
      1,
      1,
      0,
      1.008758,
      1,
      NULL,
      1,
      0,
      0.575645,
      4.029125,
      2.620576,
      6.993100,
      2.886587,
      6,
      6.864030,
      5.863224,
      3.199538,
      5,
      3.388661,
      2.654520,
      5.762143,
      7.958442,
      6,
      3,
      ' 3-12-2000',
      81,
      ' 8-10-1981',
      NULL,
      1.916151,
      1.726917,
      1,
      2.997942,
      1.419284,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.555378,
      1,
      1,
      1.094124,
      1.835385,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.767387,
      NULL,
      4.226656,
      3,
      NULL,
      6,
      0,
      3,
      0.990806,
      0,
      5,
      0.075615,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.320774,
      1.111979,
      1,
      1.924748,
      3.384940,
      2.441653,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.520701,
      NULL,
      0,
      NULL,
      1,
      3.421494,
      1.855571,
      1,
      NULL,
      1.808183,
      1,
      NULL,
      NULL,
      NULL,
      1.758031,
      1,
      0,
      NULL,
      0,
      NULL,
      3.889690,
      2,
      0,
      0,
      NULL,
      1,
      1,
      0.157092,
      2.376265,
      3.426736,
      3,
      3.724280,
      0.990435,
      4.192550,
      1,
      0,
      0,
      1.279641,
      0.055501,
      1,
      NULL,
      1.720981,
      0.182626,
      1.696938,
      2.183773,
      1.644168,
      7.414564,
      3.558490,
      1.135874,
      NULL,
      NULL,
      5,
      0.069070,
      0.319132,
      7,
      3.691319,
      2,
      0,
      54,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      30,
      3.455448,
      1.362843,
      2.116057,
      '40233',
      '',
      '',
      1.840514,
      '',
      NULL,
      '',
      0.724656,
      NULL,
      '',
      '',
      1,
      39,
      NULL,
      10,
      2.587266,
      10.764450,
      2.267570,
      7,
      4.390392,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.171960,
      0.083225,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.886883,
      1,
      NULL,
      NULL,
      1.819048,
      NULL,
      NULL,
      NULL,
      NULL,
      1.447410,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1,
      0,
      0,
      NULL,
      NULL,
      1.601518,
      2,
      1.061727,
      0.110350,
      1,
      NULL,
      NULL,
      NULL,
      1.089478,
      NULL,
      NULL,
      NULL,
      2.445982,
      1,
      0.573080,
      1.849359,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.663575,
      0.045029,
      0.182598,
      2.279374,
      NULL,
      1,
      1.191911,
      NULL,
      1.148733,
      0,
      NULL,
      NULL,
      3,
      0,
      0.710517,
      0.007871,
      0.077279,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.171221,
      0,
      1,
      4.264365,
      2,
      0.627711,
      NULL,
      NULL,
      NULL,
      NULL,
      1.046036,
      1.138036,
      0.999755,
      1,
      1.153441,
      NULL,
      NULL,
      3,
      1.696354,
      1.317751,
      2.211682,
      0,
      3,
      1.106945,
      NULL,
      NULL,
      NULL,
      NULL,
      0.613047,
      0.596407,
      NULL,
      1,
      2.852127,
      1,
      0,
      7,
      NULL,
      NULL,
      0.069260,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.120779,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1.837235,
      NULL,
      NULL,
      NULL,
      3.224467,
      0,
      1,
      3.492090,
      4.491204,
      0,
      3,
      NULL,
      1,
      1,
      NULL,
      3.974138,
      1,
      0,
      3,
      3,
      NULL,
      NULL,
      4.246526,
      8,
      3.828047,
      2.252776,
      0,
      1.950043,
      0,
      2.450445,
      1,
      2,
      3.073061,
      2.190070,
      1,
      3.215793,
      2,
      3,
      6.563158,
      NULL,
      7.261762,
      0,
      1.876250,
      0,
      2,
      0,
      1.399755,
      NULL,
      NULL,
      0.134047,
      0,
      2.743658,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.742245,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.683376,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.549325,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.961526,
      0.327233,
      2,
      NULL,
      1.848741,
      0.687723,
      NULL,
      0.449647,
      NULL,
      NULL,
      1,
      38,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.953203,
      0.982061,
      0.585563,
      NULL,
      NULL,
      NULL,
      1.138767,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.418419,
      NULL,
      0.258394,
      1,
      2.131727,
      NULL,
      0,
      NULL,
      2,
      NULL,
      1.192216,
      1.834026,
      1,
      NULL,
      3.857321,
      3.439555,
      3.109056,
      NULL,
      1.055714,
      NULL,
      0.553176,
      NULL,
      0.651184,
      1,
      1.390122,
      NULL,
      1,
      1,
      NULL,
      NULL,
      3.494931,
      3.282599,
      0.650762,
      NULL,
      NULL,
      NULL,
      0.120124,
      NULL,
      0.458217,
      1.835277,
      2.283954,
      NULL,
      1,
      0.613077,
      13,
      NULL,
      NULL,
      5.241873,
      2.789444,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      23.296734,
      2.341449,
      NULL,
      2.835133,
      2,
      0,
      NULL,
      NULL,
      3.380340,
      1.459143,
      0,
      1.977722,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.262275,
      0,
      189,
      0,
      0.696254,
      1,
      1,
      1,
      0,
      NULL,
      1,
      0,
      0.510223,
      0.228959,
      0,
      0.549279,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.191625,
      3,
      7.855044,
      3.330087,
      NULL,
      NULL,
      NULL,
      13.126602,
      0.359121,
      3,
      2,
      0,
      1.901090,
      1.043736,
      1.789516,
      NULL,
      1,
      3,
      3.729882,
      1,
      NULL,
      1,
      1.490610,
      0,
      2.573213,
      2,
      3.462645,
      0,
      2,
      1.570426,
      NULL,
      3.046896,
      2,
      1,
      2.211349,
      0.876449,
      0.065434,
      NULL,
      0.849704,
      0,
      2,
      1,
      0.448360,
      2,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.540306,
      NULL,
      0,
      10,
      3,
      0,
      0,
      1,
      NULL,
      2,
      NULL,
      2,
      3,
      NULL,
      0.272780,
      1.584015,
      0,
      1.698018,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      16,
      0,
      NULL,
      1,
      0.414553,
      1.861819,
      0.026437,
      0,
      1.879003,
      0,
      5,
      8,
      1.121265,
      NULL,
      NULL,
      31,
      57,
      1.734937,
      1,
      0.590953,
      NULL,
      '',
      NULL,
      0.480984,
      '',
      '',
      '',
      0.165297,
      '',
      '',
      '');
commit;
end;
/


