set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9976944';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-12-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3.014802,
      NULL,
      NULL,
      NULL,
      1.050963,
      3.764912,
      9.288466,
      3.494399,
      '444',
      '34101202',
      NULL,
      63,
      '1341343',
      2,
      1.261034,
      3,
      0,
      '2321',
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      51,
      24.289018,
      NULL,
      0,
      3.341070,
      ' 1-21-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 3-17-1992',
      ' 8- 4-2001',
      ' 5- 6-2002',
      0,
      1,
      2.145043,
      3,
      1.174007,
      1.196781,
      NULL,
      1.790388,
      1,
      7,
      3.269742,
      8.832407,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      1,
      NULL,
      1.799675,
      1.669982,
      1,
      0.403125,
      0,
      1.063869,
      1.049917,
      2.964600,
      1,
      0.551961,
      NULL,
      1.450985,
      1,
      0.169783,
      0,
      0.168333,
      2.704176,
      NULL,
      0,
      5.935749,
      1,
      1,
      1,
      1,
      0,
      10.575126,
      2,
      1,
      4,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6.012683,
      NULL,
      7.041458,
      NULL,
      0.983730,
      1.856695,
      NULL,
      1,
      2,
      1.165987,
      0,
      3.172249,
      1,
      NULL,
      0,
      1,
      1.445216,
      1.295789,
      NULL,
      3.321697,
      1.636507,
      NULL,
      3,
      NULL,
      1.710570,
      0.733942,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      7.749760,
      NULL,
      5.333601,
      6.752341,
      4.111172,
      4,
      2.015938,
      0,
      NULL,
      0,
      1.101592,
      0.279354,
      5,
      1,
      1.109076,
      0.397958,
      1,
      0.389028,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      0.910620,
      2,
      1,
      1.658346,
      0.576350,
      NULL,
      5.421625,
      1.577270,
      8.045254,
      5,
      NULL,
      7,
      2,
      NULL,
      NULL,
      0.859503,
      3.968253,
      3,
      4,
      NULL,
      7,
      3,
      NULL,
      ' 7- 2-1987',
      11.536195,
      ' 9- 9-1975',
      NULL,
      0,
      0.265597,
      1.641307,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.653271,
      5.270008,
      6.453533,
      6,
      3,
      0,
      3.522236,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.140519,
      NULL,
      NULL,
      NULL,
      NULL,
      8.676054,
      NULL,
      1.291496,
      0,
      3,
      15.997609,
      3.965715,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.019693,
      0,
      1.411172,
      0.464414,
      1.890224,
      NULL,
      1.841953,
      NULL,
      NULL,
      NULL,
      1.766735,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.346537,
      0,
      1,
      2,
      NULL,
      1.420836,
      0.615703,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.596801,
      1,
      0,
      3.304831,
      3,
      0.499535,
      2,
      2.662725,
      1.267682,
      1,
      3,
      3,
      3,
      1.030902,
      2,
      3.350669,
      1,
      1,
      1,
      2,
      0,
      1,
      NULL,
      1,
      0,
      0,
      1.534103,
      1.424631,
      1.398180,
      0,
      0.392753,
      0,
      2.870079,
      1.988822,
      2.635971,
      NULL,
      NULL,
      3,
      2.907659,
      3,
      3.744716,
      2.222664,
      3,
      NULL,
      40.887158,
      1,
      2,
      NULL,
      NULL,
      47.165565,
      51,
      0,
      NULL,
      4,
      '11301',
      '04240',
      NULL,
      NULL,
      NULL,
      '',
      '',
      NULL,
      '01221',
      '40013',
      '',
      1,
      6.078849,
      1.321982,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.008408,
      NULL,
      1.248444,
      NULL,
      1,
      NULL,
      NULL,
      3.900901,
      0.610831,
      0,
      3,
      1.556736,
      NULL,
      1.940114,
      NULL,
      NULL,
      1.936913,
      NULL,
      0,
      42.696808,
      2.303518,
      1.889730,
      1.282930,
      NULL,
      0.648975,
      1,
      NULL,
      0.394448,
      NULL,
      0,
      NULL,
      0.255298,
      NULL,
      1.133923,
      NULL,
      1,
      0.055073,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.468549,
      3,
      1,
      NULL,
      NULL,
      0.309926,
      NULL,
      NULL,
      NULL,
      1.875776,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.481923,
      0,
      0.880746,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.912387,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.748719,
      NULL,
      1.556124,
      0.371641,
      0.320504,
      NULL,
      0.525999,
      NULL,
      NULL,
      NULL,
      0.864299,
      NULL,
      1.735608,
      NULL,
      0.859486,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.544608,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2.098647,
      NULL,
      1,
      NULL,
      639,
      NULL,
      1,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0.575649,
      1,
      18,
      NULL,
      1.247768,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.016589,
      0,
      3.423223,
      1.540787,
      4.678421,
      2,
      9,
      0,
      1.677926,
      NULL,
      1.378481,
      1,
      NULL,
      3,
      0,
      NULL,
      2,
      1.283056,
      NULL,
      0.054846,
      NULL,
      NULL,
      2.059214,
      NULL,
      NULL,
      1,
      0.186489,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.031266,
      NULL,
      1,
      2.140421,
      NULL,
      0,
      0.347632,
      NULL,
      0.946595,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.706463,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.984209,
      NULL,
      0,
      NULL,
      1,
      NULL,
      5.733887,
      0,
      NULL,
      NULL,
      73.121004,
      64.443748,
      4.310435,
      1.412464,
      1.296955,
      NULL,
      '41233',
      '31042',
      3.635503,
      '01413',
      '',
      '',
      5,
      '11241',
      NULL,
      NULL);
commit;
end;
/


