set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8609467';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-9-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '2',
      NULL,
      NULL,
      '1022104',
      2.078097,
      1.112511,
      1,
      3,
      '0400',
      NULL,
      0.165247,
      0,
      18.197752,
      NULL,
      NULL,
      NULL,
      NULL,
      3.153090,
      1.305234,
      '10-11-1980',
      64,
      1,
      332.559056,
      40.249225,
      3.519044,
      NULL,
      NULL,
      '10-25-1983',
      2,
      0,
      0,
      NULL,
      1.836985,
      NULL,
      3.715545,
      3,
      NULL,
      NULL,
      NULL,
      10,
      0,
      95.164857,
      17,
      0.316389,
      1.676516,
      2.196202,
      6.308277,
      6,
      1,
      1,
      1.882241,
      1,
      1,
      0.934991,
      1,
      1,
      0.714605,
      0,
      88,
      9.427525,
      0,
      3,
      2,
      NULL,
      NULL,
      0.510737,
      0,
      1,
      1.608561,
      4,
      1.275885,
      1,
      1.542533,
      1,
      1.647316,
      0,
      1,
      0.531303,
      1.620855,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.816774,
      NULL,
      1.231736,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.279252,
      0.386929,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.516985,
      3.531460,
      NULL,
      1.758046,
      0,
      1,
      NULL,
      1.710764,
      NULL,
      NULL,
      NULL,
      0.891085,
      0,
      0,
      1,
      1.594821,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      0.361600,
      NULL,
      0.778517,
      0,
      3.656339,
      0,
      2.412647,
      NULL,
      5,
      NULL,
      NULL,
      0.355442,
      NULL,
      7,
      0,
      2.304182,
      1.572651,
      2.674583,
      7,
      3.254738,
      2.914400,
      3,
      1.229392,
      ' 7- 3-2000',
      NULL,
      ' 0- 8-1993',
      451,
      2.985856,
      0.464021,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.111808,
      0,
      0,
      NULL,
      NULL,
      1.623188,
      0.272774,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.215498,
      0,
      0.873823,
      3,
      1.355019,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.553779,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.281874,
      1,
      0.244772,
      0.765492,
      1,
      1753.900397,
      0.240067,
      0,
      NULL,
      NULL,
      NULL,
      0.215636,
      1.523682,
      3.614277,
      1,
      NULL,
      2,
      2,
      0.718408,
      1,
      1,
      1,
      3,
      0.482538,
      NULL,
      NULL,
      3.917250,
      7,
      0.118168,
      1.879171,
      5,
      3,
      NULL,
      1.731680,
      NULL,
      1,
      0.439088,
      NULL,
      1.550976,
      1,
      6.903867,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      21.657886,
      NULL,
      NULL,
      NULL,
      2.025543,
      1,
      0.676153,
      '34323',
      '',
      '',
      1.678236,
      '',
      '',
      NULL,
      1.013736,
      '',
      '',
      '',
      1,
      NULL,
      NULL,
      34,
      0,
      11.820080,
      2.704357,
      36.500685,
      0.528034,
      2,
      2,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0.458848,
      1,
      3.004432,
      2,
      0.186854,
      0,
      NULL,
      NULL,
      2,
      2,
      0,
      3.139648,
      NULL,
      NULL,
      0.662554,
      0,
      0,
      0.857659,
      NULL,
      NULL,
      3.183939,
      3.004091,
      1,
      NULL,
      NULL,
      NULL,
      7.961646,
      5.346338,
      2.456907,
      3,
      1.716078,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.777060,
      11,
      0.325467,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.451487,
      0,
      NULL,
      0,
      NULL,
      1.928407,
      1,
      0.877888,
      NULL,
      1,
      NULL,
      NULL,
      0.640312,
      1.069712,
      0.892802,
      NULL,
      NULL,
      1.915045,
      NULL,
      NULL,
      0,
      0.264421,
      1.500074,
      7,
      4,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.598968,
      NULL,
      NULL,
      NULL,
      3,
      0.358174,
      1.575941,
      1,
      NULL,
      NULL,
      0,
      0,
      2,
      NULL,
      NULL,
      NULL,
      1,
      3,
      5.544538,
      0.535110,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.289216,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3.137455,
      1.367969,
      1,
      3,
      1,
      NULL,
      9.528989,
      0,
      1,
      NULL,
      1.600254,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.280308,
      3,
      0.772317,
      0.407795,
      3,
      2.050406,
      3,
      1,
      6,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.250670,
      2.933926,
      1.497540,
      1.734279,
      1,
      3,
      NULL,
      1.517949,
      2.852715,
      1.059085,
      9.234873,
      1.961028,
      0.228823,
      3.557082,
      4,
      1,
      0,
      0,
      1.634950,
      1,
      2.820352,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      9.056731,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.096538,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13.967379,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.554671,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.048601,
      NULL,
      NULL,
      3.828837,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.384475,
      1.427099,
      1,
      1,
      NULL,
      0,
      1.777437,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.959852,
      NULL,
      NULL,
      NULL,
      0.153759,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.135683,
      NULL,
      NULL,
      NULL,
      1.842000,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.645422,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.459230,
      NULL,
      NULL,
      NULL,
      0.852638,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14,
      NULL,
      NULL,
      NULL,
      1.684364,
      NULL,
      NULL,
      NULL,
      1,
      14,
      90.311652,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1.728445,
      NULL,
      NULL,
      1.145185,
      NULL,
      NULL,
      1.145510,
      NULL,
      0.742423,
      13944.628581,
      NULL,
      1.982393,
      0.547728,
      0.949212,
      1,
      NULL,
      NULL,
      0,
      0.027071,
      0.724539,
      1,
      1,
      3,
      0.443280,
      1,
      NULL,
      3,
      1.097879,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.112141,
      NULL,
      1.334908,
      NULL,
      2,
      2,
      21.139754,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.494874,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.133809,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.501992,
      NULL,
      1,
      NULL,
      1.354504,
      1.090797,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.536281,
      NULL,
      NULL,
      1.128162,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.665140,
      NULL,
      1,
      NULL,
      1.844225,
      NULL,
      0.817161,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.133407,
      NULL,
      0.436402,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.579674,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.234771,
      1,
      NULL,
      1.769111,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      3,
      NULL,
      192.736089,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      10,
      11.684644,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.390357,
      3.613128,
      NULL,
      0.179195,
      4.518483,
      5.179912,
      1,
      NULL,
      1,
      3,
      NULL,
      0.557295,
      0,
      NULL,
      1,
      2.634583,
      NULL,
      2,
      19.484744,
      NULL,
      0.848342,
      1.892299,
      NULL,
      0.884433,
      1.432721,
      NULL,
      0,
      0.562255,
      NULL,
      0,
      0.445868,
      NULL,
      1,
      0.541621,
      NULL,
      NULL,
      NULL,
      NULL,
      19,
      6,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4,
      6,
      3.557603,
      3.973526,
      0.182044,
      1,
      13.587658,
      28,
      3,
      0.273415,
      7.425029,
      '21414',
      '42023',
      '43343',
      1,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '',
      '');
commit;
end;
/


