set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9804955';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-10-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      0.363215,
      3,
      2,
      1.688612,
      3.462656,
      2,
      NULL,
      '033',
      '14411041',
      16.773276,
      32.069937,
      NULL,
      0.624393,
      1,
      2,
      NULL,
      '0444',
      6.027284,
      1,
      NULL,
      NULL,
      ' 6-24-1981',
      140.959372,
      77.434336,
      NULL,
      2,
      NULL,
      ' 0- 1-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-29-1990',
      ' 8-23-1984',
      ' 4-17-1983',
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      1.456973,
      3.650160,
      NULL,
      NULL,
      NULL,
      0,
      3.996924,
      NULL,
      NULL,
      NULL,
      NULL,
      4.766184,
      NULL,
      NULL,
      3.231738,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2.452798,
      1.157834,
      2.652597,
      NULL,
      NULL,
      NULL,
      1.704762,
      1.518132,
      1.212530,
      NULL,
      0,
      1,
      0.310715,
      NULL,
      0.291385,
      1.949186,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.720211,
      0.113088,
      0,
      1.868154,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.271424,
      0.677136,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.978228,
      0.938857,
      0.013062,
      0.836034,
      0.290647,
      0.683018,
      1.993035,
      0.213803,
      1,
      0,
      0.932686,
      0.886940,
      1.321728,
      0.756258,
      1.195754,
      0,
      0.234188,
      1,
      NULL,
      0,
      NULL,
      1,
      1.431797,
      1.125803,
      0,
      0,
      1.495656,
      0,
      1,
      0,
      1,
      1.947227,
      1.779432,
      NULL,
      0.051029,
      0,
      1,
      0.675781,
      NULL,
      1,
      1,
      1,
      0.474093,
      0.093381,
      1.180419,
      NULL,
      1.665448,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.088579,
      1.544619,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.639860,
      1,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.669128,
      0,
      NULL,
      0.737624,
      NULL,
      1.204139,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.478907,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      44.844452,
      0.657118,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0.068767,
      2.146167,
      0,
      NULL,
      1,
      NULL,
      1.463056,
      NULL,
      2,
      3,
      1.560749,
      2.017250,
      2,
      1.299940,
      2,
      4,
      NULL,
      NULL,
      0,
      0,
      0.342857,
      1,
      1.368299,
      0.185182,
      0.551519,
      0.595068,
      0.018222,
      1.946322,
      1.948282,
      1,
      NULL,
      8,
      10,
      7,
      2,
      NULL,
      0.652767,
      3,
      NULL,
      6,
      1.798704,
      NULL,
      0.647849,
      5.620352,
      0.908358,
      0,
      99,
      NULL,
      22,
      31.894868,
      1,
      0,
      1,
      '22430',
      '',
      '',
      1.194538,
      '',
      '',
      '',
      NULL,
      '04030',
      '4242',
      '',
      1,
      NULL,
      144.566104,
      41,
      3,
      NULL,
      7.524844,
      3,
      2.144807,
      NULL,
      1.097650,
      0.623179,
      0,
      NULL,
      NULL,
      0.256861,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.718586,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.785499,
      NULL,
      NULL,
      1,
      0.569354,
      NULL,
      0.840861,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.504555,
      0,
      NULL,
      2,
      1.125970,
      1,
      1,
      NULL,
      NULL,
      1.248500,
      NULL,
      0,
      0.882120,
      1,
      0,
      NULL,
      3.745669,
      NULL,
      NULL,
      1,
      0.569482,
      2.772298,
      2.469844,
      2.122310,
      1.349495,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.862376,
      NULL,
      NULL,
      2.144173,
      0,
      1,
      1.615112,
      0.917621,
      NULL,
      NULL,
      NULL,
      0.624075,
      NULL,
      NULL,
      NULL,
      1.906785,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.316572,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.196644,
      NULL,
      NULL,
      1.603071,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.772992,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.401555,
      NULL,
      NULL,
      1.581791,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.127373,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.698822,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      NULL,
      0.216042,
      0.670413,
      NULL,
      NULL,
      1.637032,
      2,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      2.009111,
      0.705645,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.729265,
      NULL,
      NULL,
      1,
      1,
      2,
      8.134005,
      4.713627,
      1.690642,
      1,
      NULL,
      NULL,
      0,
      2.324138,
      3.300670,
      NULL,
      0,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.460656,
      NULL,
      NULL,
      0.107887,
      NULL,
      NULL,
      0.521543,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.807768,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.582192,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.240419,
      3,
      6,
      NULL,
      3,
      NULL,
      43,
      NULL,
      NULL,
      NULL,
      0.707054,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.858239,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.966894,
      NULL,
      2,
      1.291169,
      2.253060,
      NULL,
      3.026795,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.319889,
      NULL,
      NULL,
      NULL,
      0.175004,
      NULL,
      1.143149,
      NULL,
      0.098632,
      1.048728,
      0,
      NULL,
      NULL,
      0,
      2.818571,
      NULL,
      1.706545,
      0,
      1,
      NULL,
      3,
      1.457036,
      0.210298,
      NULL,
      2.526043,
      0.726692,
      NULL,
      NULL,
      3.467335,
      1.469592,
      1.953527,
      NULL,
      1,
      NULL,
      5,
      NULL,
      0.701444,
      0,
      3.414025,
      NULL,
      1,
      0.003057,
      NULL,
      NULL,
      3,
      72.797796,
      10,
      1,
      18.154059,
      1,
      0,
      NULL,
      NULL,
      1.358850,
      NULL,
      0,
      0.764969,
      1.151044,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.217110,
      0,
      0.709786,
      NULL,
      0.948706,
      NULL,
      1.004477,
      0,
      0.995874,
      1.566767,
      0.392421,
      0,
      NULL,
      1,
      NULL,
      1,
      1,
      1.809403,
      NULL,
      NULL,
      1.112931,
      NULL,
      1,
      NULL,
      0.616183,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.018425,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.995648,
      NULL,
      1.402459,
      3,
      0.135157,
      2.815990,
      7,
      1,
      3,
      3.877446,
      1,
      0.968467,
      1,
      1,
      NULL,
      1,
      1,
      1.934638,
      0,
      0,
      NULL,
      NULL,
      1.495842,
      1,
      NULL,
      0,
      0.184962,
      NULL,
      0,
      1,
      0,
      0,
      0,
      0,
      NULL,
      1.347522,
      0,
      NULL,
      1.119302,
      0.655138,
      0,
      2.810689,
      NULL,
      3.773725,
      1.584308,
      1.665842,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.735748,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.820448,
      NULL,
      1.356654,
      NULL,
      NULL,
      1.836168,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.780039,
      4.827798,
      '02001',
      '2013',
      '',
      1.985021,
      '',
      NULL,
      '',
      3.297201,
      '04221',
      '1032',
      '');
commit;
end;
/


