set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908205';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-4-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '4',
      NULL,
      NULL,
      '3134244',
      3,
      1.088767,
      2,
      NULL,
      NULL,
      1.309305,
      NULL,
      NULL,
      NULL,
      '11-23-1984',
      NULL,
      NULL,
      4,
      3,
      3,
      ' 9- 4-2001',
      NULL,
      NULL,
      NULL,
      113.709293,
      NULL,
      '10- 6-1988',
      ' 1-25-1987',
      ' 5-22-1979',
      1.798306,
      0.942272,
      0,
      2,
      1.654099,
      2,
      2.176406,
      0.724107,
      1.851506,
      8.883999,
      5,
      NULL,
      2,
      14.111426,
      23.456683,
      5.961777,
      NULL,
      1.444163,
      1,
      1.813823,
      1.432852,
      0.039024,
      NULL,
      1.092575,
      0.703308,
      NULL,
      1,
      0,
      1.036471,
      3.987496,
      NULL,
      NULL,
      2.656896,
      3.058168,
      3.705666,
      NULL,
      0,
      5,
      3,
      0,
      1.296612,
      0.577684,
      1,
      6,
      7.260426,
      NULL,
      2.434069,
      9,
      2.552314,
      1.020263,
      0.515872,
      0.577566,
      NULL,
      NULL,
      NULL,
      0.398221,
      5.426424,
      0.478143,
      NULL,
      1,
      NULL,
      3,
      0,
      1,
      2,
      1.955584,
      0,
      1.879004,
      0,
      NULL,
      1,
      0.535683,
      NULL,
      1.585083,
      2.136810,
      0,
      1,
      1.334393,
      0.862042,
      3.509768,
      2,
      3.158761,
      0,
      2,
      0.510417,
      NULL,
      NULL,
      2.086915,
      5.965343,
      NULL,
      1.893790,
      0.293835,
      3,
      4,
      2.780918,
      5,
      0.628323,
      1,
      0,
      4.082499,
      5,
      1.428255,
      0,
      NULL,
      0.052388,
      0,
      1,
      1,
      1,
      NULL,
      1,
      0,
      0,
      2.824740,
      5,
      NULL,
      5,
      4.928328,
      0,
      1.810429,
      0.573862,
      0,
      1,
      1.738652,
      0.194637,
      3,
      9.932982,
      1.108223,
      11,
      1,
      NULL,
      4,
      0,
      6.159807,
      3,
      1,
      5,
      2,
      ' 1-17-2000',
      71.060315,
      ' 5-22-2003',
      11,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4.638252,
      1,
      1.799348,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      25.370606,
      0,
      3,
      5,
      0,
      0.288829,
      0.098035,
      3,
      NULL,
      4.480406,
      NULL,
      1.979884,
      NULL,
      NULL,
      NULL,
      2.557746,
      2.230239,
      NULL,
      NULL,
      4.607385,
      6.648102,
      3.662605,
      1,
      NULL,
      NULL,
      1,
      6,
      3,
      3.380883,
      7.542019,
      1.591164,
      NULL,
      ' 9-28-1976',
      NULL,
      '10- 6-1991',
      NULL,
      NULL,
      1.197718,
      0,
      3,
      1,
      0,
      0,
      0.275044,
      1.753811,
      1,
      NULL,
      0,
      1,
      1.672985,
      NULL,
      NULL,
      NULL,
      3,
      0.200176,
      3,
      3,
      2,
      NULL,
      NULL,
      2.547377,
      NULL,
      1.155174,
      2,
      1,
      2,
      NULL,
      NULL,
      0.509236,
      NULL,
      0,
      0.402906,
      2,
      0.170446,
      0.298613,
      1,
      NULL,
      1,
      0.551873,
      0.750602,
      0,
      NULL,
      0.785277,
      6.580333,
      0.839861,
      NULL,
      NULL,
      3.710256,
      11,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      1.834284,
      3,
      1,
      39,
      NULL,
      NULL,
      NULL,
      NULL,
      16,
      30.700062,
      4.356105,
      2,
      3.764653,
      '01030',
      '',
      '',
      1,
      '',
      '',
      '',
      2.077855,
      '4043',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.409798,
      0.988519,
      2.330056,
      NULL,
      1.114151,
      0,
      NULL,
      NULL,
      NULL,
      0.032732,
      NULL,
      1.530375,
      1.340694,
      NULL,
      NULL,
      1.109127,
      NULL,
      NULL,
      1,
      NULL,
      1,
      300.863157,
      0.842065,
      1.107721,
      0.293342,
      0,
      1.685754,
      0,
      NULL,
      NULL,
      1.584960,
      1.308259,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.460989,
      0,
      1.066801,
      0.691271,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.542144,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      6,
      0,
      0.885920,
      0.947271,
      3,
      1,
      NULL,
      2.895648,
      NULL,
      0.954063,
      0.155747,
      NULL,
      0.912188,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.202781,
      NULL,
      0,
      3,
      NULL,
      1,
      0.575442,
      NULL,
      0.747942,
      NULL,
      NULL,
      0,
      0.497224,
      NULL,
      0.128520,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.755996,
      1,
      NULL,
      NULL,
      0.309918,
      3,
      NULL,
      NULL,
      0,
      NULL,
      0.622225,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.342393,
      NULL,
      0.520816,
      NULL,
      1.877450,
      NULL,
      1.842315,
      NULL,
      0,
      NULL,
      0.716201,
      NULL,
      NULL,
      1,
      1.956986,
      0.142437,
      2,
      NULL,
      1,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0.886685,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.148539,
      NULL,
      3.708426,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.156129,
      NULL,
      1,
      NULL,
      4,
      0,
      1149.945750,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.907483,
      5,
      0.606676,
      NULL,
      NULL,
      75.517613,
      147.937858,
      2,
      2,
      3.378285,
      NULL,
      '',
      '',
      1,
      '',
      NULL,
      '',
      2,
      '1300',
      '',
      '');
commit;
end;
/


