set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7812239';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-12-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '20',
      '23',
      5.225830,
      1,
      '2232104',
      0,
      0,
      6,
      1,
      '1043',
      4.049668,
      NULL,
      NULL,
      NULL,
      ' 5-20-2001',
      NULL,
      48.689718,
      NULL,
      0,
      NULL,
      ' 5-14-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      2.099988,
      NULL,
      ' 7-21-1984',
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0.859534,
      0,
      26,
      6,
      11,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.486182,
      3.435249,
      1,
      1.223312,
      0,
      0,
      1.790595,
      NULL,
      0,
      1.036622,
      1,
      2,
      1.540685,
      5,
      2,
      NULL,
      0.570511,
      1,
      1.229874,
      0,
      0,
      1,
      1.226286,
      0,
      1.310188,
      0.557423,
      0.254914,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.506577,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.942319,
      0,
      3.483389,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      5,
      5,
      0.449873,
      9.421999,
      0,
      3,
      1,
      NULL,
      0.235046,
      0,
      NULL,
      1,
      2.871647,
      1.004786,
      1,
      1.896746,
      0,
      2,
      NULL,
      NULL,
      6.764598,
      2.810411,
      3,
      NULL,
      0.056051,
      11.858567,
      NULL,
      1,
      9,
      3.270462,
      2,
      3,
      7,
      4,
      3.079730,
      NULL,
      0,
      9.914709,
      4.295108,
      4,
      10.189755,
      2.662503,
      4,
      5,
      NULL,
      NULL,
      1,
      NULL,
      12.371819,
      NULL,
      26,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.342143,
      1.501610,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.943932,
      NULL,
      0,
      0,
      1,
      1,
      0.062591,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.196507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1,
      0.119196,
      0.239990,
      1.386685,
      0.656937,
      NULL,
      82.013482,
      2.530852,
      1,
      NULL,
      NULL,
      NULL,
      2.463742,
      1.265027,
      0,
      3,
      0.957167,
      2.145374,
      3.274606,
      0.041637,
      1,
      NULL,
      1,
      1,
      2,
      3.841190,
      3,
      2.355258,
      3.276538,
      NULL,
      NULL,
      0,
      0.176177,
      1,
      1.869308,
      NULL,
      1,
      0,
      1,
      NULL,
      1.320050,
      1,
      1,
      1,
      6,
      NULL,
      6,
      8.320286,
      11.938201,
      4.700605,
      4,
      1,
      5,
      2,
      3,
      NULL,
      34.855725,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      '21102',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      7,
      35,
      8.679198,
      1.439968,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.299734,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.756727,
      NULL,
      NULL,
      0.955910,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.563966,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.655118,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.311536,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.816447,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.790035,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.506918,
      3,
      NULL,
      NULL,
      0,
      2.282488,
      2,
      NULL,
      1.909835,
      NULL,
      NULL,
      3.707816,
      5.337085,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.342670,
      NULL,
      NULL,
      1.078562,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      NULL,
      NULL,
      1,
      3.385504,
      1,
      NULL,
      NULL,
      NULL,
      6,
      7,
      7,
      2,
      7,
      6,
      0,
      NULL,
      NULL,
      1.727491,
      NULL,
      0,
      0.981410,
      0,
      3,
      3,
      1,
      NULL,
      8.884397,
      5.426503,
      9,
      0.222583,
      0.119233,
      NULL,
      NULL,
      1.942368,
      3,
      3,
      1,
      3.992356,
      NULL,
      2.714332,
      3,
      8.337092,
      7,
      1.093841,
      NULL,
      2,
      6.791924,
      0.053195,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.784723,
      1.642471,
      1.446981,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.101396,
      1.647197,
      1,
      NULL,
      0,
      1.744246,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.082271,
      1.447267,
      0.142811,
      0.408540,
      0.666316,
      0,
      0.911505,
      NULL,
      NULL,
      0.900251,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      156,
      4.005059,
      1,
      NULL,
      1.582471,
      NULL,
      1.328470,
      1.742701,
      0,
      NULL,
      1,
      0.739677,
      1.190216,
      NULL,
      NULL,
      1.515964,
      0.408572,
      0.751605,
      0,
      1.361601,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.299968,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.230672,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.525214,
      NULL,
      1.058081,
      NULL,
      0.349404,
      NULL,
      0.559909,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.482605,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.316947,
      0.433465,
      1.756238,
      NULL,
      1.104894,
      NULL,
      72,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0.891365,
      NULL,
      NULL,
      NULL,
      0.827417,
      2.510833,
      NULL,
      7,
      2,
      3.124568,
      2.033229,
      NULL,
      NULL,
      NULL,
      2.678878,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.366303,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1,
      3.550419,
      NULL,
      1,
      0.945356,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.010829,
      1.545837,
      0.178197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.400857,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.847905,
      NULL,
      1.504216,
      NULL,
      2.977056,
      NULL,
      2.458737,
      0.044130,
      NULL,
      NULL,
      22.256239,
      NULL,
      0,
      3,
      0.984101,
      '43323',
      '43304',
      '',
      1,
      '',
      '',
      '',
      0.535531,
      '',
      '',
      '');
commit;
end;
/


