set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8925214';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-4-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '4',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0101',
      2.505164,
      1.252543,
      NULL,
      NULL,
      NULL,
      51.402115,
      NULL,
      1.739039,
      1,
      4,
      ' 8- 9-2003',
      16.300549,
      2,
      33,
      114,
      1.709629,
      NULL,
      NULL,
      ' 0-19-1998',
      3,
      1.783740,
      3.389816,
      0,
      0,
      0,
      1.532550,
      2,
      NULL,
      NULL,
      NULL,
      7.741566,
      5,
      20,
      0,
      5,
      NULL,
      NULL,
      1,
      NULL,
      0.416467,
      0,
      0.587300,
      NULL,
      1,
      0,
      0.130819,
      NULL,
      1,
      NULL,
      1.684453,
      NULL,
      2.848895,
      0.502704,
      NULL,
      NULL,
      0.660532,
      1.998059,
      NULL,
      2,
      1,
      0.115224,
      1,
      3.676526,
      1.117396,
      NULL,
      1.115081,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.372006,
      1.561652,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.623983,
      0,
      1.944917,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      0,
      0,
      0,
      0,
      1,
      1.603811,
      0.965147,
      NULL,
      1,
      0,
      NULL,
      1.766379,
      1.589300,
      0,
      NULL,
      0,
      NULL,
      0.010612,
      1,
      4,
      1,
      0,
      0,
      0.084171,
      NULL,
      0.621553,
      0.103673,
      1.680978,
      0.229815,
      0,
      2,
      NULL,
      1.095556,
      4.844785,
      NULL,
      1,
      3,
      6,
      0,
      7.052185,
      2,
      NULL,
      0.983461,
      1.807621,
      0.236850,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.241139,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.621621,
      3.785844,
      3,
      0.980902,
      0.232905,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.365144,
      NULL,
      NULL,
      NULL,
      NULL,
      1.530146,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.087770,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.435487,
      1.140144,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.380035,
      0.690686,
      0,
      1.846586,
      1,
      0,
      1.310523,
      1,
      NULL,
      2.539555,
      0.139159,
      NULL,
      NULL,
      NULL,
      3,
      1.136497,
      0.879741,
      3,
      3.418593,
      NULL,
      0.272953,
      1.041149,
      0,
      1,
      NULL,
      3.760128,
      0.064217,
      1.364122,
      5.841299,
      3.186464,
      2.669208,
      1.687580,
      1,
      3,
      3,
      1.413440,
      1,
      NULL,
      NULL,
      1.837746,
      0.666923,
      NULL,
      NULL,
      3.900212,
      2,
      1.420330,
      NULL,
      11.129587,
      NULL,
      2.503321,
      4,
      2,
      4,
      3.509464,
      0,
      3,
      3,
      NULL,
      57,
      NULL,
      1,
      63.048599,
      NULL,
      NULL,
      NULL,
      2,
      1.998128,
      1,
      '',
      '',
      '',
      1,
      '31440',
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      2,
      NULL,
      19.446168,
      28.799819,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.981231,
      NULL,
      NULL,
      3,
      3.159325,
      1.431304,
      1.139805,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.445594,
      1.543126,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.661220,
      NULL,
      NULL,
      1.569239,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.262581,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.982887,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.824206,
      NULL,
      NULL,
      1.216854,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1,
      3,
      1.456044,
      NULL,
      NULL,
      0.195418,
      NULL,
      NULL,
      NULL,
      3,
      0.670612,
      NULL,
      NULL,
      NULL,
      2.936339,
      1,
      0.351911,
      4,
      2.827162,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.585192,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.314133,
      1.269051,
      NULL,
      2.253293,
      NULL,
      1.687435,
      1,
      NULL,
      NULL,
      1.776127,
      NULL,
      NULL,
      1.524637,
      NULL,
      NULL,
      0.193091,
      0,
      1,
      1.376044,
      NULL,
      NULL,
      5.688970,
      1,
      0,
      0.196549,
      1.903770,
      1,
      1.243360,
      NULL,
      NULL,
      3,
      1.504157,
      0,
      2,
      1,
      1,
      4.840342,
      1.823838,
      NULL,
      1.007958,
      NULL,
      NULL,
      0.718438,
      NULL,
      NULL,
      1,
      1,
      1.828903,
      1.484105,
      0.912934,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.383310,
      1,
      1.278625,
      NULL,
      1.238449,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.067484,
      NULL,
      NULL,
      NULL,
      0.433670,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.959675,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      77.210715,
      0,
      1.080556,
      1.791674,
      NULL,
      0.752908,
      0,
      0,
      1.111240,
      1,
      NULL,
      NULL,
      1.167416,
      NULL,
      1,
      1.745195,
      1,
      0.294614,
      1,
      1.240514,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.091555,
      NULL,
      3.196357,
      0.677608,
      1.771465,
      NULL,
      3,
      NULL,
      8.252413,
      NULL,
      1.620265,
      0.640655,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.302570,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.039883,
      NULL,
      NULL,
      0.985700,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.602086,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.879530,
      1.825246,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.607583,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.950193,
      6,
      0,
      0.855535,
      NULL,
      NULL,
      44.642406,
      11,
      2,
      0,
      1.050401,
      '',
      '',
      NULL,
      3,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      NULL);
commit;
end;
/


