set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5104139';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-6-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      '4300220',
      0,
      0,
      3,
      0,
      NULL,
      3.126971,
      1,
      NULL,
      NULL,
      ' 4-24-1997',
      71.335988,
      NULL,
      NULL,
      3,
      1.301853,
      ' 6-20-2002',
      133.677680,
      4.230321,
      827,
      979,
      3,
      ' 5-28-1992',
      NULL,
      '10- 4-1999',
      1,
      NULL,
      2.305359,
      0.315148,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.667752,
      14,
      1.692003,
      NULL,
      18,
      5,
      20,
      5,
      3.612224,
      10,
      0,
      1.476981,
      0.103718,
      0.010280,
      1,
      0.365713,
      NULL,
      NULL,
      0,
      1.813138,
      7,
      4.588457,
      2.685358,
      0,
      1.505568,
      3.730078,
      0,
      1,
      0.918883,
      1.809966,
      0.098885,
      0.829487,
      1.163675,
      0,
      0,
      0.165627,
      0,
      0.340953,
      NULL,
      1.994318,
      5,
      1.246456,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.427620,
      2,
      NULL,
      1.281157,
      2,
      2,
      0.222006,
      0.412059,
      3,
      2.593544,
      0.154582,
      2,
      0,
      0,
      1.805473,
      NULL,
      1.430216,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.116322,
      4.267405,
      NULL,
      4,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.926589,
      0,
      1.711285,
      NULL,
      0.716039,
      0,
      1,
      5.203999,
      3.922795,
      5,
      5,
      4,
      NULL,
      5.336592,
      5,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.373004,
      9,
      8.224992,
      3.120623,
      NULL,
      6.873056,
      11.304861,
      8.605083,
      7.852021,
      NULL,
      7,
      0,
      NULL,
      6,
      4,
      1.789875,
      NULL,
      NULL,
      ' 4- 2-1992',
      NULL,
      0.133150,
      0,
      1,
      0.052627,
      1.563904,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2.235018,
      0.162883,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0.674282,
      0.017951,
      NULL,
      NULL,
      NULL,
      NULL,
      0.658989,
      1.605917,
      1.090964,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.307506,
      0.965940,
      NULL,
      3.796203,
      NULL,
      2.432967,
      3.288344,
      15602.510603,
      0.707152,
      NULL,
      24,
      1130.514218,
      1.455851,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.642293,
      NULL,
      1.278285,
      2.885552,
      0.852329,
      0.114648,
      0.976583,
      2.916559,
      NULL,
      1,
      0.779148,
      NULL,
      0.758554,
      NULL,
      NULL,
      2.366129,
      NULL,
      NULL,
      NULL,
      19.060590,
      NULL,
      NULL,
      2.464920,
      '44211',
      '33211',
      NULL,
      NULL,
      '',
      '',
      '',
      4.563427,
      NULL,
      '2222',
      '30210',
      NULL,
      22.772481,
      770,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.631476,
      NULL,
      NULL,
      0,
      2.665254,
      0.832552,
      0.998014,
      3,
      0.695637,
      2.640856,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.882864,
      1,
      3.078715,
      1.312364,
      NULL,
      NULL,
      1.920264,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.498256,
      NULL,
      NULL,
      4,
      9.297276,
      4,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.626846,
      3.040892,
      0.333951,
      0.879550,
      NULL,
      0.083749,
      1.822341,
      NULL,
      NULL,
      3,
      0.948647,
      1.251733,
      0.187088,
      0,
      NULL,
      2.140734,
      3,
      NULL,
      1,
      3.450750,
      1.449594,
      1,
      0.154612,
      0.016818,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.373064,
      NULL,
      NULL,
      NULL,
      3.438905,
      NULL,
      4,
      1.141636,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2.191588,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0.829632,
      3.093651,
      1,
      5,
      1.653238,
      3,
      2.783533,
      0,
      NULL,
      1,
      1,
      4,
      1.489331,
      NULL,
      1.944748,
      NULL,
      NULL,
      10.891283,
      NULL,
      NULL,
      3,
      3.535195,
      2.677052,
      NULL,
      NULL,
      3.158732,
      2,
      3.245417,
      0,
      2,
      2.451205,
      3,
      1.709605,
      0.171308,
      0.305797,
      NULL,
      0.291971,
      0.641824,
      4.001167,
      7.626947,
      5.351447,
      7,
      4,
      3.890150,
      5.325939,
      NULL,
      2.575754,
      1.278013,
      1,
      NULL,
      2,
      2,
      3,
      NULL,
      NULL,
      3,
      4.572547,
      1,
      1.361448,
      2,
      1.405616,
      2.506286,
      1.603053,
      1.361544,
      3.898252,
      2,
      1.413198,
      2.585538,
      2,
      2,
      3.363702,
      8.941437,
      NULL,
      4.584927,
      0,
      2,
      6,
      1.445028,
      NULL,
      6,
      1.168751,
      1.592185,
      0.060128,
      0.243108,
      0,
      3.445821,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.421244,
      NULL,
      NULL,
      0.865246,
      NULL,
      NULL,
      3.341200,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.196040,
      1,
      1,
      1,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.053024,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.693575,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.774539,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.421586,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.370013,
      NULL,
      302,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.553983,
      NULL,
      NULL,
      0,
      154.116808,
      1117.893878,
      0,
      NULL,
      NULL,
      2,
      8.368407,
      1,
      8745.164412,
      96.106903,
      0.544161,
      0,
      1.724117,
      1,
      1,
      1.341312,
      NULL,
      NULL,
      1.313594,
      0,
      0.166706,
      1,
      0,
      0.426206,
      1,
      1.235470,
      0.415565,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.518992,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.001229,
      NULL,
      NULL,
      NULL,
      4.357610,
      NULL,
      NULL,
      4,
      NULL,
      3,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.883150,
      NULL,
      1.811672,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.224904,
      NULL,
      1.615563,
      1,
      0.402978,
      1.246006,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.225306,
      NULL,
      1.494949,
      NULL,
      1.484526,
      NULL,
      NULL,
      NULL,
      3.941015,
      NULL,
      3.807733,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      33,
      0,
      NULL,
      0.772649,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0.173981,
      0,
      1.309350,
      1.540883,
      0.318027,
      NULL,
      1,
      NULL,
      2,
      34.375151,
      4,
      0.891620,
      0.342213,
      1,
      NULL,
      '32214',
      '',
      0.178268,
      '',
      '',
      NULL,
      NULL,
      '0442',
      NULL,
      '30200');
commit;
end;
/


