set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9858589';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-2-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      1.790037,
      1.754572,
      1,
      1.814067,
      2.999463,
      1.489869,
      1,
      '440',
      '33443212',
      23,
      NULL,
      NULL,
      0,
      0.007077,
      0,
      2,
      '3033',
      0,
      1.248089,
      NULL,
      NULL,
      NULL,
      57,
      34,
      NULL,
      NULL,
      1,
      ' 1-20-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      3.756309,
      ' 7-28-1995',
      ' 5- 7-1996',
      '10- 7-1995',
      3,
      0.875147,
      2.533713,
      1,
      NULL,
      0,
      NULL,
      0.593840,
      0,
      12.634517,
      10.778324,
      7,
      0.892931,
      NULL,
      NULL,
      NULL,
      NULL,
      5.744187,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0.224860,
      0.323069,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.259216,
      5.944323,
      0.500109,
      3.253099,
      NULL,
      1,
      0.869727,
      NULL,
      NULL,
      3.727736,
      4,
      1.931922,
      1.780579,
      NULL,
      NULL,
      0.710341,
      NULL,
      NULL,
      NULL,
      3.622884,
      1.751088,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      0,
      NULL,
      3.834854,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.422990,
      6,
      1.694309,
      4,
      3,
      3,
      NULL,
      1,
      1,
      0.418179,
      0.077876,
      NULL,
      6.423691,
      0.519266,
      0.945504,
      1.564063,
      NULL,
      1.478347,
      NULL,
      0.992064,
      6.468376,
      1,
      NULL,
      2,
      1.144601,
      NULL,
      4.821990,
      2,
      0.760577,
      NULL,
      1.191003,
      0,
      3.988360,
      2,
      1,
      0,
      8,
      7,
      NULL,
      0.711239,
      4,
      11.502185,
      NULL,
      4.446548,
      0.341799,
      6,
      0,
      ' 7-14-1977',
      59.235284,
      ' 7- 3-1998',
      126,
      0,
      NULL,
      1.472701,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.625579,
      1.710512,
      0,
      1.197346,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.939886,
      2,
      2.171097,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.152843,
      2,
      2.445074,
      3,
      2,
      NULL,
      0.639433,
      4,
      0,
      3.544359,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      0.321441,
      8.110409,
      0.756817,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.632143,
      0,
      0.400968,
      0,
      0,
      NULL,
      NULL,
      11,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.862845,
      0.895619,
      1,
      0.819078,
      1,
      0.104686,
      1,
      0.269026,
      2,
      NULL,
      0,
      0.383728,
      3.665655,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.085541,
      NULL,
      0.296051,
      1,
      1,
      1.883602,
      1,
      0.324655,
      0,
      0,
      0,
      0,
      1.809792,
      NULL,
      0,
      NULL,
      7.264412,
      1.178394,
      1.108209,
      0,
      0,
      0.912136,
      3.617541,
      NULL,
      NULL,
      3,
      2,
      29,
      NULL,
      NULL,
      77,
      1,
      NULL,
      3,
      '10223',
      '',
      '',
      1.835646,
      '',
      '',
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      56,
      0.748401,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.993205,
      0.653750,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.423111,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1.990577,
      NULL,
      NULL,
      1,
      2,
      0.154971,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      7.375158,
      5.827392,
      9,
      1.213750,
      1.000532,
      NULL,
      NULL,
      NULL,
      0.729195,
      NULL,
      NULL,
      NULL,
      0.520701,
      0,
      NULL,
      0.562607,
      NULL,
      NULL,
      0.262887,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.532030,
      NULL,
      0,
      NULL,
      NULL,
      2,
      2,
      0.294408,
      NULL,
      5.313913,
      1,
      2,
      0.560077,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.878936,
      1.168236,
      1,
      NULL,
      0.807239,
      1,
      NULL,
      NULL,
      4.689594,
      1,
      NULL,
      2,
      3.988290,
      1.192590,
      1.357014,
      NULL,
      NULL,
      NULL,
      2,
      1.743989,
      0,
      NULL,
      NULL,
      1.777013,
      NULL,
      NULL,
      1.844922,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.294819,
      NULL,
      NULL,
      1,
      0.480746,
      0,
      NULL,
      0.662089,
      2.769645,
      1,
      2,
      2.888976,
      1.585276,
      0,
      4.448533,
      4,
      NULL,
      1,
      NULL,
      2,
      0.864586,
      1,
      2,
      0,
      0,
      NULL,
      NULL,
      6.809477,
      1.802351,
      1.838831,
      NULL,
      3.207683,
      3.380038,
      2,
      2.575529,
      1.024921,
      3,
      0.260078,
      3.341506,
      NULL,
      3,
      0,
      6.550166,
      6.999008,
      7,
      8.587146,
      9,
      0.847530,
      3,
      1.145200,
      6,
      NULL,
      0.567035,
      NULL,
      1,
      1.986127,
      1.984133,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.152406,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.382530,
      NULL,
      NULL,
      NULL,
      NULL,
      0.441517,
      0.814949,
      1,
      NULL,
      1.243264,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      67,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.337676,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.321286,
      NULL,
      NULL,
      NULL,
      0.307857,
      NULL,
      NULL,
      NULL,
      0.890758,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.416575,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.287456,
      NULL,
      2,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.775659,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      0.079100,
      1,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      1,
      0.173592,
      0,
      0.439618,
      0,
      NULL,
      1.947476,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.301067,
      2,
      0,
      0.579853,
      0.431135,
      1.295539,
      3,
      1.856228,
      11,
      0,
      2.342237,
      NULL,
      NULL,
      0.804273,
      NULL,
      0.814492,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.855233,
      NULL,
      0,
      2,
      NULL,
      0.552042,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.738196,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.422250,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.248420,
      NULL,
      NULL,
      0.684335,
      7.232518,
      2.921775,
      0,
      3,
      11,
      3,
      1,
      0,
      1.091147,
      NULL,
      '',
      '',
      1.541348,
      NULL,
      '',
      '',
      3,
      '2014',
      '',
      '');
commit;
end;
/


