set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8817204';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-6-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '4',
      NULL,
      NULL,
      '3401020',
      3.105486,
      NULL,
      1,
      3,
      NULL,
      NULL,
      1.722485,
      NULL,
      NULL,
      ' 0-20-1977',
      16,
      NULL,
      4.404819,
      1.496200,
      2.092298,
      ' 6- 9-1982',
      30.292316,
      3.681474,
      33.266083,
      NULL,
      2,
      ' 7- 6-2000',
      ' 9- 1-1993',
      ' 2-25-2003',
      3,
      NULL,
      1.172118,
      0.747888,
      0.939151,
      2.395279,
      0.967972,
      NULL,
      0,
      NULL,
      5,
      16,
      NULL,
      NULL,
      158.911229,
      9,
      9.320200,
      3,
      3,
      11,
      NULL,
      3.300964,
      NULL,
      1.213443,
      1.165713,
      0,
      0,
      3.790024,
      1.757400,
      1.528123,
      1,
      1,
      2,
      3,
      0,
      6,
      1,
      1.523626,
      0,
      1.716679,
      NULL,
      6,
      2,
      3.626555,
      1.898064,
      1,
      0.290342,
      7.197020,
      NULL,
      NULL,
      3.304494,
      3.137086,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.275547,
      1,
      1,
      0,
      1,
      0,
      1,
      3,
      0,
      NULL,
      NULL,
      1.547398,
      1,
      3.191195,
      0.397582,
      NULL,
      2.289279,
      1.870109,
      3.479753,
      1,
      NULL,
      1.828997,
      9.605636,
      1,
      2.706067,
      1.546430,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.556232,
      1.004242,
      NULL,
      NULL,
      0,
      0.839151,
      1.341833,
      NULL,
      1,
      NULL,
      NULL,
      3.763406,
      3.673517,
      0.385427,
      NULL,
      1,
      0,
      NULL,
      1.738528,
      8.259027,
      2,
      3,
      5,
      3,
      0,
      NULL,
      0.363788,
      2.426726,
      5.258425,
      0.037921,
      NULL,
      NULL,
      1.936693,
      3.230787,
      2,
      3.519513,
      NULL,
      NULL,
      6.159144,
      3,
      2,
      5,
      6,
      0.659956,
      9.437557,
      1.314643,
      NULL,
      152,
      ' 5- 9-1983',
      92,
      NULL,
      NULL,
      0,
      1,
      1.504719,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.758432,
      1.550115,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.892130,
      NULL,
      NULL,
      NULL,
      NULL,
      4.624077,
      0,
      0.442328,
      3,
      NULL,
      6,
      9.848716,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      4.021004,
      4.519686,
      NULL,
      2,
      7.899987,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.830940,
      0.541331,
      1.367016,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.863011,
      NULL,
      1,
      0.722941,
      1,
      1,
      3,
      7,
      0.529116,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      0,
      0,
      2,
      NULL,
      3,
      0,
      3.964725,
      3,
      2.928471,
      NULL,
      1.135778,
      0,
      NULL,
      2.665709,
      NULL,
      NULL,
      NULL,
      1.264377,
      1.870012,
      0.343061,
      1.685148,
      0.955924,
      NULL,
      1.538611,
      NULL,
      0.404547,
      0,
      3.527897,
      0,
      NULL,
      6.967019,
      1.142159,
      0,
      5.807423,
      2,
      5,
      3,
      2,
      2.153942,
      0.257372,
      2.747750,
      13,
      NULL,
      0.765248,
      NULL,
      NULL,
      29,
      62,
      NULL,
      0.754592,
      0,
      '04312',
      '',
      '',
      0.846146,
      NULL,
      '',
      '',
      0.803456,
      '',
      NULL,
      '',
      1,
      NULL,
      24.169004,
      1,
      1,
      14.610167,
      2.688448,
      0,
      0.494154,
      2.742875,
      3,
      3.937170,
      1,
      NULL,
      NULL,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0.128577,
      NULL,
      NULL,
      3.253421,
      1.185267,
      NULL,
      3.796119,
      2.600368,
      NULL,
      1.377141,
      3.574770,
      1.637969,
      1.878457,
      1.522856,
      1.594225,
      0.463408,
      3.280361,
      0.634713,
      3,
      0,
      NULL,
      NULL,
      3.216159,
      1,
      8.779432,
      NULL,
      5,
      0,
      0.926736,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.374411,
      0,
      2.749763,
      1.655168,
      NULL,
      NULL,
      2.949353,
      1,
      0,
      2.050838,
      0.280975,
      0,
      2.805528,
      NULL,
      0.390894,
      1.365583,
      3,
      1.215530,
      NULL,
      0,
      0,
      2,
      NULL,
      3.139282,
      3.599431,
      0.590505,
      1.858764,
      NULL,
      0.143041,
      0,
      0,
      3,
      NULL,
      0,
      NULL,
      8,
      NULL,
      1.658976,
      NULL,
      NULL,
      NULL,
      NULL,
      1.179626,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      3.068705,
      NULL,
      1,
      0,
      NULL,
      NULL,
      3,
      4.332336,
      0,
      0,
      NULL,
      1,
      1.697931,
      NULL,
      NULL,
      NULL,
      4.716381,
      1,
      2.665348,
      1.417790,
      1.293801,
      1.304510,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.263757,
      NULL,
      NULL,
      1.218234,
      NULL,
      NULL,
      3.088845,
      0.796510,
      2.498620,
      NULL,
      2,
      3.671466,
      6,
      NULL,
      4,
      6,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.335718,
      0.660560,
      2,
      1.448313,
      2.094746,
      2.902632,
      1,
      NULL,
      1,
      NULL,
      7.811292,
      0,
      2,
      3,
      3.722674,
      2,
      1,
      2,
      1,
      NULL,
      1.826046,
      1.988015,
      0.340006,
      NULL,
      NULL,
      6.369765,
      1,
      NULL,
      7,
      NULL,
      0,
      NULL,
      6,
      0.931533,
      0.508121,
      0,
      1.064050,
      0,
      0.733527,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.673711,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.779751,
      NULL,
      NULL,
      NULL,
      0.802023,
      0.735752,
      0,
      0,
      3,
      1,
      NULL,
      NULL,
      4.499796,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.927863,
      NULL,
      NULL,
      NULL,
      0.270752,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.806162,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.243581,
      NULL,
      NULL,
      NULL,
      0.809007,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.597099,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.258273,
      NULL,
      NULL,
      NULL,
      1.681277,
      NULL,
      NULL,
      NULL,
      5.340245,
      NULL,
      NULL,
      NULL,
      1.682720,
      NULL,
      NULL,
      NULL,
      3.311817,
      27,
      9,
      0.014622,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.139460,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.747475,
      NULL,
      NULL,
      0.096519,
      NULL,
      0,
      9435,
      NULL,
      1.713089,
      0.430823,
      0,
      0.549488,
      NULL,
      0,
      NULL,
      1,
      0.370620,
      0.871503,
      1,
      1,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.341952,
      NULL,
      3.666724,
      4.483495,
      5.745015,
      1,
      3,
      3,
      5.022059,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      2.342837,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      0.954101,
      2.213658,
      NULL,
      1,
      1.646235,
      NULL,
      3.625801,
      1,
      NULL,
      1.068223,
      0.178348,
      NULL,
      1.300874,
      1.016511,
      NULL,
      1,
      2,
      NULL,
      3,
      NULL,
      0.031605,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.436235,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7,
      NULL,
      0,
      NULL,
      NULL,
      21,
      NULL,
      1.269660,
      NULL,
      NULL,
      '30241',
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      1,
      NULL,
      NULL,
      '');
commit;
end;
/


