set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9307171';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-8-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '0',
      NULL,
      NULL,
      NULL,
      0,
      0,
      4,
      2,
      '2102',
      2.469801,
      NULL,
      NULL,
      NULL,
      ' 6-22-1995',
      64,
      NULL,
      3,
      0,
      0.293976,
      ' 6-13-1989',
      8,
      0.686132,
      196.374291,
      89.432931,
      1,
      NULL,
      NULL,
      NULL,
      0.991117,
      1.162576,
      0,
      NULL,
      1,
      0,
      0.338233,
      3.941811,
      NULL,
      NULL,
      NULL,
      8.375802,
      6,
      3.316685,
      14.606771,
      NULL,
      12.060946,
      NULL,
      0,
      NULL,
      0.991036,
      3.831329,
      NULL,
      1,
      0,
      1.573169,
      1.640461,
      2,
      1,
      1,
      NULL,
      1.215393,
      1,
      4,
      2.663945,
      NULL,
      2.408598,
      1.002007,
      1,
      1.171731,
      0,
      1.002028,
      0,
      1,
      0.936437,
      0.762852,
      0.005310,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.706536,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.610524,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.503075,
      0,
      1,
      NULL,
      1.408740,
      0,
      1,
      1,
      2.683274,
      0.225567,
      0,
      3,
      0.113745,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.478680,
      0.754791,
      0,
      0.469586,
      1,
      0,
      0.315714,
      1,
      0.326176,
      1.467440,
      0.660926,
      1.677845,
      NULL,
      0,
      0,
      1,
      0,
      1.030688,
      3,
      0,
      NULL,
      1.796689,
      0.136855,
      0,
      1,
      0.134542,
      0,
      1.356962,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.723990,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.457084,
      3,
      0.295082,
      1.810357,
      1,
      0,
      NULL,
      1.091228,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.045947,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.843662,
      0.704098,
      0,
      0.063431,
      0,
      1.962959,
      NULL,
      NULL,
      NULL,
      1.349201,
      1.010802,
      0.637752,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.606453,
      1.828730,
      1.552064,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.963274,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0.027620,
      NULL,
      0.167328,
      0.933491,
      0.723009,
      1.452263,
      3.775349,
      1.202748,
      NULL,
      NULL,
      0,
      NULL,
      2,
      3,
      1.898252,
      1.395648,
      0,
      2.457798,
      0.285043,
      1.702709,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      3,
      0.344883,
      1.529777,
      NULL,
      0,
      7.053105,
      11.253067,
      2.615474,
      1,
      2.891311,
      5,
      NULL,
      2,
      1.605168,
      42,
      3.829416,
      0.373254,
      0,
      NULL,
      NULL,
      NULL,
      5,
      1,
      1.681149,
      '33021',
      '',
      NULL,
      1,
      '',
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      3.948847,
      23,
      8.378227,
      2.572818,
      NULL,
      22,
      3,
      1,
      4.489593,
      2.530174,
      2,
      0.467143,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.171931,
      0,
      1.782936,
      0.697496,
      2.263986,
      0.728425,
      2,
      2.959082,
      1.125010,
      1.991056,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      9,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.170969,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1.722738,
      1.247682,
      3.193131,
      2,
      1.710647,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.241452,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.303751,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.594946,
      0.766346,
      0,
      0.171629,
      0,
      1,
      0.542096,
      NULL,
      NULL,
      8.942902,
      NULL,
      0,
      NULL,
      2,
      1,
      0.273873,
      3,
      NULL,
      4.659923,
      2.613190,
      0.793586,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.938052,
      NULL,
      NULL,
      1.566988,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.819263,
      NULL,
      NULL,
      0.839551,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.386881,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.250906,
      3,
      1,
      2.793679,
      2,
      0.109885,
      0,
      NULL,
      NULL,
      0.622130,
      4.263127,
      NULL,
      NULL,
      3.180279,
      3.690558,
      0.028733,
      NULL,
      NULL,
      3.191235,
      1,
      0,
      NULL,
      3,
      3.045653,
      1.950179,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1.246154,
      NULL,
      1,
      0.895529,
      1,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.154206,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0.433654,
      1,
      0,
      1,
      3.389607,
      NULL,
      NULL,
      3.575898,
      0.491262,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.283233,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.177029,
      NULL,
      NULL,
      0.571273,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.660845,
      NULL,
      NULL,
      NULL,
      NULL,
      1.283155,
      NULL,
      NULL,
      0.151550,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.308213,
      NULL,
      NULL,
      0.117749,
      0.355489,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.178222,
      1,
      NULL,
      NULL,
      4.314702,
      0,
      NULL,
      NULL,
      0.036579,
      NULL,
      NULL,
      NULL,
      1.758935,
      4.954220,
      0.500182,
      0.088258,
      NULL,
      0.478945,
      1.553266,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.803118,
      NULL,
      NULL,
      152,
      1,
      0.701090,
      0,
      0.718218,
      0.022577,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.248976,
      0.802342,
      NULL,
      0.853513,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.765056,
      NULL,
      0.217508,
      1.367004,
      NULL,
      NULL,
      0.852256,
      0.749444,
      2.073446,
      2.843159,
      0.106406,
      1.043805,
      1.031809,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      1.448308,
      1.382500,
      1.701199,
      NULL,
      0.033545,
      NULL,
      1,
      0.216925,
      1,
      1,
      0.439848,
      0.396967,
      2,
      0.060299,
      0,
      1.796969,
      1.475114,
      1,
      NULL,
      NULL,
      2,
      1,
      1.120441,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      3,
      0,
      3.292772,
      1.934055,
      NULL,
      NULL,
      81,
      45,
      0.670405,
      0.605620,
      2.024273,
      '24310',
      '',
      '',
      1.147119,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


