set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9509348';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-4-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '3',
      NULL,
      NULL,
      '3103123',
      0,
      0.960203,
      6,
      NULL,
      '1223',
      2,
      NULL,
      NULL,
      NULL,
      ' 5-13-1987',
      22,
      NULL,
      2,
      2.572071,
      3.266016,
      ' 9-25-1982',
      37,
      NULL,
      16.839138,
      80,
      3.619786,
      NULL,
      NULL,
      ' 9-14-1990',
      1.909334,
      2,
      0,
      NULL,
      1.423258,
      3,
      1,
      1.367773,
      0.057280,
      17,
      4.173484,
      7,
      1.546526,
      7.113852,
      NULL,
      7.553729,
      NULL,
      6.741833,
      3,
      7.234807,
      0,
      1.990437,
      NULL,
      1,
      1,
      1,
      1.382769,
      0.478470,
      0,
      1,
      1.694739,
      3,
      1,
      NULL,
      0,
      3,
      NULL,
      0,
      1.134809,
      4.161551,
      1.315576,
      0,
      1.859252,
      NULL,
      1,
      NULL,
      1,
      4,
      NULL,
      5.724514,
      NULL,
      0.129419,
      0.180218,
      NULL,
      NULL,
      0.379600,
      NULL,
      NULL,
      6.688839,
      3.895208,
      3.797649,
      2,
      1,
      0,
      NULL,
      3,
      3.760410,
      NULL,
      1,
      NULL,
      1.357667,
      2.183780,
      1.992874,
      0.506283,
      3.981571,
      3.184008,
      0,
      0,
      1.073413,
      4.059817,
      2.236788,
      1.438695,
      1,
      1.473507,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.118617,
      NULL,
      1.715625,
      0,
      0.924266,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      1.348513,
      1,
      1.525820,
      1,
      0,
      0.488132,
      1,
      1,
      NULL,
      0,
      3,
      1.875787,
      NULL,
      8.676508,
      0,
      1.889792,
      1,
      1,
      4.717655,
      4.644558,
      1,
      NULL,
      NULL,
      5,
      9.795067,
      9,
      5.331062,
      1,
      5,
      0.288124,
      4.679221,
      9,
      6.150545,
      3,
      0.896757,
      NULL,
      0.400732,
      '11- 2-1979',
      73,
      '11-10-1978',
      41.709509,
      NULL,
      0.385096,
      0.195549,
      1,
      1.724752,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.838432,
      0,
      3.534445,
      0.116057,
      1.326572,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.072388,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.023257,
      3,
      2,
      7,
      0.800915,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.064252,
      0.413013,
      1,
      1.898657,
      0,
      4.239968,
      1.756134,
      NULL,
      NULL,
      NULL,
      1.379393,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.989927,
      0.337712,
      NULL,
      1.329730,
      NULL,
      1,
      1,
      2.816846,
      96.175185,
      0.301556,
      0.333746,
      NULL,
      NULL,
      NULL,
      4.863518,
      0.686150,
      NULL,
      0.960059,
      0.712361,
      0,
      4,
      2.173166,
      0,
      NULL,
      3,
      6,
      4.768493,
      NULL,
      NULL,
      3,
      0,
      NULL,
      1.050086,
      3.743075,
      0.071299,
      1.434238,
      1.479585,
      1,
      1.262497,
      0,
      1.104075,
      1,
      NULL,
      0.830004,
      0,
      1.598968,
      3.004435,
      2,
      6,
      NULL,
      5,
      NULL,
      1.825475,
      3,
      NULL,
      3.130039,
      2,
      0,
      69,
      3,
      1,
      NULL,
      22.421110,
      26.137274,
      50.186175,
      2,
      NULL,
      3.702014,
      '21242',
      NULL,
      '',
      NULL,
      NULL,
      '',
      NULL,
      1.206129,
      '',
      '',
      NULL,
      0,
      21,
      23.844739,
      NULL,
      3,
      16,
      3.792114,
      1.844350,
      3,
      2.602355,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.789407,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0.304008,
      0,
      2,
      0.914161,
      NULL,
      NULL,
      3.016151,
      0.425090,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.231234,
      2,
      1.139194,
      0,
      3.943204,
      1.689301,
      2,
      1,
      2.251164,
      NULL,
      0,
      0,
      3,
      2.774751,
      NULL,
      0.027374,
      0.931299,
      1,
      1.208218,
      3,
      1,
      NULL,
      2,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.439298,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.837026,
      6,
      2,
      1,
      0.449710,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.964847,
      1.884485,
      NULL,
      NULL,
      1.566024,
      0,
      1.143718,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      0.185596,
      1.904288,
      1.526269,
      NULL,
      NULL,
      4.012728,
      NULL,
      1.297910,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.299063,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.269632,
      NULL,
      NULL,
      6.396811,
      NULL,
      1,
      3,
      2,
      3,
      1,
      NULL,
      NULL,
      4.668639,
      5.627947,
      4,
      6.971794,
      NULL,
      4.735793,
      2.059602,
      NULL,
      2.406638,
      1.631654,
      0.406236,
      0.989963,
      0.437786,
      3.492309,
      NULL,
      2,
      0,
      0,
      9.982114,
      5.220669,
      NULL,
      0.041909,
      0.131325,
      NULL,
      1.881196,
      0,
      0.257685,
      0,
      1,
      3.274446,
      1.692514,
      3.723009,
      3.667165,
      5,
      5.383129,
      2.786404,
      2.745907,
      NULL,
      3.211549,
      3,
      2,
      4,
      1.042578,
      1.313985,
      0.000712,
      1.357453,
      1,
      1.832661,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.267190,
      0.229292,
      0,
      0,
      1.104792,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.416602,
      NULL,
      NULL,
      NULL,
      0.794417,
      NULL,
      7.692530,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.197256,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.991605,
      NULL,
      0,
      NULL,
      1,
      0,
      1.749789,
      1,
      NULL,
      NULL,
      1,
      1,
      1.806995,
      1.826823,
      3,
      0,
      2.547448,
      1,
      1.162187,
      0,
      0,
      1,
      2,
      NULL,
      NULL,
      NULL,
      3.868425,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.632376,
      NULL,
      22.153978,
      NULL,
      NULL,
      12,
      32,
      0.419754,
      1.659926,
      NULL,
      NULL,
      0.889110,
      NULL,
      1.127416,
      NULL,
      1,
      NULL,
      0.379837,
      NULL,
      1.424096,
      NULL,
      0.554783,
      NULL,
      1.182556,
      NULL,
      1.911715,
      NULL,
      1,
      NULL,
      0.805815,
      NULL,
      0.186930,
      NULL,
      0.533907,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0.061420,
      1.339836,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.847774,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.317356,
      NULL,
      NULL,
      NULL,
      NULL,
      0.520925,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.868587,
      NULL,
      2.373642,
      NULL,
      1,
      NULL,
      214.623500,
      NULL,
      NULL,
      1.104204,
      1.002529,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      241,
      NULL,
      2,
      NULL,
      3.118803,
      NULL,
      1.028275,
      NULL,
      1,
      7,
      33,
      0.988452,
      1.783220,
      1,
      NULL,
      1.018736,
      1.362044,
      0.271338,
      1.753218,
      0.937763,
      1,
      NULL,
      3.679853,
      4,
      2.256628,
      1,
      1,
      NULL,
      1.011355,
      NULL,
      NULL,
      NULL,
      NULL,
      0.309280,
      NULL,
      NULL,
      1.561439,
      NULL,
      NULL,
      0.034661,
      0.067940,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.452511,
      NULL,
      3,
      1.040782,
      NULL,
      NULL,
      0.644670,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.415430,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.117885,
      1.689740,
      NULL,
      NULL,
      NULL,
      12.946877,
      56,
      4.384830,
      NULL,
      3.331499,
      NULL,
      '03202',
      NULL,
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


