set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9509348';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-11-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '13',
      '30',
      2,
      9.660677,
      '1003123',
      3.534270,
      0,
      2,
      NULL,
      '3303',
      NULL,
      0.222523,
      NULL,
      NULL,
      ' 5- 4-1991',
      21.409710,
      NULL,
      NULL,
      3,
      0,
      '11- 7-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      2.651891,
      '10-12-2000',
      ' 0-22-1990',
      NULL,
      2.827564,
      NULL,
      1,
      0.455211,
      1,
      0.099032,
      1.108350,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      7.153498,
      NULL,
      NULL,
      NULL,
      NULL,
      4.591801,
      2,
      NULL,
      0,
      0,
      0.081947,
      0.653235,
      0,
      0.152260,
      NULL,
      NULL,
      0.120410,
      1,
      1,
      NULL,
      NULL,
      7,
      3,
      0.234032,
      1,
      NULL,
      NULL,
      NULL,
      4.257302,
      NULL,
      0.172338,
      0,
      1.864767,
      2.247776,
      1,
      NULL,
      1.087908,
      1.485109,
      4,
      2,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      0,
      1,
      NULL,
      0.144689,
      NULL,
      3.060066,
      NULL,
      0.719502,
      3,
      1,
      0.310588,
      0.349149,
      0.369152,
      0.202089,
      1,
      0.243878,
      0.623455,
      0,
      3.744287,
      NULL,
      4,
      1,
      0.036920,
      1,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.922998,
      0,
      1,
      1,
      0,
      4,
      2.598350,
      NULL,
      0,
      1.682516,
      0.773508,
      1.665529,
      1.215079,
      0.766679,
      0,
      0.553952,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.610620,
      5.275711,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      1,
      1.091264,
      0.433533,
      0,
      1.949088,
      1.020771,
      NULL,
      6.349308,
      NULL,
      6,
      8.064048,
      NULL,
      1,
      5,
      1,
      3.331914,
      0.762409,
      1,
      1.159318,
      0,
      NULL,
      303,
      ' 2- 7-1981',
      24.339104,
      1.972759,
      1.796117,
      0.875775,
      3,
      1.571775,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      0.021260,
      0.055993,
      0.927031,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.796835,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      3,
      1.000195,
      NULL,
      3.542231,
      2,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.119057,
      1.127960,
      0.349541,
      1,
      1.907023,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.361349,
      1,
      NULL,
      0,
      NULL,
      0.724342,
      2,
      25.902126,
      1.857894,
      0,
      NULL,
      NULL,
      NULL,
      6,
      2.634086,
      NULL,
      4.596018,
      3,
      5,
      NULL,
      0.985455,
      1,
      NULL,
      NULL,
      5.408315,
      4,
      7.472497,
      0,
      2.582272,
      NULL,
      0,
      1,
      NULL,
      0,
      0.804019,
      0,
      NULL,
      0.172133,
      1.655680,
      0,
      1,
      NULL,
      0.984846,
      1,
      0,
      5.942475,
      1,
      2.983077,
      0,
      5.311183,
      NULL,
      NULL,
      2,
      6,
      0,
      NULL,
      1.087644,
      40,
      0.613563,
      NULL,
      44.822322,
      NULL,
      64.133210,
      50.941220,
      0.448276,
      1,
      4,
      '40010',
      '40123',
      NULL,
      1,
      '',
      '',
      '',
      0.674738,
      NULL,
      '',
      '',
      1,
      18,
      42,
      1.632096,
      3,
      26.139944,
      0.841665,
      3,
      5,
      3.246567,
      1.965308,
      3,
      1,
      NULL,
      NULL,
      0.254343,
      NULL,
      NULL,
      1.698413,
      NULL,
      2,
      1,
      1,
      2.876857,
      0,
      NULL,
      NULL,
      3.676688,
      3,
      3.385263,
      0.502685,
      NULL,
      NULL,
      0,
      3.975570,
      NULL,
      1.884645,
      NULL,
      NULL,
      0.762758,
      3,
      3.882246,
      1.614429,
      NULL,
      NULL,
      0,
      NULL,
      6,
      1,
      1.033542,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2.576806,
      2.746785,
      2.956173,
      1.932311,
      2.671560,
      0.553857,
      0,
      0,
      1.183193,
      0.641051,
      0.396656,
      2,
      1,
      0,
      3.332366,
      2.640356,
      0,
      1.514468,
      1.601330,
      NULL,
      0.345195,
      2,
      NULL,
      2.923746,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      2,
      0.604696,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.197902,
      3,
      NULL,
      3,
      2.051439,
      0.414661,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      3,
      2,
      2.840374,
      2.657404,
      2,
      0.211429,
      NULL,
      NULL,
      0.610344,
      NULL,
      1.292140,
      0,
      1.785973,
      1,
      1.569978,
      NULL,
      NULL,
      1.782788,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.012663,
      5,
      NULL,
      0.427914,
      0.390729,
      1.673684,
      2,
      1.528072,
      0,
      NULL,
      0.067569,
      1,
      1,
      6,
      1,
      0,
      1.281535,
      7.348280,
      5,
      3.153929,
      2.392825,
      0.239982,
      NULL,
      2,
      3.513118,
      2.813420,
      3,
      2,
      2,
      0.429734,
      NULL,
      NULL,
      3,
      3,
      NULL,
      3.393315,
      NULL,
      1.591159,
      1,
      1.040020,
      NULL,
      NULL,
      3.365085,
      4,
      2,
      4.132336,
      0,
      5.845665,
      NULL,
      0.953863,
      3.944827,
      NULL,
      0.140703,
      1.339272,
      0.085572,
      1.648333,
      NULL,
      0,
      NULL,
      NULL,
      1.755757,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.370284,
      NULL,
      NULL,
      1.911546,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.081557,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.286709,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      13,
      3.244782,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.240337,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.851397,
      NULL,
      0.004819,
      194,
      6140.746847,
      1.271072,
      1,
      0.410174,
      1.748880,
      1.091620,
      2,
      0,
      NULL,
      0,
      2.339357,
      0,
      1.627483,
      0,
      NULL,
      0.506918,
      0,
      0.872703,
      1,
      NULL,
      1.997334,
      NULL,
      2.408103,
      NULL,
      0,
      NULL,
      3,
      NULL,
      3,
      NULL,
      57,
      NULL,
      3,
      20,
      31,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.790224,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.341696,
      NULL,
      1.637058,
      NULL,
      0,
      NULL,
      0.515731,
      NULL,
      1,
      NULL,
      1.483616,
      NULL,
      NULL,
      NULL,
      1.905123,
      NULL,
      1,
      0.070112,
      1,
      1.595236,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.873876,
      0.174758,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.525431,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.832086,
      NULL,
      0.092217,
      NULL,
      1.441762,
      NULL,
      1,
      NULL,
      1.692891,
      NULL,
      3,
      NULL,
      27,
      NULL,
      2,
      NULL,
      0,
      NULL,
      1,
      NULL,
      3.716891,
      NULL,
      2.418620,
      NULL,
      1.638711,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.897742,
      3.367666,
      NULL,
      0.370427,
      NULL,
      NULL,
      NULL,
      58,
      NULL,
      NULL,
      1,
      2,
      NULL,
      2.885083,
      NULL,
      2.166343,
      NULL,
      248.711048,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.706148,
      1.086363,
      3,
      7,
      18.388125,
      2,
      3,
      0.260879,
      3,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      5,
      2,
      1,
      NULL,
      0.475222,
      0.659466,
      1,
      NULL,
      1.974229,
      NULL,
      NULL,
      2,
      0,
      NULL,
      0.317024,
      0.807297,
      NULL,
      1,
      0.935192,
      NULL,
      1.395877,
      0,
      NULL,
      0.021729,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.218085,
      0.035775,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.762601,
      NULL,
      4,
      2.971939,
      5,
      1,
      NULL,
      NULL,
      4,
      135.640795,
      1.947492,
      1.836040,
      1,
      '12304',
      '31443',
      '',
      1,
      '',
      '',
      '',
      1.121230,
      '',
      '',
      NULL);
commit;
end;
/


