set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5803515';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-1-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.108397,
      0.574429,
      NULL,
      2,
      '2213',
      NULL,
      NULL,
      1.068719,
      NULL,
      NULL,
      NULL,
      NULL,
      2.732272,
      0.556785,
      1.629496,
      ' 5-29-1994',
      30,
      3.640036,
      133,
      12,
      3,
      NULL,
      NULL,
      NULL,
      1,
      0.582019,
      0.005460,
      1,
      1,
      3,
      0,
      1,
      NULL,
      74.155605,
      8,
      1.359302,
      2,
      1.308236,
      6.952533,
      4.320288,
      NULL,
      0,
      3,
      3,
      1.643521,
      1,
      1,
      1.736230,
      1.838703,
      0.108802,
      NULL,
      1,
      1.816514,
      NULL,
      1.139841,
      1,
      0.782987,
      3.857126,
      2,
      0,
      NULL,
      1.740064,
      NULL,
      1.209387,
      1.208358,
      NULL,
      NULL,
      0.118994,
      1,
      0,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.061590,
      0.030495,
      1,
      1,
      1.234760,
      1.670638,
      1.503332,
      NULL,
      0.855001,
      NULL,
      0,
      1.895232,
      1.820942,
      0,
      0.303772,
      1,
      0.997680,
      0,
      0,
      0.887994,
      NULL,
      1.030355,
      2,
      NULL,
      3,
      1.229925,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.191761,
      NULL,
      0,
      0,
      1.332618,
      NULL,
      0.740439,
      1,
      NULL,
      1.667158,
      1,
      1.508115,
      0.124133,
      1.300163,
      NULL,
      NULL,
      1.582941,
      1,
      1.643935,
      NULL,
      1,
      6.638770,
      1.033465,
      3.280300,
      NULL,
      1.971695,
      6.296390,
      0.035834,
      0.782759,
      2.303617,
      NULL,
      1.063734,
      0,
      5.857740,
      4.051296,
      1,
      4,
      1,
      NULL,
      4.608671,
      NULL,
      1,
      1,
      5,
      NULL,
      1.931338,
      5.707414,
      0.024279,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.416900,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.090575,
      2.414723,
      NULL,
      2.908726,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.345246,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.989350,
      1,
      2.686153,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.859508,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.051657,
      0,
      NULL,
      2,
      0,
      0,
      1,
      NULL,
      3.466222,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      0,
      1.136011,
      3.632461,
      3.831044,
      1,
      2,
      NULL,
      3.624340,
      0.956362,
      2,
      3.666922,
      1.268773,
      2.631910,
      NULL,
      1.368848,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.296607,
      0,
      0,
      0.342406,
      0,
      0,
      0.248264,
      3.317872,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.215884,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.369571,
      '14344',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      27.931889,
      24,
      31.553787,
      3.147532,
      10,
      10.622675,
      73,
      4.809229,
      2,
      2,
      1,
      1.586123,
      14.390276,
      1.624432,
      3,
      3,
      NULL,
      NULL,
      NULL,
      1.102555,
      3.312194,
      0.570828,
      0.687759,
      0,
      NULL,
      NULL,
      0.593873,
      1.053530,
      NULL,
      NULL,
      3,
      0.466126,
      3.192005,
      0,
      1,
      0.976046,
      NULL,
      0.179802,
      0.357696,
      2,
      0,
      10.922158,
      NULL,
      NULL,
      4,
      2,
      0.874558,
      0.222180,
      NULL,
      1.888556,
      15.561129,
      14,
      2,
      1,
      15,
      NULL,
      1.412175,
      3.511672,
      0,
      NULL,
      1,
      1,
      1.428216,
      NULL,
      NULL,
      NULL,
      0.882655,
      1.271505,
      NULL,
      2,
      1.038832,
      0.072305,
      1,
      1,
      0.122264,
      1,
      0,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      3.313446,
      0,
      NULL,
      4,
      0,
      6.469474,
      1,
      0,
      NULL,
      17,
      2,
      NULL,
      10.515627,
      17,
      3,
      NULL,
      0,
      2,
      3,
      NULL,
      2,
      2,
      14,
      NULL,
      1.752297,
      1,
      7,
      1,
      0,
      3,
      3,
      1.886839,
      0,
      5,
      1.540412,
      0.815727,
      5,
      0,
      0.732032,
      2,
      0.525978,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.099992,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.603879,
      1.382266,
      0.370098,
      3,
      2,
      3.582003,
      2,
      1,
      3.003714,
      6.268834,
      NULL,
      4,
      4.560378,
      1.257277,
      9,
      6,
      3.891197,
      NULL,
      0.702639,
      1.145057,
      2,
      NULL,
      0.076791,
      1.541187,
      9.358663,
      2,
      3.641472,
      NULL,
      1,
      2,
      0.414041,
      1.225998,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.829574,
      1.917775,
      8.164779,
      2,
      1,
      7,
      4,
      3.609105,
      3.616748,
      3.081270,
      9,
      3.885332,
      2,
      0,
      3,
      1,
      3,
      3.733502,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.995114,
      NULL,
      NULL,
      1.941168,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.097235,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.378428,
      6.214168,
      NULL,
      0,
      191,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0,
      3,
      0.364978,
      3.961739,
      NULL,
      4,
      NULL,
      7,
      NULL,
      389.530192,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      3.589009,
      NULL,
      3.791995,
      0.783023,
      1,
      NULL,
      1,
      NULL,
      0.109088,
      NULL,
      2,
      NULL,
      3.584257,
      NULL,
      NULL,
      0.524145,
      1,
      NULL,
      10,
      NULL,
      3,
      NULL,
      9,
      NULL,
      0.873299,
      NULL,
      10.505012,
      NULL,
      NULL,
      NULL,
      14,
      NULL,
      2,
      NULL,
      2.495091,
      3,
      1,
      NULL,
      1,
      0,
      0.007765,
      NULL,
      1,
      2,
      3.741111,
      NULL,
      NULL,
      1.352038,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.329973,
      16,
      NULL,
      3.970432,
      2,
      2.205744,
      6,
      NULL,
      NULL,
      25,
      1.636012,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.651247,
      NULL,
      NULL,
      NULL,
      133,
      53,
      1.477227,
      NULL,
      NULL,
      3.088906,
      5.366880,
      0.619076,
      2167,
      53,
      NULL,
      2.496021,
      0.852275,
      1.865282,
      1.413707,
      3.161811,
      0.016079,
      0.004642,
      1.428831,
      1.659034,
      0,
      0,
      0,
      2.748319,
      1,
      1.469289,
      NULL,
      0,
      NULL,
      2.332978,
      NULL,
      3,
      NULL,
      2.076618,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      254,
      NULL,
      1.433267,
      20.616909,
      35.938389,
      2,
      0.990492,
      NULL,
      NULL,
      0.913812,
      NULL,
      0.505154,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.197958,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.065545,
      NULL,
      1.571247,
      NULL,
      NULL,
      NULL,
      0.153072,
      2.915349,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.599592,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.420966,
      NULL,
      1.050443,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.323492,
      NULL,
      0.623916,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.453806,
      2.973406,
      NULL,
      0.139346,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.648860,
      NULL,
      1,
      NULL,
      1.626809,
      NULL,
      NULL,
      NULL,
      1.842646,
      NULL,
      1.382941,
      NULL,
      1.328902,
      1.901489,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.823768,
      1.373629,
      1,
      NULL,
      NULL,
      1.494226,
      2,
      0,
      0.514475,
      0.475043,
      NULL,
      0.235604,
      2,
      1.169951,
      1,
      2,
      2.882399,
      NULL,
      NULL,
      1.221697,
      0.846318,
      2.207601,
      NULL,
      NULL,
      3.908410,
      3,
      0,
      3,
      0.451456,
      1.399122,
      NULL,
      NULL,
      0.668726,
      1.390993,
      8.397786,
      NULL,
      3.686318,
      2.096329,
      1,
      2,
      1.002658,
      NULL,
      NULL,
      0.502575,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.342269,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.799775,
      1,
      1.679290,
      0,
      1.061823,
      0,
      NULL,
      8,
      5,
      1.355799,
      1,
      NULL,
      NULL,
      NULL,
      7.359346,
      0,
      0,
      '44222',
      '44124',
      '',
      1,
      '',
      '',
      '',
      0.717490,
      NULL,
      '',
      '');
commit;
end;
/


