set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7150548';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-7-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '2',
      NULL,
      NULL,
      '4320332',
      3,
      NULL,
      4,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      14,
      NULL,
      0.475141,
      1.817782,
      1,
      ' 4-14-1979',
      15,
      2.621739,
      289.135061,
      NULL,
      2.637119,
      ' 5-20-1991',
      ' 8- 1-1994',
      '11-25-1999',
      3,
      1,
      1.494913,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.175246,
      12,
      NULL,
      13.959912,
      33,
      5,
      NULL,
      2,
      5.839742,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.514957,
      4,
      5.720960,
      1,
      NULL,
      0.685025,
      0.715667,
      NULL,
      1.406804,
      1.491571,
      NULL,
      0.700780,
      5.423561,
      2.606368,
      1,
      0.576680,
      NULL,
      1,
      3,
      1.423929,
      3,
      0.924786,
      NULL,
      NULL,
      0.659614,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      0.362671,
      1,
      1.179493,
      0.307033,
      NULL,
      0.249144,
      1.243322,
      1.148143,
      1,
      1,
      2.246382,
      0,
      2,
      NULL,
      1.336950,
      0.242124,
      NULL,
      0.420472,
      4,
      1,
      0,
      1,
      1.826293,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.651310,
      3,
      1,
      3,
      1,
      0.897803,
      0.801602,
      0.081986,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      1.481177,
      1,
      NULL,
      0,
      NULL,
      2.100619,
      0,
      2.575679,
      0,
      NULL,
      0,
      3,
      1.744984,
      6.649331,
      0.629028,
      NULL,
      2,
      1,
      0,
      9.712979,
      NULL,
      2.601921,
      NULL,
      2,
      5.855914,
      3,
      0.520484,
      5,
      7,
      0,
      1.156581,
      ' 7- 3-1987',
      355.197527,
      ' 9- 7-1988',
      NULL,
      0.839736,
      NULL,
      0.715739,
      0.956415,
      1.533816,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.416227,
      1.658311,
      1.381739,
      3.310531,
      0.869147,
      0.430595,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      2,
      2,
      9,
      1.999057,
      NULL,
      0.016090,
      1.809846,
      16,
      NULL,
      1.970257,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      9.178532,
      11,
      0,
      2.224861,
      6,
      0,
      NULL,
      NULL,
      1,
      9,
      1,
      5.384046,
      4.570052,
      0.576611,
      NULL,
      ' 9-26-1977',
      534.855120,
      ' 7-17-1982',
      13,
      0,
      1.652951,
      NULL,
      1,
      0.721416,
      1.675142,
      1,
      1,
      1,
      0.111657,
      1.919120,
      63.062746,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1.271944,
      2,
      3.890385,
      NULL,
      0.240137,
      NULL,
      0.613532,
      1,
      0,
      1.343025,
      NULL,
      0,
      NULL,
      1,
      0,
      3.779272,
      NULL,
      1.596630,
      2.087364,
      1.679342,
      0.365021,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      14,
      4.809886,
      1.848751,
      1.938384,
      4,
      4.511205,
      4,
      4,
      0.551121,
      3.058355,
      0,
      1.692797,
      1,
      3.923918,
      1.426841,
      50,
      1.411711,
      1,
      NULL,
      15,
      54,
      19,
      NULL,
      1.278834,
      2.539602,
      '41044',
      NULL,
      '',
      1,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      '',
      0,
      14,
      46.436606,
      3.129714,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.108433,
      1.329632,
      0.120506,
      0,
      NULL,
      NULL,
      1.477418,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.397462,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      0.250052,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.402085,
      3,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.489754,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.879401,
      NULL,
      NULL,
      0.292985,
      NULL,
      NULL,
      0.588838,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.093176,
      0.821844,
      1.566338,
      2.935515,
      1.782029,
      NULL,
      NULL,
      5.705075,
      2,
      NULL,
      NULL,
      NULL,
      0.564091,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.367770,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.152758,
      NULL,
      NULL,
      3.538338,
      3,
      1.070016,
      0,
      NULL,
      NULL,
      1,
      5.040622,
      NULL,
      2,
      5.213956,
      0.763320,
      NULL,
      NULL,
      NULL,
      0.079766,
      1,
      1,
      1.761139,
      2,
      3,
      NULL,
      3,
      0,
      9.002812,
      NULL,
      6.899134,
      0,
      NULL,
      3,
      3,
      2.688782,
      NULL,
      2,
      3,
      3.284115,
      1.452584,
      3,
      2,
      0.762968,
      5,
      NULL,
      2,
      NULL,
      0.249861,
      0,
      NULL,
      NULL,
      0.139033,
      1.727053,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      0.284521,
      0.916199,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.063343,
      4.970671,
      0,
      3.761750,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.690391,
      2.449427,
      1,
      1.701857,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.410825,
      0,
      0,
      0.171877,
      1,
      1,
      0.388739,
      0.606672,
      NULL,
      0.865530,
      NULL,
      1.635028,
      0.408900,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      1.605497,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.144518,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.200201,
      0.044549,
      NULL,
      3.155000,
      NULL,
      3.553584,
      0.447720,
      2,
      3.520355,
      1,
      NULL,
      0.021302,
      2.964165,
      0.014146,
      3,
      3.123489,
      0.131736,
      2.179977,
      NULL,
      NULL,
      1.215164,
      1.219009,
      1.453741,
      0.188727,
      1,
      3.940839,
      1,
      3.650588,
      1,
      3.898750,
      1.340794,
      3,
      NULL,
      3.482805,
      0,
      2,
      0,
      0.404361,
      1,
      NULL,
      1,
      3.917927,
      2,
      3,
      0,
      3,
      1,
      1.977474,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.432710,
      0,
      0.014221,
      1.802783,
      0,
      0.795503,
      1.076726,
      1,
      0,
      0.473591,
      3,
      2.564585,
      NULL,
      3.390026,
      NULL,
      3,
      2.031921,
      NULL,
      1,
      0.407538,
      2,
      2.884064,
      NULL,
      NULL,
      3.675861,
      3.305761,
      1.241386,
      20.007656,
      1,
      NULL,
      NULL,
      0.077831,
      NULL,
      3.395383,
      1,
      0,
      1.429919,
      9,
      3.087810,
      NULL,
      0.528445,
      2.705516,
      62.177022,
      NULL,
      1,
      0.183640,
      0,
      '11021',
      '',
      '',
      2,
      '22001',
      '',
      '',
      1.308173,
      '',
      '',
      '');
commit;
end;
/


