set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9768014';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-12-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1,
      2.606174,
      4,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4,
      '2101403',
      1,
      NULL,
      NULL,
      2,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      0,
      81,
      NULL,
      1.112336,
      2.194471,
      '11-26-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      3.736976,
      ' 0-16-1998',
      NULL,
      ' 0-26-1999',
      NULL,
      3.610764,
      1.954069,
      NULL,
      NULL,
      3.652828,
      0,
      2,
      NULL,
      NULL,
      NULL,
      4.646547,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.046203,
      2,
      1,
      0.565334,
      1.123308,
      NULL,
      0,
      0.785563,
      NULL,
      0,
      0,
      0,
      4.244021,
      3,
      1.078139,
      0,
      1,
      0.577487,
      NULL,
      1.266718,
      NULL,
      NULL,
      NULL,
      1.150223,
      1.748459,
      1.180354,
      1,
      3,
      1.619850,
      5.065714,
      1,
      1,
      0.211163,
      NULL,
      NULL,
      1.860262,
      NULL,
      NULL,
      2.261831,
      1.335143,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.798815,
      0.384392,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      0.500959,
      4,
      NULL,
      8,
      0,
      1.069183,
      NULL,
      0.994448,
      2.710306,
      1,
      8,
      1,
      1.650861,
      NULL,
      NULL,
      1,
      NULL,
      1.796677,
      1.980105,
      8.941642,
      1,
      NULL,
      NULL,
      7.662503,
      3.145666,
      NULL,
      0.298473,
      1,
      0,
      0.219546,
      5,
      1,
      NULL,
      6.477467,
      0.862575,
      NULL,
      9.146040,
      4.218360,
      4.712074,
      3,
      4.977543,
      1.244449,
      1,
      1,
      0.379095,
      NULL,
      58.148133,
      ' 1- 3-1994',
      NULL,
      2.803943,
      1,
      0,
      2.371723,
      1.169213,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      1.691076,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.206684,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.220270,
      0.543570,
      1.741060,
      0,
      1,
      0,
      4.402492,
      0.845020,
      7.520372,
      1.248412,
      0.532856,
      0.673870,
      1,
      NULL,
      NULL,
      NULL,
      0.329554,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      1,
      0.955275,
      3.560265,
      27,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      NULL,
      3,
      2.393782,
      7,
      7.673368,
      7,
      0,
      NULL,
      7,
      2.293007,
      NULL,
      7,
      0,
      0,
      0,
      3,
      NULL,
      0,
      0,
      1.663303,
      1.455537,
      NULL,
      NULL,
      0,
      0.930927,
      1.945387,
      4,
      NULL,
      8.332539,
      4,
      2.062763,
      10.443522,
      0,
      NULL,
      1,
      3.052651,
      4,
      2,
      3.585996,
      NULL,
      13,
      0.390652,
      0.524617,
      NULL,
      NULL,
      53.574591,
      NULL,
      NULL,
      NULL,
      1.992317,
      '03131',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      28.050314,
      91.231324,
      31,
      1.806111,
      1,
      1.982597,
      NULL,
      0,
      0.368858,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.908174,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.919858,
      0.676444,
      1.262977,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.398197,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.185472,
      0,
      1.689115,
      1.878557,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.746755,
      NULL,
      NULL,
      1.001226,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.381224,
      NULL,
      NULL,
      1.012361,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.846343,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.261077,
      NULL,
      NULL,
      3,
      NULL,
      1.390840,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.966586,
      1,
      NULL,
      NULL,
      NULL,
      4.737243,
      0,
      0.028759,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      0.598996,
      1,
      4,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.366847,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.595374,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.267831,
      2.016621,
      NULL,
      NULL,
      1,
      1,
      NULL,
      3.088874,
      1,
      0.225070,
      7,
      1,
      2,
      1,
      0.470578,
      NULL,
      0.711800,
      NULL,
      NULL,
      0.546977,
      1.603243,
      0,
      0.927065,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.361669,
      1.823457,
      0.734475,
      1.073545,
      NULL,
      NULL,
      0.130567,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.290453,
      NULL,
      NULL,
      NULL,
      1.168076,
      1,
      1,
      0,
      1.387731,
      1.552535,
      0,
      NULL,
      NULL,
      3,
      NULL,
      1.938873,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      40.508235,
      1.911298,
      NULL,
      1,
      0.859199,
      NULL,
      0,
      1,
      0,
      NULL,
      1.470556,
      NULL,
      1,
      0.521291,
      0.224669,
      1.497871,
      1,
      1,
      0,
      2,
      NULL,
      0.329120,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.047360,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.632201,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.763894,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.891476,
      1.878421,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.823113,
      1.698124,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.042127,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.591099,
      2.294281,
      1.820669,
      0.945428,
      0.695779,
      0,
      NULL,
      NULL,
      0.351786,
      0,
      NULL,
      1,
      0.205414,
      1.915639,
      NULL,
      0.379549,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.254114,
      0.844746,
      0.435374,
      0.601764,
      NULL,
      0,
      0,
      5,
      11,
      0.447754,
      3,
      NULL,
      1.161224,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.815783,
      1.208967,
      NULL,
      NULL,
      0.448192,
      NULL,
      NULL,
      0.662247,
      NULL,
      1,
      1.385099,
      NULL,
      0.308142,
      0.141273,
      NULL,
      NULL,
      0.917913,
      NULL,
      NULL,
      0.772657,
      NULL,
      0.331813,
      0.489624,
      NULL,
      1.855786,
      1.858196,
      NULL,
      0.694652,
      1.260702,
      0.820066,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.021475,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.896332,
      NULL,
      1,
      5,
      2,
      1,
      NULL,
      NULL,
      82,
      NULL,
      NULL,
      0,
      2.161827,
      '04404',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      '');
commit;
end;
/


