set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9768014';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-3-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2,
      1,
      2,
      1,
      3,
      3,
      1.437068,
      3,
      '421',
      '10400411',
      4.990959,
      15,
      '1313232',
      5,
      NULL,
      2,
      0,
      NULL,
      4.737168,
      1,
      NULL,
      NULL,
      ' 9-11-1995',
      199,
      104.809330,
      NULL,
      1,
      NULL,
      ' 8-20-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 3-16-1984',
      '10-10-1977',
      '10- 6-1979',
      1.575556,
      0,
      2.258549,
      2,
      1.739167,
      NULL,
      0,
      0.425548,
      NULL,
      4,
      9,
      3.287384,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.598802,
      NULL,
      0.753392,
      0,
      1,
      NULL,
      0.071071,
      0,
      NULL,
      1.031131,
      0,
      1,
      0.584498,
      2,
      NULL,
      3.601113,
      1,
      3.529788,
      1.632001,
      0,
      NULL,
      0,
      0.303623,
      2,
      1.123731,
      3.648496,
      2.436053,
      2.393153,
      NULL,
      0,
      0.425809,
      1,
      0,
      NULL,
      1.521957,
      NULL,
      NULL,
      1.807710,
      NULL,
      NULL,
      1.830760,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.680834,
      1,
      1.190174,
      1.727301,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.470663,
      0.358892,
      1,
      1,
      1,
      2,
      1.274179,
      1,
      1.213221,
      0,
      1.617653,
      3.122673,
      1,
      2,
      1,
      0.874459,
      1,
      1,
      1.520168,
      NULL,
      0,
      5.940085,
      1,
      NULL,
      5,
      1.621798,
      NULL,
      NULL,
      7.168690,
      2.450752,
      NULL,
      NULL,
      1.695536,
      NULL,
      0.148924,
      4,
      3.333526,
      6.234318,
      1.578791,
      0.869668,
      4,
      2.337983,
      1,
      1,
      0.475042,
      1.355549,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.341987,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.053237,
      0.010605,
      0,
      1.799030,
      0,
      0.297530,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.685033,
      2,
      2,
      1.657032,
      1,
      0.060252,
      4.722864,
      NULL,
      1.647544,
      0.976999,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.871832,
      0.017742,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1.399132,
      1.741897,
      0.360181,
      NULL,
      3.059378,
      45.554187,
      1,
      1,
      NULL,
      NULL,
      NULL,
      4.866927,
      1.755102,
      0,
      1.265499,
      0,
      1.167993,
      NULL,
      5,
      2.212073,
      5.127092,
      NULL,
      NULL,
      7.265604,
      2.587758,
      1.369554,
      7,
      0.140980,
      0,
      1.798626,
      NULL,
      0.560046,
      0.560220,
      1.586018,
      1,
      1.085484,
      1,
      NULL,
      1,
      1,
      3.583565,
      5.429634,
      1,
      3,
      NULL,
      4,
      0.605740,
      2,
      2.526893,
      1.917693,
      3.302000,
      NULL,
      NULL,
      2,
      0,
      1.467615,
      NULL,
      3.568179,
      0,
      NULL,
      3.520734,
      20,
      1,
      3.556811,
      0.939363,
      '04142',
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      2.806269,
      19,
      163,
      1.628808,
      0,
      30,
      1,
      1,
      2,
      NULL,
      1.099524,
      NULL,
      1,
      NULL,
      NULL,
      1.258882,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.098046,
      NULL,
      NULL,
      0,
      0.125432,
      1,
      0.626269,
      NULL,
      NULL,
      1.666744,
      NULL,
      NULL,
      0.321475,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.526936,
      1,
      1.302059,
      NULL,
      1.073710,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.678164,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.250294,
      NULL,
      NULL,
      3,
      0,
      0.556801,
      3.203329,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.164381,
      NULL,
      NULL,
      2.888956,
      0,
      NULL,
      1.896127,
      NULL,
      NULL,
      0,
      3,
      1,
      2.905307,
      0.423504,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.293303,
      1,
      0,
      NULL,
      NULL,
      0.657155,
      NULL,
      NULL,
      1.525743,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.479808,
      NULL,
      NULL,
      0.121802,
      NULL,
      NULL,
      1.964604,
      0.503580,
      1,
      2.154042,
      0.651583,
      0.266938,
      2,
      0.264903,
      0,
      0,
      0.739350,
      1,
      NULL,
      NULL,
      NULL,
      3.568310,
      1,
      NULL,
      1.676128,
      NULL,
      NULL,
      3,
      1,
      0,
      1.183945,
      0.201670,
      0,
      1.020876,
      0,
      0,
      3,
      0,
      2.060127,
      1,
      1,
      3.593657,
      2,
      1,
      0.710503,
      0.042825,
      1.863638,
      2.806564,
      5.847316,
      0.421845,
      0,
      0.909112,
      4,
      2,
      0,
      1.450191,
      1.315562,
      1,
      0.990724,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.148219,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.617666,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.503735,
      NULL,
      NULL,
      1.136846,
      0.653873,
      1,
      0,
      1.292542,
      0,
      2,
      NULL,
      NULL,
      NULL,
      1.804435,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.557343,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.915883,
      NULL,
      NULL,
      NULL,
      2.535465,
      2.754513,
      NULL,
      NULL,
      1.532370,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.707509,
      3,
      NULL,
      NULL,
      0.507665,
      0.911232,
      NULL,
      NULL,
      2,
      0.252687,
      NULL,
      NULL,
      0.083151,
      1,
      NULL,
      NULL,
      2,
      8,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      20,
      5,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.162698,
      NULL,
      NULL,
      0.559936,
      NULL,
      0.810104,
      21.449352,
      NULL,
      0.168590,
      2.767176,
      1,
      3.540591,
      NULL,
      0.208530,
      0,
      0.986515,
      0.350032,
      3,
      NULL,
      1.106576,
      0.977579,
      1,
      1.231927,
      0,
      NULL,
      NULL,
      NULL,
      0.062506,
      NULL,
      1.312309,
      NULL,
      NULL,
      NULL,
      0.092078,
      NULL,
      0.536173,
      NULL,
      1.238273,
      NULL,
      0.947804,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.738085,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.541435,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.902132,
      1,
      NULL,
      1,
      NULL,
      0.346187,
      NULL,
      NULL,
      NULL,
      0.717745,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.234599,
      NULL,
      2.241180,
      3.984114,
      1.630550,
      0,
      3.317622,
      NULL,
      1.921405,
      1,
      0,
      0,
      0.149432,
      0,
      0.353858,
      1.422742,
      3.158223,
      0.549832,
      1,
      1.698077,
      0,
      1,
      NULL,
      2.344365,
      0,
      NULL,
      1.624921,
      1,
      0,
      2.833757,
      NULL,
      0.859985,
      0,
      1,
      1.995925,
      1.510993,
      1,
      NULL,
      0,
      1.573515,
      3.953576,
      0,
      1.122001,
      1.051576,
      0,
      2.493981,
      1.467691,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.527304,
      0,
      0,
      NULL,
      0.565590,
      4.652762,
      0,
      1,
      0.938303,
      NULL,
      NULL,
      86.642557,
      82,
      4,
      NULL,
      2,
      NULL,
      '',
      '',
      1.355360,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


