set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9637671';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-1-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '00',
      '12',
      10.561176,
      11.380977,
      '4334420',
      3.121227,
      0,
      2,
      NULL,
      '3203',
      2.036486,
      0.171448,
      NULL,
      NULL,
      NULL,
      5.700174,
      3.712297,
      NULL,
      1,
      18,
      '10-13-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      0.732255,
      ' 4- 4-1991',
      '10-13-1983',
      ' 5- 8-1984',
      1.913050,
      NULL,
      2,
      NULL,
      0.061152,
      2,
      1,
      0.867352,
      NULL,
      623,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.483123,
      0.161604,
      NULL,
      1.531868,
      0.467307,
      0,
      0.066708,
      1.517054,
      0.859150,
      1,
      0.188350,
      0.691717,
      NULL,
      NULL,
      14.650361,
      11.228230,
      7.884140,
      0,
      NULL,
      0.273406,
      NULL,
      2,
      NULL,
      0,
      1,
      0,
      4,
      1,
      2.407626,
      NULL,
      5.674717,
      0.234895,
      4.182014,
      0,
      NULL,
      0.330683,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3.171531,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.088017,
      0.735691,
      NULL,
      0.160882,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.248930,
      NULL,
      0,
      NULL,
      0.532803,
      1,
      2,
      0.692877,
      1.259449,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      0,
      0.122910,
      NULL,
      4.848206,
      1,
      1.791353,
      1,
      1,
      NULL,
      1,
      3.657125,
      NULL,
      5,
      0,
      1,
      1.919609,
      2.743482,
      1.129372,
      NULL,
      NULL,
      NULL,
      7.222962,
      7,
      2.919678,
      0.784251,
      5,
      8,
      0.982913,
      1.922707,
      2.941581,
      NULL,
      ' 2-12-1984',
      412,
      ' 1-20-1975',
      NULL,
      0.037540,
      0,
      0.020923,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.358930,
      1.004090,
      0.546059,
      1,
      0,
      1.011630,
      1.406128,
      1.655382,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.979345,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.548260,
      NULL,
      NULL,
      1.193291,
      0.930967,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.883324,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      2.503676,
      1,
      1,
      1.949497,
      0.562089,
      NULL,
      0,
      3,
      49,
      NULL,
      15.482372,
      2.186105,
      1.930344,
      1,
      0.713555,
      NULL,
      0.477607,
      NULL,
      1.183826,
      NULL,
      0.888954,
      0.712672,
      1,
      3,
      1,
      0,
      0.248409,
      NULL,
      0.129516,
      1.491836,
      1.284890,
      0,
      1.296108,
      1.552878,
      1,
      0,
      1.051917,
      1.288576,
      0,
      NULL,
      1,
      0,
      NULL,
      8,
      6.782954,
      4.273358,
      0,
      NULL,
      0.133966,
      3.586200,
      0.903034,
      1.682501,
      0.539921,
      1.924259,
      3.939192,
      7,
      1.016078,
      2.165098,
      58.634845,
      NULL,
      24.651922,
      NULL,
      3.084346,
      NULL,
      0,
      '43444',
      NULL,
      NULL,
      1.845178,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '',
      NULL,
      NULL,
      100.791740,
      11,
      1.905651,
      12,
      NULL,
      45,
      4,
      0.357542,
      1.276121,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      2.244390,
      3.750571,
      NULL,
      NULL,
      2.221848,
      NULL,
      2.606090,
      1.038753,
      1.951870,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.788743,
      NULL,
      NULL,
      1.930112,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.637203,
      7,
      1,
      1,
      1.858864,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.565034,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.458128,
      0.141165,
      0.064484,
      1.107526,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.499448,
      1,
      0.357542,
      0,
      0.348028,
      0,
      1.543190,
      0,
      NULL,
      NULL,
      1.284834,
      NULL,
      NULL,
      1,
      NULL,
      1,
      6.791238,
      2.714837,
      0,
      0,
      0.723246,
      NULL,
      NULL,
      NULL,
      1.891071,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      NULL,
      1.582968,
      0.277144,
      NULL,
      NULL,
      NULL,
      10,
      3,
      2.461068,
      1.916741,
      NULL,
      1,
      NULL,
      NULL,
      0.713604,
      NULL,
      3.546284,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.121578,
      NULL,
      NULL,
      1.459297,
      NULL,
      NULL,
      1.089837,
      1.185237,
      0.309852,
      4.547440,
      2.402162,
      5.109596,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      11.199652,
      10,
      3,
      4.511916,
      NULL,
      NULL,
      1.174395,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.369334,
      2.051301,
      0.240585,
      NULL,
      1,
      2,
      NULL,
      5.694560,
      1.352754,
      2.081976,
      2.950279,
      1.516621,
      1.584361,
      0,
      1.629925,
      2,
      3.429915,
      3,
      2.397375,
      2,
      8.431228,
      NULL,
      NULL,
      3.638609,
      0,
      NULL,
      1,
      2,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      3.869808,
      NULL,
      NULL,
      0.920419,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.686967,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.652169,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.254253,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3.564745,
      NULL,
      NULL,
      NULL,
      NULL,
      1.622315,
      1.524140,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.372375,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.684250,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.809261,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.503395,
      NULL,
      NULL,
      NULL,
      1,
      512,
      415844,
      NULL,
      10.757362,
      779.173843,
      1.611021,
      NULL,
      NULL,
      0.122777,
      19,
      NULL,
      0,
      0,
      NULL,
      1.490034,
      NULL,
      NULL,
      3.760441,
      11,
      1.405786,
      163,
      73645.186344,
      0,
      NULL,
      1.168497,
      0.083032,
      1,
      NULL,
      1.722305,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.176980,
      1,
      NULL,
      1.498160,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.492076,
      5,
      2.186964,
      1,
      1,
      5.349763,
      5.806959,
      2.492334,
      0.600982,
      NULL,
      0,
      1,
      0.013838,
      1.932072,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.499782,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      0.650485,
      NULL,
      0.832570,
      0,
      NULL,
      1.521305,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.776921,
      0,
      NULL,
      0,
      1,
      1.839336,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.831674,
      NULL,
      1,
      NULL,
      1.676843,
      NULL,
      NULL,
      1,
      3.578772,
      2,
      1,
      0,
      56.665582,
      55.816319,
      4.454986,
      NULL,
      NULL,
      NULL,
      '',
      '',
      1.206558,
      NULL,
      NULL,
      NULL,
      1.949742,
      NULL,
      '',
      '');
commit;
end;
/


