set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7216172';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-12-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '0',
      NULL,
      NULL,
      '2024441',
      0,
      1,
      5,
      NULL,
      '3332',
      2.815089,
      1.636867,
      NULL,
      NULL,
      ' 1-15-1986',
      18.739126,
      NULL,
      4.923097,
      3,
      NULL,
      ' 9-11-1974',
      NULL,
      0,
      NULL,
      77.306092,
      3,
      ' 9-20-1983',
      ' 5- 4-1987',
      '10-25-1984',
      0,
      NULL,
      0,
      0.685762,
      1,
      3,
      0.375650,
      0,
      0,
      67,
      8,
      8,
      0,
      7.502952,
      NULL,
      3.464644,
      16.782428,
      NULL,
      NULL,
      NULL,
      1.653308,
      3,
      1,
      1.960447,
      0,
      0,
      0,
      0,
      NULL,
      1.313434,
      NULL,
      2,
      1,
      7.863195,
      1.726259,
      0,
      1,
      NULL,
      3.534224,
      1.804453,
      0.481028,
      3,
      NULL,
      NULL,
      1.096599,
      NULL,
      NULL,
      3.918229,
      0,
      3.700657,
      NULL,
      2.555849,
      0.546176,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.766998,
      0,
      0,
      NULL,
      NULL,
      1,
      0.540957,
      0,
      1.638292,
      NULL,
      0,
      1.554135,
      1,
      0,
      1.364007,
      0,
      0.819028,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.732204,
      0.373409,
      NULL,
      3.596419,
      1.231069,
      NULL,
      NULL,
      1.355183,
      NULL,
      NULL,
      NULL,
      1,
      1,
      4.923055,
      2.570545,
      0,
      2,
      NULL,
      NULL,
      1.991941,
      NULL,
      1.555311,
      0.364405,
      0.280179,
      0,
      0.068037,
      NULL,
      NULL,
      0,
      NULL,
      1,
      7.240775,
      1,
      2,
      9.171850,
      1.046412,
      1.233942,
      3.811624,
      NULL,
      2.640476,
      2.904018,
      3.233868,
      0,
      6,
      9,
      2,
      2.073237,
      NULL,
      6.265395,
      NULL,
      1.044445,
      1,
      7,
      1.231229,
      6,
      10.525642,
      3.596668,
      3,
      ' 2-17-1988',
      77.801715,
      '11-26-1976',
      94.129248,
      0.441216,
      1,
      1.890742,
      0,
      0.684697,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.319436,
      1.625133,
      1,
      NULL,
      0.793576,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.706594,
      NULL,
      NULL,
      NULL,
      1.999445,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.890400,
      NULL,
      NULL,
      NULL,
      5.471460,
      7.410955,
      2.260816,
      NULL,
      1,
      NULL,
      4.156088,
      2.875359,
      1.066629,
      1,
      0,
      NULL,
      0.145233,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      0,
      1,
      1,
      1,
      1.340561,
      29.966279,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.725493,
      1.935966,
      3,
      3,
      1,
      3.734131,
      1,
      NULL,
      2.311871,
      0,
      3.865425,
      NULL,
      0.905024,
      3.720179,
      1,
      5.029118,
      7.388005,
      NULL,
      1.827327,
      1,
      0.740817,
      0.830160,
      1,
      1.107838,
      0,
      1,
      NULL,
      NULL,
      NULL,
      3.743908,
      3.832181,
      0.108522,
      1,
      7.979331,
      NULL,
      1.936089,
      3.539757,
      NULL,
      1,
      3.403773,
      4.466764,
      1,
      3,
      2,
      14,
      0.822477,
      3,
      NULL,
      66.697639,
      60.219211,
      62,
      6.864467,
      NULL,
      2,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      1.897352,
      '',
      '',
      '',
      1,
      17,
      142.217255,
      30,
      1.314524,
      48,
      4.075567,
      6.588871,
      0.175830,
      1.602931,
      2,
      0.089216,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0.330045,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.663414,
      0,
      0,
      NULL,
      2.806292,
      1.130278,
      NULL,
      NULL,
      2,
      0,
      2,
      NULL,
      1.043251,
      0,
      1,
      2.998003,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.905062,
      1.481818,
      2.463107,
      1.611921,
      NULL,
      NULL,
      3,
      1.026593,
      NULL,
      NULL,
      1.064803,
      1,
      NULL,
      2,
      2.789428,
      2.418283,
      NULL,
      0,
      2.400359,
      1.189350,
      NULL,
      0,
      2.615192,
      0.052673,
      3,
      0,
      NULL,
      NULL,
      1.080575,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.755863,
      1.168145,
      3.891842,
      0.106992,
      0.435471,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.813761,
      NULL,
      NULL,
      1.231567,
      NULL,
      NULL,
      3,
      2,
      1,
      NULL,
      3,
      0.238180,
      9,
      NULL,
      7,
      1.120913,
      NULL,
      NULL,
      1.891780,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.697389,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.500491,
      NULL,
      NULL,
      1.866800,
      NULL,
      NULL,
      0.858690,
      NULL,
      NULL,
      NULL,
      0,
      2.640528,
      1.138152,
      NULL,
      NULL,
      NULL,
      1.159390,
      1.146801,
      5.762190,
      5.274764,
      3,
      2.155664,
      NULL,
      NULL,
      2,
      1,
      2,
      NULL,
      NULL,
      3.486492,
      2,
      NULL,
      0.724330,
      3,
      1,
      1,
      1.877465,
      0.143839,
      0,
      NULL,
      1.624466,
      0.058199,
      2.614828,
      0,
      3.273363,
      2,
      NULL,
      NULL,
      5,
      4.753757,
      NULL,
      NULL,
      6,
      4.406513,
      1,
      2.365904,
      6,
      1,
      0,
      0.740252,
      0.501126,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.970079,
      NULL,
      NULL,
      1.233579,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.203830,
      NULL,
      NULL,
      0.494482,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3.237437,
      NULL,
      NULL,
      2.601639,
      NULL,
      NULL,
      NULL,
      1,
      0.191319,
      1.785967,
      1,
      2.310347,
      0.128370,
      NULL,
      NULL,
      2.849315,
      NULL,
      NULL,
      NULL,
      353.139873,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.882872,
      NULL,
      NULL,
      NULL,
      1.051704,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.509617,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.324792,
      NULL,
      NULL,
      NULL,
      3.986991,
      NULL,
      NULL,
      NULL,
      1.941336,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.827389,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.485845,
      1.597639,
      3,
      NULL,
      NULL,
      NULL,
      0.343839,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.993376,
      NULL,
      NULL,
      0.591251,
      NULL,
      0,
      19056,
      856.038667,
      NULL,
      NULL,
      0.603767,
      1,
      1.574170,
      1.784119,
      1,
      1,
      1,
      0.975741,
      0.755308,
      NULL,
      1.081476,
      0,
      0.853867,
      NULL,
      NULL,
      1.246248,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.508024,
      0.280073,
      2,
      1.221165,
      0,
      1.075978,
      0.488000,
      7.034655,
      2.364993,
      NULL,
      NULL,
      0.079118,
      1.215548,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.769738,
      NULL,
      1.324904,
      NULL,
      NULL,
      1,
      0.900148,
      NULL,
      NULL,
      1.049684,
      NULL,
      NULL,
      0.874793,
      NULL,
      0.503466,
      1.942349,
      NULL,
      NULL,
      1.384130,
      NULL,
      1.056531,
      0.085612,
      NULL,
      0.726129,
      NULL,
      NULL,
      NULL,
      1,
      1.934069,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.406583,
      NULL,
      0,
      NULL,
      NULL,
      5,
      1,
      1,
      NULL,
      NULL,
      50.222807,
      NULL,
      2,
      1,
      NULL,
      '20012',
      '',
      '',
      1.527515,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '',
      '');
commit;
end;
/


