set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9788125';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-7-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      0,
      0.698575,
      1.416651,
      0,
      1,
      1,
      1.569296,
      '430',
      '43122034',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      1,
      '3224',
      1,
      0.480519,
      NULL,
      NULL,
      ' 2- 9-1986',
      51,
      179.286967,
      NULL,
      2,
      0.962834,
      '11-25-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 8-27-1996',
      ' 5-22-1974',
      NULL,
      1.039094,
      1,
      NULL,
      NULL,
      1.097065,
      0.226472,
      6.052609,
      2,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      2.136573,
      NULL,
      1,
      1.654550,
      1.676698,
      1,
      0.192339,
      0.541205,
      1.690128,
      NULL,
      NULL,
      10,
      0,
      0,
      0,
      3,
      NULL,
      NULL,
      0,
      2.387201,
      2,
      0,
      0.257029,
      4.314244,
      0,
      1,
      0.729805,
      0,
      0,
      0.586672,
      0,
      5.507090,
      5,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6,
      4,
      0.507747,
      3,
      3.600790,
      3,
      1.695039,
      0.272991,
      NULL,
      2,
      3,
      3.580621,
      0.825326,
      3,
      1.438815,
      3,
      NULL,
      NULL,
      1,
      0.181584,
      0,
      3.277316,
      NULL,
      NULL,
      0.572456,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.692682,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.466273,
      2,
      2,
      3,
      0.627126,
      0,
      3.847328,
      0.491643,
      1,
      0.843317,
      1.810899,
      1.648220,
      NULL,
      1.265682,
      1,
      0,
      4,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.211601,
      0.326793,
      2.802911,
      1.097067,
      5,
      4.070607,
      0,
      3,
      5,
      NULL,
      NULL,
      2.457294,
      1,
      1.524501,
      NULL,
      5,
      9,
      7,
      3.290874,
      ' 4-26-1978',
      NULL,
      ' 5-23-1988',
      NULL,
      3.272866,
      0,
      1,
      0,
      1.415565,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.965982,
      NULL,
      9,
      NULL,
      2,
      NULL,
      1.753158,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.531257,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.824592,
      1.753161,
      1.803829,
      0,
      3,
      0,
      1,
      5.575809,
      NULL,
      2,
      0,
      2,
      0,
      NULL,
      NULL,
      0.450904,
      4.507391,
      0.692071,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.465359,
      0.771800,
      0.378140,
      NULL,
      NULL,
      1.151489,
      0.896791,
      3,
      32,
      0,
      0.290772,
      NULL,
      NULL,
      NULL,
      NULL,
      0.305756,
      0,
      3,
      3.230893,
      NULL,
      3,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.714359,
      1.794529,
      1.268960,
      2,
      0.193123,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      1,
      0.721383,
      NULL,
      NULL,
      0.077543,
      0,
      1,
      NULL,
      6,
      7,
      2,
      1.102630,
      NULL,
      1,
      0.638432,
      3,
      0.790869,
      0,
      NULL,
      NULL,
      1.104790,
      3.297752,
      10.125609,
      NULL,
      32.867149,
      NULL,
      1.997872,
      3.024989,
      NULL,
      '21432',
      NULL,
      '',
      NULL,
      '',
      '',
      NULL,
      0.088597,
      '',
      '',
      NULL,
      1.981124,
      25,
      50,
      NULL,
      2,
      30.963699,
      1.690996,
      0,
      0,
      0.438146,
      NULL,
      NULL,
      0.703201,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      3.166510,
      NULL,
      1,
      3.731849,
      0.959448,
      NULL,
      NULL,
      NULL,
      NULL,
      1.953578,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.353503,
      NULL,
      NULL,
      4,
      0,
      0.578684,
      0.387910,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.652492,
      2,
      1,
      0,
      0,
      0,
      NULL,
      3,
      NULL,
      NULL,
      1.596922,
      0.904140,
      0.977014,
      1.848389,
      3.274866,
      0.002206,
      3,
      1,
      3,
      2.314670,
      1,
      NULL,
      0.630200,
      0,
      1,
      1,
      3.426836,
      1.272463,
      0,
      2.361868,
      0,
      0,
      1.306836,
      2,
      0.020222,
      0.653268,
      0.292814,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.883323,
      NULL,
      3,
      2,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.700987,
      1.924927,
      1.719010,
      NULL,
      NULL,
      0.310618,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.128306,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.816271,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.302880,
      NULL,
      NULL,
      0.988862,
      NULL,
      NULL,
      NULL,
      1.246082,
      5.954989,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.917120,
      0.244367,
      3,
      2,
      5,
      NULL,
      2,
      NULL,
      3.562361,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      2,
      0,
      1,
      NULL,
      3.947959,
      1.039969,
      4,
      NULL,
      3,
      0.706157,
      NULL,
      NULL,
      0.458156,
      1.122706,
      1.619733,
      0.170222,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.419016,
      1,
      0.465653,
      0.146276,
      0.599777,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      1,
      0.011323,
      1.691494,
      NULL,
      NULL,
      1.820381,
      0.612034,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.917133,
      NULL,
      1,
      350.078518,
      NULL,
      0.862365,
      1.038807,
      1,
      0,
      0.151388,
      1,
      0.183037,
      0.873014,
      1.510449,
      0.379909,
      0,
      2,
      1,
      NULL,
      1.960607,
      NULL,
      0.519445,
      1.682641,
      NULL,
      0.231485,
      NULL,
      0,
      NULL,
      3.697103,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      98,
      NULL,
      2,
      NULL,
      74.150745,
      1.575226,
      0.178366,
      NULL,
      NULL,
      0.344174,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.835083,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.320501,
      NULL,
      NULL,
      NULL,
      0.764931,
      NULL,
      1.035854,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.441597,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.222466,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.647035,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.893924,
      1.564134,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.229465,
      1.814165,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.226499,
      1,
      0,
      1,
      NULL,
      0,
      0,
      1.674051,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.567617,
      NULL,
      2,
      2,
      0.682564,
      NULL,
      3.377377,
      1.106974,
      11.342888,
      0,
      1,
      NULL,
      0,
      1.463016,
      NULL,
      1.295647,
      1,
      NULL,
      1.796240,
      1.545706,
      NULL,
      1.080211,
      1.051841,
      NULL,
      1.142251,
      NULL,
      NULL,
      NULL,
      0.315759,
      NULL,
      1.871620,
      0.727119,
      NULL,
      0.920475,
      NULL,
      NULL,
      0.541189,
      0,
      NULL,
      0.237236,
      0,
      NULL,
      0.827638,
      1.704348,
      NULL,
      3.862010,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.623662,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.843808,
      NULL,
      0,
      NULL,
      0.089750,
      7.850517,
      4,
      1.150925,
      NULL,
      NULL,
      20,
      99.706299,
      2,
      5,
      5.484598,
      NULL,
      '03120',
      '',
      0.538907,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


