set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9307628';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-2-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      '1013223',
      1.156967,
      1.533287,
      2,
      NULL,
      NULL,
      2.890589,
      1.709364,
      NULL,
      NULL,
      ' 9- 0-1995',
      1,
      NULL,
      5.971204,
      2,
      0,
      NULL,
      45,
      NULL,
      290,
      63.529761,
      2,
      ' 9-27-1991',
      ' 6-24-1998',
      '10- 7-2002',
      3.665888,
      0.353120,
      2,
      NULL,
      1.997450,
      NULL,
      NULL,
      1.262732,
      1.681173,
      1,
      5.494675,
      14.205339,
      5.098528,
      19,
      5.605678,
      3,
      NULL,
      1.371773,
      2,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.286375,
      NULL,
      3.261195,
      2.264644,
      NULL,
      0.499789,
      0,
      7,
      1.861650,
      1.212816,
      5,
      5,
      4,
      5.593868,
      9,
      NULL,
      9,
      1,
      1.791643,
      4,
      1,
      NULL,
      NULL,
      NULL,
      1.995799,
      NULL,
      NULL,
      3.674603,
      10.459911,
      2,
      2,
      1,
      1,
      1,
      NULL,
      0,
      1.547806,
      1.461779,
      0,
      1.503942,
      1,
      NULL,
      0,
      1,
      1,
      0.850911,
      4,
      NULL,
      1.484795,
      11,
      0.274812,
      0,
      0.296017,
      0.532438,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.741048,
      NULL,
      0,
      3.660725,
      2,
      0.914040,
      0,
      1.382299,
      NULL,
      NULL,
      0.913710,
      1,
      1,
      1.974820,
      0.448229,
      1.100053,
      0.045798,
      1.656925,
      NULL,
      1.467233,
      0,
      1.750169,
      0,
      NULL,
      2.988878,
      4,
      8,
      2.597782,
      NULL,
      4,
      6,
      NULL,
      0.934496,
      1,
      0.679469,
      9.207217,
      NULL,
      2.039503,
      NULL,
      9,
      6.624321,
      3,
      8.447180,
      3,
      NULL,
      0,
      2.284137,
      ' 9-25-2002',
      27.284688,
      ' 2-20-1978',
      NULL,
      1.625940,
      1.531211,
      0.906490,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.702313,
      1,
      NULL,
      1.835045,
      0,
      1.284221,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.393253,
      NULL,
      3.644527,
      NULL,
      0.277144,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.267232,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      7.250983,
      1.702559,
      2,
      3,
      1.079904,
      NULL,
      NULL,
      NULL,
      0.510834,
      0.565368,
      1.009138,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.783351,
      1.336892,
      1.707617,
      0,
      1.867308,
      0.734571,
      0.702205,
      2.474824,
      99,
      3.930995,
      0.647516,
      NULL,
      NULL,
      NULL,
      NULL,
      1.414496,
      NULL,
      3,
      0,
      1.004034,
      NULL,
      2,
      3.918933,
      1.927675,
      1.436103,
      NULL,
      NULL,
      2,
      13.756662,
      7,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.903058,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      2,
      NULL,
      7,
      NULL,
      0.715322,
      5,
      4.098719,
      3,
      NULL,
      0,
      NULL,
      0.650437,
      2,
      3,
      14.745957,
      3,
      0,
      NULL,
      NULL,
      33,
      76,
      3.343180,
      0,
      NULL,
      '42343',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      0.853353,
      '',
      '',
      '',
      0.684017,
      0.962933,
      10,
      3,
      1.935577,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.983092,
      1.822158,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.155106,
      2,
      2.838418,
      0,
      1,
      2.786100,
      0,
      NULL,
      NULL,
      2,
      2.049781,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.771278,
      NULL,
      NULL,
      NULL,
      0.947008,
      2,
      1.353195,
      NULL,
      NULL,
      0.833854,
      4.972464,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.922887,
      NULL,
      NULL,
      NULL,
      1.678584,
      3,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.486054,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.381949,
      NULL,
      NULL,
      0.307077,
      NULL,
      NULL,
      2.693528,
      NULL,
      3.344003,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.660542,
      NULL,
      NULL,
      0.531317,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1.916611,
      2.354768,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.964876,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.618335,
      NULL,
      NULL,
      0.672071,
      NULL,
      NULL,
      1.658411,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.641143,
      0.343334,
      NULL,
      NULL,
      NULL,
      3.372664,
      1,
      2.187857,
      0.924143,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      2.554941,
      1,
      1,
      0.265413,
      0.499077,
      1.162225,
      9,
      1.926464,
      0,
      2.333719,
      3,
      2.095210,
      0.477802,
      NULL,
      NULL,
      0,
      2,
      2.970842,
      3,
      3,
      6,
      1.782123,
      2.531120,
      2.952975,
      NULL,
      NULL,
      1.839693,
      0,
      2,
      0.848982,
      NULL,
      1.936180,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.037702,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.178491,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.985871,
      NULL,
      NULL,
      1,
      0,
      1,
      0.639081,
      0,
      3,
      NULL,
      NULL,
      NULL,
      3.711062,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.655202,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.699533,
      NULL,
      NULL,
      NULL,
      2.177428,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.797283,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.736512,
      NULL,
      NULL,
      NULL,
      2.529906,
      NULL,
      2.133608,
      0,
      NULL,
      NULL,
      0.958374,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.615563,
      NULL,
      NULL,
      1,
      NULL,
      0.998786,
      199,
      1,
      0.820680,
      1,
      1,
      1.396482,
      0,
      1,
      1.945551,
      0.407719,
      NULL,
      0,
      1.189099,
      0.289412,
      0.390858,
      1.932298,
      0.402224,
      0.127168,
      1.944120,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.106059,
      1,
      0,
      0.022199,
      2.971296,
      3,
      0,
      2.799335,
      10.903445,
      1,
      3,
      1,
      1.963550,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2,
      NULL,
      0.491343,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      3.437787,
      0.654014,
      NULL,
      NULL,
      1.938551,
      NULL,
      2.140391,
      3.872380,
      NULL,
      1,
      NULL,
      NULL,
      1.522949,
      1.231255,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      11,
      NULL,
      2.549764,
      NULL,
      47.923389,
      NULL,
      NULL,
      0.931017,
      3.570785,
      NULL,
      '',
      '',
      1.554523,
      '',
      '',
      '',
      0,
      '',
      NULL,
      '');
commit;
end;
/


