set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7825995';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-5-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '0',
      NULL,
      NULL,
      '1140230',
      NULL,
      1,
      NULL,
      3,
      '1112',
      1.231702,
      0.187079,
      NULL,
      NULL,
      ' 7- 3-1988',
      16.025948,
      NULL,
      4,
      0,
      1.759168,
      ' 6- 5-1997',
      59.429604,
      0,
      106.303562,
      21,
      0,
      ' 8- 2-1990',
      '10- 2-1976',
      '11- 2-1983',
      3,
      1.418686,
      1.146447,
      0,
      1,
      NULL,
      NULL,
      0.735223,
      0.238465,
      251,
      2.502045,
      13.693612,
      2.392580,
      7.117964,
      16.846490,
      2,
      19.847046,
      6.422252,
      0.971912,
      2,
      1.701411,
      3.853298,
      NULL,
      1,
      1.538376,
      0.156405,
      1.231197,
      0.962939,
      1.346839,
      NULL,
      0,
      2.472158,
      5,
      1.508675,
      2.428834,
      4,
      1,
      NULL,
      0,
      0.844657,
      1,
      NULL,
      0.065943,
      NULL,
      NULL,
      1.341090,
      0.788032,
      7.932713,
      1.177644,
      2.567992,
      1.081830,
      3,
      0.198456,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      0.799624,
      1,
      0.254286,
      0.355327,
      1.788168,
      1.139051,
      0.368121,
      2.392801,
      0,
      2.746565,
      0.698571,
      1.436432,
      2.865893,
      NULL,
      0,
      1.079230,
      2.117642,
      NULL,
      0.760924,
      11.581083,
      0.474404,
      0.700861,
      2,
      0,
      NULL,
      NULL,
      1.457686,
      NULL,
      NULL,
      4,
      NULL,
      4,
      NULL,
      6,
      1,
      7,
      1.167511,
      0.133494,
      1,
      NULL,
      NULL,
      1.332720,
      5,
      3.458283,
      0,
      1,
      2.153276,
      0,
      NULL,
      2,
      7,
      7.160356,
      6.710231,
      NULL,
      3,
      NULL,
      NULL,
      3,
      NULL,
      5,
      0,
      9.406033,
      5,
      3.860180,
      7,
      10,
      9.938995,
      8,
      2.004026,
      8,
      1,
      2,
      0,
      10,
      8.489077,
      6.309479,
      2,
      ' 1- 0-2003',
      NULL,
      ' 3- 9-1985',
      1731,
      0.324668,
      0.856297,
      1.765130,
      7,
      3.711229,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      2.383326,
      1.200460,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.209030,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0.695841,
      1,
      0,
      1.872952,
      1.719642,
      0,
      1.849949,
      3.286956,
      NULL,
      0.967957,
      NULL,
      0.706550,
      1,
      2.104390,
      1,
      0.124481,
      5.127864,
      2,
      NULL,
      NULL,
      NULL,
      0.967023,
      5.300581,
      0.835206,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.320876,
      NULL,
      2,
      1,
      1.832617,
      NULL,
      2,
      37,
      3.009995,
      1.381839,
      NULL,
      NULL,
      NULL,
      NULL,
      0.612162,
      0.372757,
      NULL,
      3.662946,
      NULL,
      0.189579,
      2.632614,
      2,
      NULL,
      1,
      NULL,
      3,
      NULL,
      3.522624,
      0.813692,
      0,
      0,
      NULL,
      1,
      NULL,
      1.772666,
      1.248637,
      NULL,
      0,
      1,
      0.123443,
      NULL,
      0.432865,
      1,
      2.913163,
      NULL,
      0.572568,
      7,
      6.985265,
      0,
      11,
      0.502892,
      4.516829,
      2.155900,
      6.163416,
      2.775266,
      0.897447,
      NULL,
      23.589362,
      0,
      3,
      NULL,
      30,
      NULL,
      NULL,
      1,
      5.058495,
      NULL,
      '14002',
      '',
      '',
      1.874023,
      '',
      '',
      '',
      4.910004,
      '12110',
      '42013',
      '',
      3.657376,
      NULL,
      395,
      NULL,
      1,
      14,
      NULL,
      NULL,
      0,
      0.295553,
      0.155594,
      0.069532,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      3,
      1.827158,
      3.245789,
      2.661634,
      1,
      NULL,
      3.876034,
      1.955538,
      2.583025,
      0,
      0.526791,
      2,
      NULL,
      1.741773,
      NULL,
      0,
      1,
      3.630760,
      3.375672,
      0.946038,
      0.731809,
      NULL,
      NULL,
      10,
      NULL,
      2.404914,
      1,
      1.025869,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      2.574421,
      0.704150,
      1,
      NULL,
      3,
      0.222392,
      3,
      NULL,
      NULL,
      1,
      1.823011,
      1.751066,
      0.900332,
      1,
      3.696746,
      3.315328,
      0.205147,
      NULL,
      1,
      NULL,
      0.921045,
      0.612359,
      NULL,
      NULL,
      0.655552,
      0,
      3.412290,
      1.165755,
      2,
      2,
      1,
      NULL,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.199756,
      NULL,
      NULL,
      NULL,
      NULL,
      3.191348,
      0,
      0.836172,
      0.714541,
      0,
      3.465143,
      3.542541,
      NULL,
      0.610894,
      NULL,
      NULL,
      8.604585,
      9.402433,
      NULL,
      0,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      7,
      5.588766,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.125559,
      NULL,
      1,
      NULL,
      NULL,
      2.993678,
      8,
      0,
      8.148816,
      6,
      3.491879,
      2.112266,
      0.791341,
      0,
      2,
      3.736226,
      3.431609,
      NULL,
      2,
      2.237056,
      3.870452,
      1.778632,
      1.863486,
      NULL,
      6,
      6,
      2.318106,
      2.024343,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.160794,
      NULL,
      3.219626,
      NULL,
      0,
      8.357210,
      3.752673,
      6.900559,
      0.420609,
      NULL,
      4.669098,
      NULL,
      NULL,
      8.839399,
      NULL,
      0,
      NULL,
      0.524252,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.057855,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.960038,
      1,
      0.464719,
      NULL,
      0.908073,
      2.656642,
      0.698860,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      0.002925,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.025818,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.374946,
      NULL,
      NULL,
      NULL,
      2.099673,
      NULL,
      NULL,
      NULL,
      2.542515,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.790644,
      NULL,
      NULL,
      NULL,
      1.349488,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      8,
      4.326513,
      2,
      404,
      136.904333,
      NULL,
      NULL,
      1.497590,
      1.599336,
      NULL,
      NULL,
      NULL,
      0.741111,
      0.026686,
      2.553008,
      214.126798,
      71.817279,
      1.937374,
      NULL,
      NULL,
      1,
      NULL,
      1.783289,
      NULL,
      NULL,
      0.551661,
      1.512921,
      NULL,
      0.476006,
      0.706092,
      1.968780,
      NULL,
      1.672608,
      1,
      0,
      1.379446,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.588381,
      2,
      2,
      5,
      1.115327,
      NULL,
      0,
      NULL,
      2.378876,
      NULL,
      2.477260,
      0,
      0.326077,
      0,
      NULL,
      0.559119,
      3,
      NULL,
      1.948061,
      3,
      NULL,
      1,
      NULL,
      NULL,
      1.709113,
      1.328194,
      NULL,
      1,
      0.312256,
      NULL,
      NULL,
      2,
      NULL,
      1.590263,
      2.708442,
      NULL,
      0,
      2.148885,
      NULL,
      1,
      NULL,
      NULL,
      1.120428,
      0.083162,
      NULL,
      3,
      0.785317,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.857953,
      NULL,
      7,
      NULL,
      2.127361,
      1,
      0.589551,
      0.821998,
      80.375422,
      40.894721,
      0.895574,
      2,
      1,
      '12000',
      '',
      '',
      1.767034,
      '',
      '',
      '',
      5,
      NULL,
      '20302',
      '');
commit;
end;
/


