set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8633212';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-5-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '1',
      NULL,
      NULL,
      '1333201',
      1.845067,
      1.964862,
      0,
      NULL,
      '1000',
      NULL,
      1.873815,
      NULL,
      NULL,
      ' 5-26-1980',
      NULL,
      NULL,
      3.740926,
      0,
      1.400333,
      ' 3-12-1982',
      1.198572,
      1.866389,
      191,
      63.734179,
      1.694400,
      '10-10-2001',
      ' 1- 0-1986',
      NULL,
      2,
      3.157156,
      1,
      2,
      2,
      NULL,
      1.397936,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      22,
      NULL,
      4.210351,
      12,
      4,
      2.978965,
      3.185203,
      NULL,
      NULL,
      2,
      1.402403,
      0.235051,
      NULL,
      1,
      0.747166,
      1,
      1.149667,
      0,
      1,
      3,
      0.290579,
      1,
      7.784939,
      6,
      3,
      9,
      4,
      3,
      0.530608,
      0,
      1.563171,
      0.959069,
      0.125963,
      1,
      8.215456,
      0,
      4.801612,
      0,
      NULL,
      1.713233,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.494689,
      4.779097,
      0.648199,
      2.392929,
      NULL,
      1,
      0.529078,
      NULL,
      2,
      NULL,
      1,
      3.948471,
      2.642344,
      0.051550,
      NULL,
      2,
      1.042912,
      0,
      NULL,
      2,
      NULL,
      NULL,
      7,
      NULL,
      0,
      2,
      1.817546,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      3,
      1,
      6.230797,
      NULL,
      1,
      1.183808,
      0,
      5.702549,
      NULL,
      0.496945,
      1.954221,
      1.585299,
      1,
      1,
      0.876957,
      0.046503,
      0.873674,
      NULL,
      NULL,
      1,
      NULL,
      1.473516,
      1,
      1.646207,
      NULL,
      0,
      NULL,
      0,
      0,
      1.675499,
      0,
      1,
      1.175988,
      NULL,
      NULL,
      0.161286,
      0,
      NULL,
      1,
      8.495519,
      NULL,
      5.189184,
      NULL,
      1.799343,
      NULL,
      0,
      ' 3- 2-1997',
      283,
      ' 0- 7-1998',
      NULL,
      0,
      2.290102,
      0,
      3,
      5,
      9.417745,
      NULL,
      1,
      NULL,
      0,
      6.879091,
      5.070893,
      5,
      NULL,
      3,
      0.341300,
      6.677696,
      6,
      1,
      12,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.065429,
      0,
      NULL,
      0.043323,
      1.901343,
      0,
      NULL,
      NULL,
      NULL,
      0.483520,
      0,
      0.189021,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.459496,
      1,
      0.024454,
      0,
      1.164175,
      NULL,
      0,
      45,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      3.703407,
      2,
      1,
      3.742630,
      2,
      NULL,
      3.198491,
      NULL,
      1.421663,
      0,
      NULL,
      1,
      1.954579,
      0.092614,
      1.343299,
      1.376326,
      1.823454,
      0,
      5,
      1,
      1,
      1,
      1.612894,
      0,
      2,
      0.490870,
      2,
      1.509230,
      4,
      11.665752,
      3,
      8.668600,
      8.398365,
      2,
      4.236077,
      NULL,
      7,
      0,
      3.998477,
      2.450674,
      14,
      1.696532,
      2.988866,
      NULL,
      32,
      60,
      NULL,
      4,
      NULL,
      3.238184,
      '43323',
      NULL,
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      3.410037,
      43,
      197,
      20,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.253852,
      0.361191,
      2,
      2.715998,
      NULL,
      1,
      NULL,
      0,
      0,
      3,
      1.004494,
      1,
      0.821763,
      1.710274,
      1,
      1,
      NULL,
      NULL,
      3.271116,
      1.157305,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.653441,
      NULL,
      NULL,
      3.842087,
      1.278186,
      NULL,
      NULL,
      1.700484,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.174643,
      1,
      NULL,
      1.504837,
      0,
      0,
      0.568807,
      NULL,
      NULL,
      0,
      2.358425,
      1,
      2.020847,
      0.742347,
      0,
      1.872904,
      0.255317,
      NULL,
      3,
      1.810750,
      3.628258,
      1.037673,
      1,
      NULL,
      0.608144,
      0.282758,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.934088,
      1,
      1.395501,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      2.476586,
      0,
      1,
      3,
      1.568792,
      NULL,
      0,
      1,
      2.040332,
      1,
      NULL,
      NULL,
      0.205176,
      NULL,
      NULL,
      0.759811,
      NULL,
      NULL,
      0.363521,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.885942,
      NULL,
      NULL,
      0.476502,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.195747,
      NULL,
      NULL,
      1.422168,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1.779440,
      NULL,
      NULL,
      5,
      1,
      2.776979,
      1,
      NULL,
      NULL,
      1,
      0.874469,
      2,
      0,
      0.429060,
      1,
      2.932691,
      0.687645,
      NULL,
      4,
      NULL,
      3.549853,
      0.995006,
      NULL,
      NULL,
      0.773560,
      NULL,
      2,
      1.141952,
      NULL,
      0.238387,
      1.305288,
      NULL,
      0.169477,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.129360,
      2.975590,
      NULL,
      NULL,
      1,
      3,
      0.254785,
      0.626359,
      NULL,
      1.312556,
      NULL,
      15.603301,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.564098,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.497517,
      NULL,
      1,
      NULL,
      1.576147,
      NULL,
      1,
      NULL,
      1,
      NULL,
      3.576728,
      NULL,
      1.959060,
      NULL,
      1.410153,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.068457,
      NULL,
      0.406586,
      NULL,
      0,
      NULL,
      1.770862,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.012011,
      NULL,
      NULL,
      NULL,
      0.813124,
      NULL,
      2,
      1.759808,
      29,
      16.453134,
      1.460205,
      NULL,
      NULL,
      2,
      14,
      0,
      0.652392,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      1.009322,
      0,
      NULL,
      NULL,
      0,
      1,
      1.330248,
      0.936899,
      0.032786,
      NULL,
      1,
      0.318357,
      0.845660,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.177321,
      3.605864,
      NULL,
      0.715061,
      0.368931,
      2,
      0.628991,
      NULL,
      3,
      1.887697,
      2,
      1.578778,
      0.622852,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      0.673993,
      NULL,
      0.712619,
      1.974322,
      1,
      2,
      0,
      0.344698,
      0,
      NULL,
      NULL,
      2,
      1.332747,
      NULL,
      0.290288,
      0,
      1,
      3,
      0,
      NULL,
      0,
      1.337626,
      1.073408,
      NULL,
      3,
      0,
      1.432123,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.428474,
      0.836757,
      4.472156,
      2.992171,
      6.200950,
      1,
      NULL,
      NULL,
      NULL,
      63.587076,
      2,
      1.697349,
      5,
      '23434',
      '34110',
      '',
      1.525193,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


