set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9933372';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-6-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      4,
      2,
      3.337318,
      1.760840,
      0,
      NULL,
      3,
      0.047735,
      '102',
      NULL,
      59,
      76.523985,
      '1432403',
      2,
      NULL,
      3,
      NULL,
      '4332',
      1,
      NULL,
      NULL,
      NULL,
      '11- 6-2000',
      56.752167,
      65,
      NULL,
      0,
      8.136041,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-17-1979',
      '11-17-1995',
      ' 3-25-1984',
      0.659693,
      3.627107,
      2.549822,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      11.920794,
      11.816467,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.980865,
      0.075231,
      1,
      1,
      0.447296,
      0,
      0,
      1.937846,
      NULL,
      4,
      1,
      2.077165,
      1,
      3.997953,
      1,
      2,
      0,
      0,
      NULL,
      1,
      NULL,
      0.818449,
      1,
      6.594358,
      1,
      NULL,
      0.840713,
      NULL,
      1.346430,
      3,
      1.554411,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      3.805625,
      NULL,
      NULL,
      1.194233,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      1,
      0,
      1,
      NULL,
      1.802085,
      0,
      0.371958,
      1,
      0.898629,
      1,
      6.699966,
      0.195188,
      0.154646,
      0,
      1.527834,
      NULL,
      NULL,
      0.552934,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      2.608102,
      NULL,
      1.537785,
      1,
      0,
      1.622112,
      NULL,
      1,
      1.523113,
      2,
      NULL,
      NULL,
      1.442430,
      NULL,
      NULL,
      NULL,
      1.573476,
      9.411281,
      0,
      NULL,
      0.229793,
      1.481933,
      NULL,
      NULL,
      6,
      4,
      NULL,
      1,
      4.282454,
      6.835168,
      1.476323,
      0.211114,
      3,
      NULL,
      6,
      6.955353,
      1.174309,
      0.458565,
      6.592486,
      6,
      1.810603,
      5.526952,
      3.786302,
      NULL,
      ' 1-22-1974',
      10,
      ' 6-28-1984',
      5,
      0,
      3,
      1,
      5.100400,
      0.883759,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.229735,
      0,
      NULL,
      1.689540,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.279765,
      NULL,
      6,
      1.878253,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      8.228143,
      3,
      1,
      1.248934,
      0.774284,
      NULL,
      NULL,
      NULL,
      0,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.675430,
      0.265717,
      3,
      0,
      0.133006,
      0.976595,
      3.088304,
      22.551530,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.208633,
      1,
      0,
      1.418364,
      3.219321,
      3,
      NULL,
      2,
      NULL,
      3,
      2,
      3,
      3,
      NULL,
      2.750436,
      NULL,
      2,
      0,
      1.375015,
      4,
      1,
      1,
      0,
      0.856813,
      1.451144,
      1,
      0.256028,
      1.366134,
      0.331237,
      1,
      2.588379,
      1.712057,
      8.880370,
      0,
      7.354734,
      NULL,
      6.739595,
      1,
      0.192886,
      3,
      5,
      2.664070,
      1.024813,
      2.251116,
      33.798736,
      3,
      NULL,
      61.139766,
      NULL,
      14.678451,
      46.531750,
      3,
      5,
      5.144712,
      '04001',
      '22332',
      NULL,
      NULL,
      '32132',
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      0,
      NULL,
      8.314434,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.160917,
      5.831579,
      2,
      1.589934,
      1.865222,
      0.403844,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.555828,
      NULL,
      2,
      1.944772,
      NULL,
      0.717991,
      0.412573,
      1,
      1,
      0,
      0,
      1,
      1,
      1,
      0,
      1,
      NULL,
      0,
      0.673405,
      1,
      0.686289,
      0.754423,
      0.572556,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.951799,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.973386,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.983386,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.466351,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.734079,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      209.590661,
      NULL,
      2.148153,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      22.970934,
      NULL,
      NULL,
      1.754969,
      0.974883,
      NULL,
      5.560529,
      NULL,
      3.085363,
      14.364942,
      NULL,
      5,
      5.269430,
      1.702573,
      NULL,
      1,
      0,
      NULL,
      1.115178,
      1.136185,
      NULL,
      1.400784,
      NULL,
      NULL,
      1.782791,
      0,
      NULL,
      0,
      1.073307,
      NULL,
      3,
      3,
      NULL,
      1,
      3.498298,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.871420,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.365285,
      NULL,
      NULL,
      1.874272,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.063272,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.147610,
      NULL,
      1,
      NULL,
      0,
      2.806198,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.699629,
      NULL,
      NULL,
      '42124',
      '43103',
      2.523613,
      '11013',
      NULL,
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


