set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9437107';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-1-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      '3013332',
      0.412676,
      1.481449,
      2,
      3,
      '3321',
      2.117423,
      NULL,
      NULL,
      NULL,
      ' 3-24-1984',
      51,
      NULL,
      0,
      0.946001,
      NULL,
      ' 2-20-2003',
      10,
      2.227777,
      62.489689,
      8,
      3.213112,
      ' 2-18-1992',
      ' 8-18-1990',
      '10-27-1976',
      0,
      2,
      1,
      1,
      NULL,
      0,
      7,
      1.832361,
      NULL,
      NULL,
      NULL,
      3.167492,
      0,
      15,
      19,
      2.993200,
      22.864306,
      7.319008,
      0.752249,
      4.812206,
      NULL,
      0.644839,
      1,
      NULL,
      1.642630,
      3.899304,
      1,
      1.535522,
      0,
      0.953194,
      0,
      2,
      3,
      8.091388,
      NULL,
      1.577710,
      0,
      9,
      1.246137,
      NULL,
      5.403497,
      9.387599,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.303217,
      3.233624,
      1,
      2,
      1,
      NULL,
      NULL,
      3.532147,
      NULL,
      NULL,
      NULL,
      1,
      1.409562,
      0.481922,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.181991,
      3,
      1.236900,
      2.075624,
      0.350940,
      NULL,
      0.256367,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.354992,
      NULL,
      0.955319,
      0,
      4.606644,
      0.573886,
      1,
      0,
      NULL,
      0,
      3.099381,
      NULL,
      0,
      NULL,
      4.623612,
      5.857189,
      0,
      NULL,
      NULL,
      5.942804,
      NULL,
      3.032754,
      3,
      0,
      5.475268,
      3,
      0,
      0,
      6.727960,
      0,
      4.250349,
      9,
      5.047182,
      0.601013,
      4.076965,
      NULL,
      NULL,
      NULL,
      NULL,
      8.654750,
      0.577607,
      NULL,
      5,
      NULL,
      8,
      3.388989,
      3,
      3,
      0.185722,
      ' 7- 6-1984',
      13,
      ' 7-16-1993',
      4.683977,
      3.303519,
      1.340574,
      NULL,
      1.726949,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      1.717432,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      11.581522,
      1,
      2,
      0.694540,
      1.486993,
      NULL,
      NULL,
      0.022484,
      11.361081,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      8.187623,
      1,
      4.292297,
      0.578596,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.440001,
      9,
      2,
      9,
      NULL,
      11.893827,
      ' 6-22-1986',
      5.363521,
      1.871657,
      3,
      0.517158,
      NULL,
      1.927824,
      NULL,
      0,
      0,
      1,
      0.114520,
      3.884596,
      43,
      1.382917,
      0.815939,
      NULL,
      NULL,
      NULL,
      0,
      1.453471,
      0,
      3.661676,
      NULL,
      0.953729,
      1.215715,
      2.680657,
      2.304558,
      1.919303,
      NULL,
      1.316196,
      3.200912,
      0,
      3,
      2,
      0,
      NULL,
      0,
      0,
      NULL,
      1.777671,
      0,
      1,
      0.002198,
      1,
      0,
      0,
      0.392420,
      2.588165,
      NULL,
      1,
      7.560279,
      NULL,
      0.726385,
      11,
      10.341133,
      4,
      3,
      2,
      0,
      3.594339,
      0.069334,
      2,
      20,
      4.411837,
      2.063424,
      NULL,
      23,
      16,
      10.642577,
      0,
      2.656878,
      3.488992,
      '22303',
      NULL,
      NULL,
      0.395966,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      10,
      140,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.285457,
      NULL,
      1,
      1.422129,
      NULL,
      NULL,
      1.175862,
      0,
      1.368331,
      0.929492,
      NULL,
      NULL,
      NULL,
      1.072203,
      1.988651,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.973514,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7,
      3.438380,
      2,
      NULL,
      1.541970,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.506879,
      NULL,
      NULL,
      1.119419,
      NULL,
      NULL,
      1.230651,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.480582,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.415685,
      NULL,
      0.965697,
      0.729170,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.275917,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.249911,
      NULL,
      NULL,
      0.180442,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.551105,
      NULL,
      0,
      3,
      0,
      0,
      NULL,
      5,
      2,
      5.363434,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      2.511167,
      1,
      1,
      3.865100,
      0,
      5,
      0,
      3,
      0.932747,
      2,
      3,
      2,
      2,
      NULL,
      1.110754,
      2.714643,
      NULL,
      1.071157,
      1.076633,
      3,
      7.968217,
      5.994640,
      0,
      1,
      NULL,
      NULL,
      3,
      1,
      5,
      0.486023,
      1.339608,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.295752,
      1.775288,
      1,
      0.054968,
      0,
      1.820468,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.971770,
      NULL,
      NULL,
      NULL,
      0.697720,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.653529,
      NULL,
      NULL,
      NULL,
      1.324777,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.507017,
      NULL,
      NULL,
      NULL,
      0.432300,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      7.673045,
      NULL,
      NULL,
      NULL,
      2.879844,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.299959,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.574346,
      NULL,
      1.232509,
      1.472795,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.010738,
      0.993682,
      1,
      1,
      0.345882,
      0,
      0.659180,
      1.020209,
      0.689803,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      1.899322,
      0,
      0.500496,
      1.237453,
      NULL,
      0.281622,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.759130,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.280829,
      1,
      2.509548,
      1.482980,
      0,
      1,
      3,
      10,
      1,
      3.333009,
      0,
      1,
      0,
      NULL,
      0.730865,
      NULL,
      NULL,
      1,
      1.138993,
      NULL,
      0,
      0,
      NULL,
      0.457530,
      1.834339,
      NULL,
      NULL,
      0.008183,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.807243,
      NULL,
      1,
      NULL,
      NULL,
      0.201049,
      1.220504,
      NULL,
      0,
      1,
      NULL,
      2.523958,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.359976,
      NULL,
      1,
      NULL,
      0.581063,
      2.019830,
      0,
      0.236375,
      NULL,
      NULL,
      10,
      NULL,
      1.590559,
      NULL,
      3.649968,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '',
      NULL,
      NULL,
      '',
      NULL,
      NULL);
commit;
end;
/


