set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8621104';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-3-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      5,
      1,
      1.989400,
      0.164513,
      3,
      3.614629,
      5,
      0,
      '340',
      '20130420',
      70,
      NULL,
      '1434340',
      NULL,
      1,
      1,
      3,
      '1124',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      34.012618,
      NULL,
      3.811380,
      0.021548,
      ' 5-29-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 0-1977',
      '10-25-1984',
      NULL,
      0.011818,
      0.547596,
      3.745471,
      1.767427,
      1,
      NULL,
      0.464800,
      1,
      NULL,
      NULL,
      NULL,
      0,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      6.863484,
      NULL,
      NULL,
      NULL,
      2.505692,
      NULL,
      1,
      NULL,
      0.588876,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      3,
      1.972268,
      0.787684,
      0.655299,
      1.736088,
      NULL,
      NULL,
      NULL,
      9,
      0,
      6.286308,
      5,
      7,
      5.475618,
      6,
      NULL,
      3,
      0,
      2.092829,
      1,
      NULL,
      NULL,
      1.480235,
      1.895964,
      NULL,
      NULL,
      6,
      2,
      1,
      0,
      NULL,
      2,
      NULL,
      0.260532,
      0,
      3.771661,
      1.836282,
      NULL,
      2.068351,
      NULL,
      1,
      NULL,
      0.602594,
      0,
      0.511550,
      NULL,
      1.953746,
      NULL,
      2,
      0.129612,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0,
      4,
      0,
      1,
      0,
      0,
      NULL,
      1.492522,
      0.600395,
      NULL,
      1.294681,
      1.076764,
      NULL,
      NULL,
      0,
      0,
      0.365794,
      1.323598,
      NULL,
      NULL,
      0,
      0,
      0.739440,
      1.084806,
      5,
      0,
      9.670846,
      5,
      NULL,
      NULL,
      1,
      1,
      NULL,
      4,
      1.013964,
      NULL,
      1,
      3.933204,
      5,
      7.340943,
      0,
      NULL,
      1,
      4.544198,
      0,
      6.707005,
      5.129065,
      0,
      '10-21-1988',
      NULL,
      ' 4- 6-1991',
      8,
      2.747159,
      NULL,
      1.412585,
      NULL,
      1.586369,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.837126,
      0,
      1,
      1,
      1.460665,
      1,
      0,
      1.717704,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.304523,
      NULL,
      1.426572,
      1.665158,
      2,
      3.303127,
      1,
      0.351985,
      3,
      2,
      1.819378,
      4,
      0.254369,
      1,
      1.433459,
      0.929247,
      0.766188,
      NULL,
      0,
      5,
      1.143594,
      7.943812,
      6,
      8.231062,
      NULL,
      1,
      1,
      3,
      17,
      3,
      3,
      9.136007,
      2.704445,
      NULL,
      ' 3- 8-1976',
      4,
      ' 5- 5-1979',
      5.288281,
      NULL,
      1.749529,
      NULL,
      1.922424,
      2.225951,
      0.458107,
      2.632242,
      0,
      NULL,
      0,
      2.285205,
      13,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.857777,
      3,
      0.860981,
      3,
      3.637165,
      1.736928,
      NULL,
      1.152735,
      2,
      2,
      NULL,
      1,
      0.693039,
      2,
      0,
      0.651695,
      1.829411,
      1,
      1.647913,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      0.226889,
      1.228775,
      1,
      0.130137,
      NULL,
      10.220973,
      6,
      2.405451,
      8,
      NULL,
      1,
      1.038460,
      2,
      2,
      1,
      0.466720,
      NULL,
      1,
      2.107093,
      35.100779,
      NULL,
      8.253825,
      53.929073,
      2,
      NULL,
      6,
      '01243',
      '00224',
      '40413',
      0,
      '',
      '',
      '',
      1.105441,
      NULL,
      '',
      '',
      2,
      14,
      152,
      15.628808,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.242225,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.872037,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.987324,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.815628,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.698039,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.400102,
      NULL,
      NULL,
      1.265931,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.018620,
      NULL,
      NULL,
      0.233168,
      NULL,
      NULL,
      0.584651,
      0,
      0.678572,
      0.489540,
      NULL,
      NULL,
      NULL,
      5.837063,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.656765,
      NULL,
      NULL,
      0.883513,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.245452,
      0.370278,
      1,
      0.374008,
      NULL,
      NULL,
      NULL,
      0.414434,
      1,
      2.742157,
      3.366145,
      NULL,
      1.330495,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      3.376451,
      3.373786,
      0.498846,
      1,
      1,
      7.385972,
      3,
      2.660715,
      1,
      0,
      1.856319,
      NULL,
      NULL,
      2,
      NULL,
      2.960103,
      1,
      NULL,
      NULL,
      4,
      1,
      5,
      5,
      3.141577,
      2,
      0.144356,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      0,
      1.826567,
      4.178057,
      NULL,
      NULL,
      NULL,
      23,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.548810,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.523556,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.388042,
      NULL,
      NULL,
      NULL,
      2.326707,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.813291,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.710455,
      1.918523,
      0.964660,
      2.150396,
      23,
      NULL,
      0.129007,
      NULL,
      NULL,
      0.799733,
      0.966268,
      1.670830,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      84.406875,
      3,
      NULL,
      1,
      NULL,
      1,
      1.322390,
      0.708564,
      1.661054,
      1.656422,
      1.971724,
      0,
      NULL,
      1.030279,
      1.026495,
      0,
      0,
      1.625454,
      NULL,
      1.739812,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      3.313929,
      NULL,
      NULL,
      NULL,
      110.097456,
      NULL,
      1,
      NULL,
      9,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.698527,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.259711,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.220762,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.182117,
      NULL,
      3.538020,
      1.886060,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.080077,
      NULL,
      NULL,
      NULL,
      1.599650,
      NULL,
      1.331045,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.827192,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.072703,
      NULL,
      1.846367,
      NULL,
      1.296299,
      NULL,
      1.455731,
      NULL,
      1.603283,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.026816,
      NULL,
      1.223795,
      NULL,
      1.433359,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.650790,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      3.249853,
      NULL,
      3.796132,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0.323276,
      NULL,
      30,
      NULL,
      0.862439,
      2,
      1.650912,
      NULL,
      1.901989,
      2,
      NULL,
      0.912971,
      2.063020,
      0.948976,
      2.410240,
      2.154195,
      NULL,
      2,
      NULL,
      1,
      1,
      1.371295,
      NULL,
      1,
      1.205028,
      NULL,
      NULL,
      0.346980,
      NULL,
      0.932708,
      NULL,
      NULL,
      0,
      0.512185,
      NULL,
      3,
      1,
      NULL,
      0.578835,
      3,
      NULL,
      1.519602,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.548071,
      NULL,
      1,
      NULL,
      NULL,
      1.708966,
      1,
      1.400377,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      3,
      2,
      0.200320,
      3.955263,
      1.677274,
      2,
      16,
      NULL,
      4,
      NULL,
      NULL,
      '34200',
      '41440',
      '33120',
      0,
      '',
      NULL,
      '',
      1,
      NULL,
      '',
      '');
commit;
end;
/


