set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000083';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-2-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '4',
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      0,
      NULL,
      2.667292,
      3,
      NULL,
      0,
      NULL,
      38.244390,
      NULL,
      2,
      NULL,
      1.301177,
      ' 7- 1-1975',
      137,
      0.968632,
      71.094575,
      104.047239,
      5.957679,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      3,
      1,
      1,
      NULL,
      6,
      16,
      6,
      12,
      3,
      5.294679,
      9.907422,
      NULL,
      3,
      6.550771,
      NULL,
      1,
      3.151990,
      1.755782,
      1,
      0,
      1.174967,
      NULL,
      0.294937,
      0.659320,
      0,
      2.140837,
      3,
      1,
      0.670414,
      4,
      0.399081,
      NULL,
      1,
      1.083501,
      1.098623,
      0.843419,
      1.171531,
      0.717021,
      0,
      1.965491,
      NULL,
      3,
      1.035325,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.910331,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.210593,
      11,
      0.902244,
      3,
      5.812194,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.220656,
      5.349630,
      9,
      1.582754,
      NULL,
      0.257443,
      10.862704,
      0,
      0,
      1.448887,
      0.562051,
      0.442721,
      0,
      9,
      4,
      1,
      3.639901,
      1.347031,
      0.117011,
      NULL,
      NULL,
      1,
      2,
      0,
      0.086406,
      4,
      0.136345,
      0,
      0.070947,
      5,
      3,
      2.957908,
      0,
      2.591762,
      NULL,
      0.584310,
      NULL,
      0,
      9,
      0.488351,
      NULL,
      0.776032,
      NULL,
      3.119834,
      1.246548,
      18.868275,
      10.876662,
      2.919782,
      ' 1-16-1998',
      1114,
      ' 0-19-1997',
      338.689331,
      NULL,
      4,
      NULL,
      1.453464,
      0.444160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.097895,
      1,
      0.072038,
      0,
      NULL,
      0.134742,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.233445,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      5.470645,
      1.607821,
      1,
      0.218489,
      0.170139,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.708518,
      0.313773,
      1,
      1,
      0,
      1,
      1.366052,
      NULL,
      1.819767,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3.629828,
      NULL,
      4,
      1,
      0.497295,
      6,
      0,
      0,
      NULL,
      2,
      4.604381,
      3,
      4.425595,
      NULL,
      3,
      0.967171,
      2.043271,
      1.724951,
      1,
      0.878009,
      0.606719,
      0,
      0,
      1.627278,
      0,
      0.014215,
      0,
      4,
      1.670422,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.210729,
      9.505804,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      '40340',
      '',
      '',
      1.024679,
      '',
      '',
      '',
      1.328686,
      '',
      NULL,
      '',
      NULL,
      NULL,
      214,
      122.873708,
      3,
      89,
      2.289563,
      1,
      1.108859,
      3.883354,
      3,
      0.138079,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.684771,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.587609,
      NULL,
      NULL,
      0.290019,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.798948,
      NULL,
      NULL,
      1.186376,
      NULL,
      NULL,
      0.831851,
      NULL,
      NULL,
      5.413242,
      2,
      7.828922,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.155906,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.232751,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.407581,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.081578,
      NULL,
      NULL,
      1.394064,
      NULL,
      NULL,
      2.321144,
      NULL,
      0.060949,
      9.005062,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.343349,
      1,
      NULL,
      2,
      0.047203,
      NULL,
      NULL,
      4.155250,
      9.436720,
      9,
      1,
      NULL,
      NULL,
      1.315641,
      NULL,
      NULL,
      1.651885,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      NULL,
      NULL,
      0,
      3.579426,
      2,
      1,
      NULL,
      NULL,
      1.103291,
      NULL,
      NULL,
      NULL,
      0.967888,
      5,
      1,
      NULL,
      NULL,
      1,
      3,
      0.907170,
      NULL,
      11,
      5.424123,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      0.418071,
      NULL,
      NULL,
      0.650408,
      2,
      NULL,
      0,
      2.267105,
      3,
      7.497722,
      0.491035,
      NULL,
      2,
      0.032484,
      3.799183,
      18,
      NULL,
      NULL,
      1.893533,
      NULL,
      NULL,
      3,
      NULL,
      0.989158,
      1,
      2,
      0.393525,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      1.122425,
      0,
      0.398315,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.699646,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.266191,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.001352,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.948452,
      0,
      0.279412,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.779196,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.959497,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.172696,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      1.219678,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.863472,
      NULL,
      NULL,
      1.667822,
      NULL,
      NULL,
      0.807869,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      771.717857,
      NULL,
      0.541136,
      1,
      0.429394,
      1,
      0,
      0.402691,
      1.336442,
      0,
      1,
      0,
      0,
      1,
      0,
      0.300318,
      1.805761,
      0.991624,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.454284,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.430360,
      2,
      0.522605,
      1.066288,
      1,
      3.788290,
      1.253861,
      3.977254,
      1.946397,
      0.863984,
      0.117006,
      0.225772,
      NULL,
      NULL,
      0,
      NULL,
      0.668969,
      NULL,
      NULL,
      1.072683,
      1.023617,
      NULL,
      0.766757,
      0.591008,
      NULL,
      1,
      1,
      NULL,
      1.083078,
      1.014577,
      NULL,
      1.889179,
      1.265028,
      NULL,
      0.672838,
      2.204648,
      NULL,
      1.908869,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      1.725818,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      2,
      0,
      NULL,
      NULL,
      2.792105,
      NULL,
      4,
      1.030570,
      3.109034,
      NULL,
      '',
      NULL,
      0,
      NULL,
      '',
      NULL,
      1.869805,
      NULL,
      '',
      '');
commit;
end;
/


