set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9805950';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-11-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2,
      0,
      2,
      2.441536,
      0.077337,
      0,
      1.037943,
      0,
      '403',
      NULL,
      34,
      26.261573,
      NULL,
      0,
      1,
      3,
      3,
      '1014',
      3.308037,
      0,
      NULL,
      NULL,
      NULL,
      88.068490,
      NULL,
      NULL,
      1.545064,
      2,
      ' 3- 3-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      1.707061,
      NULL,
      ' 3- 7-1980',
      NULL,
      0.221604,
      2.866930,
      3.982983,
      NULL,
      1,
      2,
      NULL,
      1,
      1,
      32,
      7.166814,
      2.838406,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.369741,
      NULL,
      2.018243,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.628161,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      3,
      5.398279,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.564610,
      5,
      1.795642,
      2,
      3,
      2,
      3,
      1,
      1.732318,
      NULL,
      NULL,
      NULL,
      2,
      0.333469,
      NULL,
      NULL,
      0,
      NULL,
      2.476483,
      1.265596,
      1,
      NULL,
      NULL,
      1,
      3.938050,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.547076,
      9.772240,
      1.227133,
      1.793339,
      NULL,
      NULL,
      3.017573,
      NULL,
      0,
      5.938877,
      1.494892,
      0.459632,
      1.118166,
      1.071692,
      0.462019,
      NULL,
      1.141002,
      0.881369,
      1,
      2,
      0,
      1.072657,
      0.356336,
      1,
      NULL,
      0.623560,
      1,
      NULL,
      0,
      0,
      0,
      1,
      3.337832,
      2.174461,
      0.149849,
      NULL,
      NULL,
      0.165808,
      4.476726,
      NULL,
      0,
      0,
      1.344927,
      3,
      NULL,
      NULL,
      NULL,
      1974,
      3.183226,
      0.019317,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      NULL,
      0,
      3.200086,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      5.581369,
      0.571159,
      3.828926,
      1.042670,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.954783,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.711940,
      4,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.546103,
      0.963666,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3.376597,
      0.765484,
      1.881476,
      NULL,
      2.042801,
      49.797910,
      0,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0.165084,
      0,
      NULL,
      3.625760,
      1,
      2,
      3,
      0,
      1,
      3.732276,
      NULL,
      1,
      NULL,
      3,
      1,
      3.086191,
      1.086303,
      1.257121,
      NULL,
      1.121807,
      1.392152,
      0.455510,
      0.405836,
      NULL,
      0.883884,
      1,
      0,
      1,
      0.307570,
      3.527607,
      0,
      3.535312,
      10,
      6,
      0,
      9,
      NULL,
      5.328255,
      NULL,
      2.242465,
      0,
      2,
      0.484576,
      NULL,
      3,
      0,
      29,
      NULL,
      NULL,
      NULL,
      4.619016,
      1,
      2.371568,
      '41410',
      '40332',
      '24344',
      1.370206,
      NULL,
      '',
      NULL,
      3,
      '0031',
      '',
      '',
      2,
      6,
      547,
      38,
      2.783198,
      41.207388,
      NULL,
      NULL,
      3,
      0,
      2,
      0.231382,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.873488,
      1.321543,
      0,
      1,
      NULL,
      NULL,
      2,
      1.151334,
      3.823021,
      1.691681,
      NULL,
      1,
      1,
      NULL,
      1.095694,
      2.022069,
      0.474855,
      3,
      NULL,
      1.465668,
      3.459536,
      NULL,
      1.908375,
      0.492915,
      5.399058,
      4,
      4,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.364905,
      3.230264,
      3.141782,
      2.676984,
      1.454183,
      2.370781,
      3.158640,
      1,
      2.567221,
      1.570052,
      NULL,
      0.562318,
      3.081851,
      NULL,
      1,
      3.359023,
      0,
      NULL,
      2.744676,
      1,
      2.905496,
      1.066408,
      0,
      2.246059,
      1,
      3.901948,
      2,
      0.547520,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.949508,
      0.982983,
      1,
      2,
      1,
      NULL,
      NULL,
      0.726327,
      NULL,
      NULL,
      NULL,
      3.743181,
      NULL,
      1.387089,
      1.721505,
      3.428670,
      0,
      0,
      1,
      NULL,
      NULL,
      2,
      1,
      1,
      3.484431,
      3,
      2.477731,
      NULL,
      3,
      NULL,
      1,
      1.670675,
      2.791339,
      2,
      1.142876,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.975833,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.397757,
      NULL,
      NULL,
      0.741216,
      NULL,
      NULL,
      0.396683,
      NULL,
      NULL,
      2.210201,
      NULL,
      NULL,
      1.190794,
      0.380602,
      2.800735,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      2.165558,
      0.627538,
      1.292400,
      NULL,
      NULL,
      2,
      0,
      0.412035,
      2,
      NULL,
      0,
      3,
      NULL,
      2,
      1,
      3.671119,
      0,
      1,
      NULL,
      NULL,
      3,
      1.554578,
      5,
      7.464598,
      3,
      NULL,
      NULL,
      1.239508,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1,
      0,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.123977,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2.334010,
      NULL,
      NULL,
      1.982972,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      13,
      NULL,
      NULL,
      1.694651,
      0.748868,
      2,
      0.846846,
      2,
      0,
      0.195328,
      NULL,
      3.405285,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.945879,
      NULL,
      NULL,
      NULL,
      2,
      0.269950,
      NULL,
      NULL,
      1.952771,
      NULL,
      NULL,
      NULL,
      3.770396,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.515915,
      NULL,
      NULL,
      NULL,
      1.716600,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.597682,
      0,
      NULL,
      NULL,
      2.423686,
      1.506844,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      2,
      0.157771,
      NULL,
      NULL,
      3.487171,
      1.168514,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      11.826974,
      0,
      NULL,
      NULL,
      2.388140,
      NULL,
      NULL,
      4.151156,
      NULL,
      3,
      NULL,
      NULL,
      2,
      9,
      NULL,
      1,
      NULL,
      NULL,
      1,
      5.007702,
      2,
      0.706761,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.441086,
      1869.709698,
      34.967168,
      3,
      0.182813,
      NULL,
      NULL,
      NULL,
      3.378460,
      2,
      2.023829,
      NULL,
      0,
      0,
      1.728773,
      1,
      0,
      0.098194,
      3,
      0.973832,
      2.070649,
      1.886376,
      1,
      0.383129,
      1,
      1.259675,
      0.194884,
      0,
      1,
      NULL,
      0.991368,
      52.215800,
      72.963138,
      NULL,
      NULL,
      55,
      NULL,
      0.930523,
      3,
      0,
      0.474368,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.108590,
      0.240854,
      1,
      NULL,
      1.743003,
      1.127775,
      NULL,
      1.415704,
      0,
      1,
      1,
      0.519769,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.795714,
      1,
      1.798622,
      3,
      1,
      0.794034,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.321188,
      0.493285,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.728067,
      1.620782,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.013323,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.459581,
      NULL,
      1,
      0.213169,
      0.402802,
      2,
      NULL,
      253,
      0,
      1.124685,
      1,
      1,
      1,
      1,
      NULL,
      2.636995,
      8.209029,
      57,
      1.505439,
      NULL,
      NULL,
      NULL,
      1.036851,
      NULL,
      2.687150,
      5,
      1.264561,
      6.561016,
      3,
      1.947661,
      NULL,
      0,
      3,
      1,
      1.341667,
      2.950342,
      NULL,
      0.665012,
      0.807759,
      NULL,
      0,
      0.363215,
      NULL,
      1.997442,
      NULL,
      NULL,
      0.311431,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.222295,
      NULL,
      NULL,
      NULL,
      1.537253,
      NULL,
      0.258121,
      NULL,
      NULL,
      1.361926,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.493149,
      NULL,
      NULL,
      NULL,
      0.168048,
      NULL,
      1,
      7.050108,
      8.050893,
      0,
      NULL,
      NULL,
      NULL,
      31.915478,
      2.195102,
      NULL,
      5,
      '30432',
      '02212',
      '44343',
      0.563796,
      '',
      '',
      NULL,
      NULL,
      '0131',
      '',
      '');
commit;
end;
/


