set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9805950';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-6-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0.978697,
      1,
      2.891633,
      NULL,
      3,
      NULL,
      3.815951,
      0.336626,
      '300',
      '24002411',
      33.313898,
      47.973191,
      '1003004',
      1.951089,
      1.813047,
      2,
      1,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      42,
      274.147781,
      NULL,
      3,
      0,
      ' 5-18-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 9-1991',
      1,
      0,
      0.337297,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      6,
      19.229303,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      2.478861,
      3,
      NULL,
      2.185510,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      5,
      1,
      0.229070,
      4.088050,
      0,
      0,
      7,
      NULL,
      6.960803,
      2,
      4.263068,
      2.013103,
      4.166765,
      0.731875,
      3,
      0,
      2.190110,
      0,
      NULL,
      NULL,
      0.947550,
      NULL,
      NULL,
      10,
      2,
      5.924218,
      1.286210,
      2.476589,
      1,
      1.758758,
      1,
      3.166857,
      1,
      1,
      3,
      0,
      1,
      3,
      NULL,
      0,
      2.506306,
      3.832190,
      1,
      1.941368,
      NULL,
      1,
      1.502055,
      2,
      1.775506,
      0.607432,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      1.282177,
      2,
      1,
      5,
      NULL,
      NULL,
      1.975677,
      3,
      1.274442,
      2,
      0.381036,
      5.103852,
      0.345721,
      1.632417,
      NULL,
      0.652041,
      1.581744,
      NULL,
      0,
      0.823861,
      NULL,
      2,
      0,
      NULL,
      4.704905,
      1,
      NULL,
      0.301285,
      1,
      1,
      0,
      1,
      1.016475,
      1.064460,
      7,
      NULL,
      4,
      NULL,
      6,
      6,
      NULL,
      0.382335,
      0,
      0,
      0.658995,
      0.518316,
      ' 8- 8-2001',
      1345,
      ' 1-29-1989',
      387.080393,
      3.589398,
      1,
      2.954603,
      0.255917,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.569618,
      0.626203,
      1.733421,
      1.650764,
      0.464868,
      1.566451,
      0,
      0.577659,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2.982244,
      1.884491,
      1.830049,
      NULL,
      5,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.248472,
      0.224278,
      5,
      6.798455,
      2.229871,
      3,
      1.886504,
      NULL,
      NULL,
      NULL,
      1.978569,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.987369,
      0.428497,
      0.105909,
      0.011174,
      0,
      1,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0.607567,
      2.205773,
      NULL,
      1.048209,
      3.432193,
      1.151072,
      NULL,
      1.180399,
      0,
      1.017544,
      2,
      2.140158,
      1.389608,
      0.595830,
      0,
      2,
      1.281638,
      1,
      3.992930,
      1.236131,
      NULL,
      1.291705,
      1,
      1,
      NULL,
      1.528886,
      1,
      1.890585,
      1.702966,
      3.336649,
      0.345109,
      NULL,
      11,
      NULL,
      1,
      8,
      0.843791,
      NULL,
      0,
      0,
      3.039610,
      2,
      0,
      55,
      1,
      NULL,
      30.465752,
      NULL,
      NULL,
      NULL,
      NULL,
      4.463107,
      3.744497,
      '00023',
      NULL,
      '',
      0,
      '',
      '',
      '',
      1.912257,
      NULL,
      NULL,
      NULL,
      0,
      52,
      204.882093,
      25,
      1.971083,
      9,
      5,
      8.553998,
      0,
      2.425539,
      1.192921,
      3,
      0.845852,
      NULL,
      NULL,
      1.194194,
      NULL,
      NULL,
      2,
      1.938802,
      1.577812,
      NULL,
      NULL,
      1.233157,
      1,
      NULL,
      NULL,
      2,
      NULL,
      0,
      3.821888,
      0.085999,
      3,
      2.507653,
      1.977832,
      NULL,
      1,
      0.204847,
      0.508644,
      0,
      0.175389,
      0.616225,
      1,
      0.099987,
      0.558252,
      4.660706,
      1.604776,
      6.550040,
      0.752210,
      0,
      NULL,
      NULL,
      NULL,
      3.566264,
      NULL,
      1,
      3,
      2.617041,
      0.605567,
      3.355867,
      3,
      1.538870,
      2,
      2.276015,
      1,
      3,
      0.231580,
      NULL,
      1.554974,
      NULL,
      1.435159,
      0.964868,
      3,
      0,
      3.460705,
      0.305958,
      0,
      2,
      2.815616,
      1.706312,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1.230347,
      NULL,
      NULL,
      1.323449,
      NULL,
      1,
      11,
      0,
      8,
      1,
      1.425017,
      NULL,
      NULL,
      NULL,
      2,
      0.592648,
      0.816885,
      3.961667,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      0,
      2.261749,
      2.733673,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.667419,
      2,
      1,
      4.942738,
      NULL,
      1.282274,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.134485,
      NULL,
      NULL,
      0.103711,
      NULL,
      NULL,
      1.066414,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1.335749,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      2.643368,
      3.362914,
      NULL,
      1,
      NULL,
      5.250689,
      1,
      3,
      2,
      1,
      0.276256,
      2.066096,
      1.614989,
      2.120346,
      1,
      2,
      3,
      3,
      2,
      0.745808,
      1.395859,
      5,
      3.928514,
      0.502860,
      NULL,
      NULL,
      3.981489,
      NULL,
      7.580327,
      1.926839,
      0,
      NULL,
      1.319162,
      0.697275,
      1.534637,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.888178,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.583702,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      10.839422,
      NULL,
      NULL,
      3.954718,
      1.707290,
      0,
      1.491080,
      3.442820,
      1,
      1.554135,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      0.693939,
      NULL,
      NULL,
      NULL,
      1.954904,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.015075,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.646826,
      2.001980,
      NULL,
      NULL,
      0.758979,
      2,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.498165,
      NULL,
      NULL,
      1,
      4.160687,
      NULL,
      NULL,
      1,
      2,
      1,
      3.594388,
      2,
      3,
      18.174807,
      142.875998,
      1.555387,
      5,
      2.635740,
      1,
      NULL,
      NULL,
      0,
      25.154320,
      7,
      0.845119,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.116784,
      NULL,
      78,
      NULL,
      0,
      0,
      NULL,
      0,
      2.442109,
      0,
      2,
      0.035417,
      0,
      0,
      0,
      0,
      0,
      1,
      3,
      0,
      3,
      NULL,
      0,
      NULL,
      3.899566,
      NULL,
      0.716671,
      NULL,
      0.706538,
      NULL,
      3.348872,
      NULL,
      75.988808,
      NULL,
      5,
      58,
      NULL,
      0,
      3,
      2.824120,
      NULL,
      1,
      NULL,
      1.127533,
      NULL,
      1.401405,
      NULL,
      1.390241,
      NULL,
      1.261792,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.700971,
      NULL,
      1.307725,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.894655,
      NULL,
      0,
      1,
      0.912989,
      1.763557,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.428715,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.175641,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.574976,
      0.108985,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.067580,
      NULL,
      2,
      NULL,
      2.920023,
      NULL,
      NULL,
      NULL,
      2.072508,
      NULL,
      1.098413,
      NULL,
      1.530193,
      NULL,
      3,
      51,
      6.837324,
      1.864942,
      NULL,
      NULL,
      NULL,
      NULL,
      2.726070,
      3.671498,
      6.177646,
      NULL,
      7.047679,
      1,
      0.077759,
      13,
      2.198382,
      NULL,
      0.224006,
      0.302216,
      2.293311,
      1.906126,
      NULL,
      2,
      0,
      1.022447,
      0,
      NULL,
      1.154461,
      2.646368,
      NULL,
      0,
      1,
      0,
      0,
      0.529444,
      1.724281,
      1,
      0,
      3.100956,
      0.833757,
      0.133706,
      NULL,
      1.953679,
      NULL,
      1.584819,
      0.932705,
      0.237337,
      2,
      1,
      0.532536,
      0.133246,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.363000,
      0.990931,
      0,
      NULL,
      4,
      1.561168,
      8,
      0,
      NULL,
      NULL,
      57,
      14.499592,
      NULL,
      1.343588,
      2,
      '42121',
      '02132',
      NULL,
      0,
      '',
      '',
      '',
      3,
      '1001',
      '',
      '');
commit;
end;
/


