set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000193';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-5-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '3',
      NULL,
      NULL,
      '0223443',
      3.943965,
      0,
      3,
      2,
      NULL,
      1,
      1,
      NULL,
      NULL,
      '11- 0-1980',
      114.256853,
      NULL,
      0,
      2,
      1.759230,
      ' 1-15-2002',
      23,
      3,
      23.556556,
      150.247607,
      NULL,
      NULL,
      NULL,
      '11- 3-1990',
      1,
      0,
      0.559216,
      3,
      1.608990,
      3,
      14.739097,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      16.423980,
      4,
      23,
      3.200581,
      3.918485,
      1.176307,
      0.774750,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.389426,
      1.775026,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      0.225886,
      1,
      NULL,
      1.706768,
      0.712829,
      0.538133,
      1.313077,
      1,
      1,
      0,
      0.497813,
      0.675676,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.456921,
      0,
      3,
      3.040308,
      0.013095,
      0.520009,
      3,
      1,
      NULL,
      1.172571,
      0,
      0.003686,
      0.516964,
      1,
      1.915070,
      0.151605,
      3,
      2.292196,
      0,
      1,
      5.933835,
      3,
      NULL,
      1.446310,
      0.089655,
      2.257774,
      0.402719,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.772508,
      NULL,
      1.483203,
      NULL,
      1.587092,
      1.191983,
      NULL,
      0.344563,
      3.069929,
      1.353100,
      NULL,
      1,
      1,
      1,
      0.569198,
      NULL,
      0.283899,
      1.208790,
      NULL,
      NULL,
      4.227240,
      3.691843,
      NULL,
      0.662325,
      1.171956,
      NULL,
      NULL,
      5.660548,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      2,
      2.276211,
      3.120537,
      3,
      1.462783,
      6.015221,
      1.927879,
      2.899976,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1.985382,
      0.466270,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.868674,
      NULL,
      NULL,
      NULL,
      NULL,
      0.516558,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.675258,
      0,
      1,
      0.424585,
      1.810514,
      1,
      NULL,
      NULL,
      NULL,
      1.646832,
      0.280088,
      1.253673,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.951043,
      1.215360,
      1.920546,
      1,
      1,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.947088,
      3.069416,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      2,
      2.330068,
      3.159627,
      1.268090,
      3,
      NULL,
      0.455486,
      1,
      0,
      2.262519,
      0,
      0.105936,
      0.083259,
      1.791197,
      NULL,
      5.587913,
      0.914145,
      NULL,
      0,
      1.885005,
      3.808877,
      1.519041,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.913894,
      121,
      NULL,
      NULL,
      NULL,
      3.393798,
      1.863098,
      2.727760,
      '12400',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      5.844800,
      '4024',
      '2434',
      NULL,
      0.329089,
      NULL,
      4.541895,
      21.462609,
      3,
      69,
      1,
      4,
      2.365157,
      3,
      2,
      NULL,
      1.421198,
      NULL,
      NULL,
      0.523107,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.567588,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2.811993,
      0.260144,
      0.478115,
      1.190684,
      1,
      0.115700,
      1,
      3,
      0,
      0.275032,
      NULL,
      NULL,
      3,
      NULL,
      4.605351,
      1.767278,
      NULL,
      NULL,
      5,
      5.047021,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.120803,
      3.966800,
      0,
      3,
      1,
      0,
      NULL,
      NULL,
      3.972295,
      3,
      NULL,
      NULL,
      1,
      NULL,
      1,
      2.154364,
      0,
      2,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0,
      2.185225,
      0.883343,
      1,
      2.248191,
      1.451309,
      NULL,
      3,
      2,
      0,
      0,
      1.394091,
      NULL,
      0,
      0.168667,
      2.265779,
      0,
      0.728452,
      NULL,
      NULL,
      NULL,
      2.651329,
      2,
      1.938133,
      1.127238,
      1,
      NULL,
      NULL,
      1.645188,
      NULL,
      1,
      1.462648,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.521363,
      0,
      1.176007,
      NULL,
      NULL,
      1.802637,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.420696,
      NULL,
      NULL,
      1.397933,
      NULL,
      NULL,
      3,
      NULL,
      1.641602,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.584394,
      1,
      NULL,
      0.027290,
      0.045991,
      0,
      6,
      0,
      7.050793,
      1.232540,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.430901,
      1.363404,
      NULL,
      NULL,
      0,
      2,
      NULL,
      2,
      4,
      1,
      NULL,
      0.173791,
      3,
      NULL,
      NULL,
      0,
      3,
      NULL,
      2,
      0,
      1,
      NULL,
      5,
      1.913017,
      0.698084,
      1.183703,
      0,
      NULL,
      5,
      NULL,
      0.660987,
      0.909961,
      1,
      0.780551,
      1.002166,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.030928,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1,
      NULL,
      3,
      3.681544,
      NULL,
      NULL,
      2,
      3.059181,
      NULL,
      NULL,
      86.782734,
      NULL,
      NULL,
      NULL,
      1.917935,
      NULL,
      NULL,
      NULL,
      1.116469,
      NULL,
      NULL,
      NULL,
      1.377071,
      1.430479,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.006976,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.700273,
      2,
      NULL,
      NULL,
      3.127121,
      1,
      NULL,
      NULL,
      0,
      1.537969,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      2.386065,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      0.046344,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.558602,
      NULL,
      NULL,
      NULL,
      1.009144,
      NULL,
      NULL,
      NULL,
      2.602310,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      89.641880,
      NULL,
      0,
      NULL,
      4,
      0,
      NULL,
      NULL,
      0.218615,
      NULL,
      NULL,
      0.768897,
      3.539322,
      1.192888,
      1,
      NULL,
      NULL,
      2.917922,
      8.107123,
      1,
      8.273206,
      1.633334,
      NULL,
      1,
      1,
      0,
      1.286584,
      0.889077,
      0.349117,
      0,
      0,
      0,
      NULL,
      0.766865,
      0,
      0,
      1.419446,
      1.202051,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      8.533336,
      3.346593,
      0.249792,
      3.376644,
      1.408734,
      NULL,
      NULL,
      3,
      2,
      0,
      0.809782,
      1,
      0.690539,
      2.737677,
      NULL,
      NULL,
      2.902723,
      1,
      0.005210,
      1.442920,
      0,
      0,
      2,
      2.872858,
      NULL,
      0.447307,
      0,
      NULL,
      NULL,
      1.389693,
      0,
      NULL,
      0.914055,
      1,
      1.678831,
      3,
      NULL,
      3.028881,
      0.781406,
      0,
      1,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.286685,
      2.476234,
      NULL,
      1.417068,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.859719,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.839612,
      NULL,
      0,
      NULL,
      2,
      NULL,
      2,
      NULL,
      1.754928,
      NULL,
      0.809411,
      30.739564,
      0.303016,
      NULL,
      0,
      1,
      0,
      3,
      1,
      0.476510,
      5.987274,
      7,
      8,
      3,
      NULL,
      3.667387,
      NULL,
      66.169075,
      5,
      1.839317,
      4.575090,
      '13201',
      '44302',
      '',
      0,
      '',
      '',
      '',
      3,
      '034',
      NULL,
      '');
commit;
end;
/


