set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7715855';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-9-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      '3032120',
      2.098057,
      0.560153,
      5,
      0,
      '3442',
      1,
      1,
      NULL,
      NULL,
      ' 1-23-1999',
      28,
      NULL,
      1,
      0.182813,
      NULL,
      ' 0-16-1975',
      28.279377,
      0,
      NULL,
      47,
      0,
      ' 3-20-1984',
      ' 2-19-1997',
      ' 7- 3-1995',
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      9,
      3.297445,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      3.134283,
      10,
      5.285164,
      12,
      1.048781,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      0.968478,
      1.048489,
      5,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      0.055856,
      0.497867,
      NULL,
      3,
      NULL,
      1,
      0.330915,
      0,
      0.619085,
      5.449764,
      0.373485,
      1.351259,
      NULL,
      0.082503,
      0,
      NULL,
      NULL,
      2.662500,
      0.184536,
      4.475960,
      NULL,
      9,
      NULL,
      2.081583,
      1,
      0,
      1,
      1.980115,
      1.712484,
      2,
      2.332704,
      1,
      NULL,
      3,
      0.863914,
      1.697198,
      0,
      0.594090,
      0,
      0.555416,
      NULL,
      1.808731,
      NULL,
      2,
      2.559307,
      1,
      0.573159,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.154338,
      NULL,
      3,
      0,
      0,
      NULL,
      5,
      1.853803,
      NULL,
      1.461126,
      1.529512,
      0.519587,
      1.882031,
      NULL,
      0.316744,
      NULL,
      1.144423,
      1.980238,
      0,
      NULL,
      NULL,
      4,
      1,
      2,
      1,
      1.360953,
      NULL,
      1.309387,
      NULL,
      NULL,
      NULL,
      1.703271,
      0.247236,
      0,
      NULL,
      0,
      2,
      4,
      1.387563,
      5.877235,
      0.090117,
      7.746633,
      2.368572,
      NULL,
      0,
      5.825593,
      0.142909,
      0,
      ' 9- 9-1978',
      28.606635,
      ' 7- 4-1974',
      26.662659,
      1.712667,
      2.632953,
      NULL,
      4,
      2.988571,
      NULL,
      1,
      0.307848,
      2.676265,
      1.647854,
      3,
      4,
      5.787806,
      0,
      2,
      3,
      1.883953,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.080116,
      NULL,
      13.497946,
      1.702074,
      1.411894,
      6.803576,
      0.400508,
      1.328777,
      3.343743,
      2,
      5,
      NULL,
      0.852184,
      0.694332,
      NULL,
      NULL,
      NULL,
      4,
      1.557148,
      7.114591,
      NULL,
      4,
      4.059795,
      NULL,
      0.270425,
      1.440531,
      2,
      0.694080,
      5.508040,
      1.779957,
      1,
      1.315935,
      7.044916,
      4.058977,
      ' 7-26-1985',
      19,
      ' 4-25-1986',
      8.823952,
      1.460793,
      NULL,
      0,
      1,
      2.976386,
      0.385009,
      1.571484,
      1,
      1,
      NULL,
      1,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      3,
      1,
      0,
      0.114798,
      0,
      2,
      3,
      1.756999,
      3,
      NULL,
      1,
      NULL,
      3,
      2.221727,
      1.438053,
      0,
      1,
      1.944700,
      0,
      0.857889,
      1,
      NULL,
      2.539412,
      1,
      0.778871,
      0,
      0,
      1.898043,
      0,
      0.915271,
      9.228127,
      1.025055,
      1,
      9,
      2.555425,
      4.801770,
      NULL,
      4,
      3.839290,
      0,
      2,
      61.192112,
      3,
      NULL,
      NULL,
      NULL,
      81.570750,
      14,
      NULL,
      1.592888,
      NULL,
      '31134',
      '10032',
      '04223',
      1.205027,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      0.784108,
      23.516256,
      88.771245,
      NULL,
      NULL,
      NULL,
      0,
      0.248223,
      NULL,
      3,
      0,
      2.966004,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.002674,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.779321,
      NULL,
      NULL,
      1,
      0.192897,
      1,
      1,
      NULL,
      NULL,
      3,
      1.390325,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.875149,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.691958,
      NULL,
      NULL,
      2,
      3.744188,
      1.266345,
      NULL,
      2,
      1,
      2,
      0.329635,
      0.618566,
      0,
      1.734564,
      0.008048,
      0,
      3,
      0,
      0,
      2.584726,
      1.667597,
      3.166808,
      2,
      2.047792,
      NULL,
      1,
      NULL,
      0,
      3,
      2,
      1.683565,
      NULL,
      2.050237,
      2.908262,
      1,
      0,
      3,
      0.351095,
      0.610082,
      NULL,
      3.923526,
      3.110362,
      1.418636,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.105692,
      1.408855,
      1.477769,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.644444,
      NULL,
      1.757728,
      NULL,
      NULL,
      NULL,
      6.550811,
      0.586587,
      4,
      2.503820,
      2,
      0,
      1,
      3,
      0,
      0,
      NULL,
      NULL,
      1.976478,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.949809,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.260806,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.554849,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1,
      2,
      3.124304,
      1,
      2,
      NULL,
      NULL,
      NULL,
      2.334124,
      1,
      0,
      0.786034,
      NULL,
      NULL,
      0.940538,
      3.550371,
      4,
      2.574274,
      0,
      0,
      0.265150,
      3.618045,
      0,
      NULL,
      1.969842,
      2.666959,
      1,
      NULL,
      NULL,
      NULL,
      2,
      4,
      NULL,
      1.067158,
      1.411043,
      0.398437,
      3.936533,
      3,
      0,
      0.783849,
      0.445449,
      1.456210,
      NULL,
      NULL,
      NULL,
      NULL,
      2.646855,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.085010,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.706521,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.240446,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      3.939593,
      1,
      0.300064,
      0,
      NULL,
      0.457552,
      1.962293,
      NULL,
      2,
      3,
      3,
      NULL,
      16,
      164,
      NULL,
      NULL,
      0.896178,
      3.895749,
      NULL,
      NULL,
      3.647633,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.037828,
      NULL,
      0.356055,
      NULL,
      0.412882,
      NULL,
      3.904095,
      NULL,
      3.006229,
      1.148253,
      1.388699,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.979220,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.018690,
      NULL,
      NULL,
      NULL,
      0,
      1.460933,
      0.501519,
      NULL,
      NULL,
      0.112817,
      1.180342,
      NULL,
      NULL,
      NULL,
      0.486866,
      NULL,
      0.610505,
      2.055110,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.992186,
      2.260541,
      NULL,
      NULL,
      1.431654,
      0,
      1.557798,
      NULL,
      6,
      9,
      NULL,
      NULL,
      1,
      1,
      3,
      1,
      0,
      1,
      0.364735,
      2,
      1.528850,
      42.177488,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      12,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      293,
      NULL,
      3.642732,
      2,
      0.963267,
      3,
      0.750127,
      2,
      0.823629,
      1.693205,
      0,
      2.747530,
      1,
      3,
      3,
      NULL,
      1,
      1,
      0,
      2.632834,
      1,
      1.860153,
      1.695201,
      1.193357,
      2.660032,
      1.902866,
      NULL,
      0,
      1.647465,
      NULL,
      3,
      62,
      3,
      0,
      37.206265,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.907954,
      0,
      1.148317,
      1,
      0,
      NULL,
      1,
      0,
      0.917568,
      2,
      0.498220,
      1,
      0,
      0,
      0,
      NULL,
      0.756062,
      3,
      0,
      0,
      1,
      1,
      NULL,
      3,
      0,
      NULL,
      2,
      0,
      1.575806,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.843878,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.973757,
      NULL,
      1.958252,
      NULL,
      2,
      NULL,
      1.305332,
      NULL,
      2.309291,
      NULL,
      NULL,
      NULL,
      2.495165,
      NULL,
      1.440166,
      NULL,
      3.473052,
      NULL,
      NULL,
      0,
      3,
      NULL,
      1.295957,
      NULL,
      1.238148,
      NULL,
      22,
      NULL,
      0.192036,
      NULL,
      3.460995,
      NULL,
      1,
      NULL,
      3.467713,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.365139,
      NULL,
      NULL,
      NULL,
      NULL,
      1.417861,
      NULL,
      23,
      NULL,
      1.302060,
      0,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      56,
      NULL,
      3.710118,
      NULL,
      1,
      NULL,
      1.292934,
      1,
      1,
      21,
      33.009427,
      3,
      NULL,
      1,
      1,
      1.604854,
      3,
      1,
      5.008417,
      NULL,
      1,
      1,
      NULL,
      5,
      NULL,
      1,
      2,
      0.017786,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      2,
      NULL,
      0,
      NULL,
      0.202455,
      3,
      NULL,
      1.749093,
      3.887338,
      0.853131,
      1,
      1.728086,
      0.963109,
      0,
      1.572603,
      0,
      2,
      NULL,
      1.027225,
      0.853332,
      0.619206,
      1.974453,
      NULL,
      NULL,
      0.674543,
      1,
      1,
      1.970085,
      2,
      NULL,
      1,
      0,
      1,
      3,
      1,
      0.981118,
      0,
      NULL,
      1.738527,
      1.642554,
      NULL,
      1,
      0.599461,
      1,
      NULL,
      0,
      1,
      0,
      2.091203,
      NULL,
      NULL,
      1.698553,
      NULL,
      1.146571,
      0.315040,
      21.335092,
      2.416583,
      NULL,
      0.303936,
      1.969495,
      NULL,
      0,
      NULL,
      0,
      3.091850,
      0,
      NULL,
      3,
      3.536352,
      1,
      3,
      NULL,
      3.952700,
      0,
      1,
      NULL,
      1.399391,
      0.509293,
      0.896747,
      0.318520,
      3,
      3,
      2,
      1,
      1,
      12.456145,
      NULL,
      NULL,
      1,
      1.626674,
      0,
      0,
      NULL,
      NULL,
      0,
      0.266340,
      NULL,
      NULL,
      NULL,
      NULL,
      53.165738,
      41.316730,
      3.636609,
      1.578497,
      5,
      '03013',
      NULL,
      '04421',
      3.951971,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


