set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8524572';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-3-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '4',
      NULL,
      NULL,
      '4440222',
      1.516684,
      1.287257,
      NULL,
      2,
      '2012',
      NULL,
      1,
      NULL,
      NULL,
      ' 4-26-1983',
      11,
      NULL,
      3.590770,
      NULL,
      3.397469,
      ' 4-19-1994',
      0,
      0.085895,
      NULL,
      20,
      1,
      ' 0- 5-2000',
      ' 0-16-1986',
      ' 6-25-1986',
      2.996672,
      1,
      3,
      1,
      0.968371,
      1,
      1,
      1,
      1,
      29.276395,
      NULL,
      NULL,
      4.711805,
      17,
      2,
      7,
      8.175821,
      2,
      NULL,
      5,
      0,
      3,
      1.896399,
      0,
      0,
      NULL,
      1.308533,
      3,
      1,
      NULL,
      NULL,
      3.390024,
      5.862306,
      1.872487,
      0.017682,
      3,
      NULL,
      1.437666,
      11,
      NULL,
      1.686309,
      8.420236,
      1.966205,
      NULL,
      1,
      1,
      NULL,
      3.519712,
      0,
      4.778205,
      NULL,
      1.772951,
      0.674647,
      NULL,
      NULL,
      1.612735,
      NULL,
      NULL,
      0.690289,
      0.989973,
      0.468246,
      1.221955,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.978225,
      1,
      0.122585,
      1,
      0,
      4.407534,
      NULL,
      0.859092,
      NULL,
      NULL,
      0.319035,
      NULL,
      NULL,
      0,
      1.547222,
      2,
      0.275497,
      NULL,
      1.720388,
      NULL,
      1.611134,
      1.905411,
      0.812124,
      0.931986,
      1.760380,
      NULL,
      0,
      0.228506,
      1,
      0,
      0,
      0.331681,
      NULL,
      0,
      3,
      1,
      0,
      0,
      0,
      NULL,
      7.155703,
      0,
      0.595558,
      3,
      5,
      2.460761,
      2.363974,
      0,
      1.770424,
      NULL,
      NULL,
      3.444370,
      2,
      5.906465,
      0.911645,
      NULL,
      6.439674,
      1.692339,
      1,
      0,
      3.524288,
      ' 0- 2-1996',
      729,
      ' 0-25-1977',
      237.703939,
      3.333069,
      3.689746,
      0,
      1.219518,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.062636,
      NULL,
      2,
      2.379844,
      0,
      1.868274,
      NULL,
      0.838280,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.715853,
      NULL,
      551.831762,
      2.659378,
      1.276791,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.828180,
      2.476915,
      3.438561,
      0,
      1,
      NULL,
      0,
      3.707271,
      7.297835,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      0,
      NULL,
      0.220410,
      3.716049,
      4.019193,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.078156,
      3.320789,
      0.902434,
      3.454115,
      1.727137,
      3.640879,
      2.257117,
      1.030762,
      3.160852,
      1,
      2,
      2,
      0.858965,
      3.964081,
      3,
      2.507145,
      NULL,
      1,
      NULL,
      0,
      1.177331,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      1,
      3.195205,
      1.160529,
      0.213161,
      8.242175,
      7.006396,
      7.692246,
      10.002726,
      1,
      5.159599,
      4,
      2.052796,
      4,
      0.587370,
      3,
      1.039083,
      NULL,
      0.460149,
      2.081486,
      NULL,
      16.176218,
      NULL,
      46,
      3,
      1.132513,
      0.489569,
      '13310',
      '',
      NULL,
      NULL,
      '41132',
      '',
      NULL,
      1.049281,
      '',
      '',
      '',
      0.665238,
      37,
      28,
      NULL,
      1.789644,
      19.634735,
      4.637810,
      0,
      0,
      1,
      NULL,
      NULL,
      0.476882,
      NULL,
      NULL,
      1.940209,
      NULL,
      NULL,
      2,
      0.037704,
      0.410751,
      NULL,
      0,
      0,
      2,
      0.428643,
      3.717302,
      1.465262,
      0.525471,
      3,
      0,
      NULL,
      NULL,
      1.508553,
      NULL,
      NULL,
      1.687379,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      6.914735,
      1,
      1.566914,
      NULL,
      NULL,
      NULL,
      2,
      1.283255,
      1.858818,
      2.532678,
      1.612166,
      NULL,
      NULL,
      1.617917,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.359547,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      3,
      1.728567,
      1.439950,
      3.178843,
      1,
      1.277154,
      1.055231,
      0.063322,
      NULL,
      NULL,
      NULL,
      3,
      1.683702,
      1.276685,
      1.125766,
      NULL,
      NULL,
      NULL,
      0,
      1.807020,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0.994053,
      5.358740,
      NULL,
      NULL,
      NULL,
      0.630253,
      NULL,
      NULL,
      0.067250,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.170431,
      NULL,
      NULL,
      1.422806,
      NULL,
      NULL,
      1.497600,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.031514,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.064159,
      3,
      3,
      1,
      NULL,
      NULL,
      0.131036,
      NULL,
      NULL,
      1.995024,
      0.911222,
      NULL,
      NULL,
      2.058991,
      1,
      7,
      7.242191,
      NULL,
      NULL,
      1.151919,
      NULL,
      NULL,
      2.952543,
      3.039093,
      0.370352,
      0.276936,
      1,
      1.863965,
      2.872980,
      1,
      9,
      1,
      1,
      1,
      0,
      2,
      3.763578,
      2,
      5.917659,
      NULL,
      NULL,
      1.581079,
      1,
      1.495425,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.876615,
      NULL,
      NULL,
      0.112425,
      NULL,
      NULL,
      0.708627,
      NULL,
      NULL,
      0.231507,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      5.960074,
      NULL,
      NULL,
      NULL,
      3,
      2,
      2.068402,
      0,
      1,
      1.817799,
      9,
      NULL,
      2,
      NULL,
      11.050740,
      NULL,
      48,
      NULL,
      1.937490,
      NULL,
      1.167570,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2.442416,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.932716,
      NULL,
      3,
      NULL,
      3,
      NULL,
      2.490732,
      NULL,
      8.869130,
      NULL,
      2,
      NULL,
      6.378612,
      NULL,
      3.149423,
      NULL,
      6,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.288196,
      NULL,
      NULL,
      NULL,
      1.104732,
      NULL,
      1.428657,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      10.727733,
      NULL,
      2.445703,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2.721833,
      1,
      NULL,
      NULL,
      3.307884,
      1,
      1,
      2,
      NULL,
      1.632005,
      2.938863,
      0,
      NULL,
      1.145468,
      NULL,
      NULL,
      3.020923,
      3.379627,
      0,
      10,
      NULL,
      0.080694,
      NULL,
      1,
      0.315863,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      13,
      0.293784,
      7,
      0.502266,
      0,
      3.475214,
      1,
      1,
      NULL,
      1.051079,
      NULL,
      NULL,
      0,
      1.734227,
      NULL,
      2,
      3,
      NULL,
      2.140821,
      NULL,
      NULL,
      0.854876,
      0.049603,
      NULL,
      0,
      1.458839,
      NULL,
      2.844012,
      2,
      NULL,
      0.884062,
      NULL,
      NULL,
      1.938944,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.302102,
      1.040349,
      NULL,
      1.000870,
      0,
      0.030322,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      1,
      NULL,
      0.796053,
      NULL,
      1,
      NULL,
      1.747497,
      NULL,
      3,
      NULL,
      2.246892,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.335022,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2.095384,
      NULL,
      NULL,
      NULL,
      0,
      2.006509,
      1,
      3,
      1.352941,
      0,
      NULL,
      30.521282,
      5,
      0.513561,
      NULL,
      '22124',
      '01131',
      '',
      0.151608,
      '00112',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


