set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8831314';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-1-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      '2144404',
      0.751157,
      1.857195,
      NULL,
      1,
      '3020',
      3,
      0.421746,
      NULL,
      NULL,
      ' 8-29-1988',
      6,
      NULL,
      5.382959,
      3.602240,
      NULL,
      ' 0-19-1977',
      47.751338,
      0.058794,
      254.117950,
      74,
      1.169912,
      ' 5-25-1994',
      ' 1-14-1990',
      NULL,
      3,
      1.085573,
      2,
      1.867521,
      0.119986,
      1,
      NULL,
      1.896059,
      0.413146,
      3.398472,
      0.757021,
      2.912761,
      6,
      NULL,
      172,
      0.684958,
      13.288708,
      5,
      1,
      NULL,
      NULL,
      NULL,
      1.338884,
      1.380514,
      1,
      NULL,
      NULL,
      1,
      1.070831,
      NULL,
      44,
      0.855897,
      NULL,
      6,
      3.970742,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.129814,
      3.306113,
      NULL,
      0,
      0,
      0,
      1,
      0.609903,
      0,
      0.018491,
      1.399810,
      NULL,
      1.983924,
      NULL,
      NULL,
      0.269927,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      3.108840,
      0.517004,
      2.126832,
      0.915055,
      0.385332,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.117106,
      4,
      1.880184,
      1.414769,
      1,
      0.400027,
      0.300924,
      0,
      0,
      1.779543,
      0.723130,
      NULL,
      0.031153,
      1,
      1.058086,
      NULL,
      0.578906,
      1.619683,
      NULL,
      1,
      1.528359,
      NULL,
      NULL,
      0,
      0.386019,
      NULL,
      4,
      NULL,
      1,
      3.162111,
      0,
      NULL,
      1,
      NULL,
      3,
      10.511203,
      0.582527,
      NULL,
      4,
      2.458342,
      NULL,
      8.506468,
      0.819582,
      7,
      NULL,
      5,
      1,
      ' 8-22-2001',
      NULL,
      ' 8-17-1987',
      273.006544,
      2.666116,
      0.910710,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.038466,
      0.800455,
      1,
      0.712387,
      1.748582,
      0.285863,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      21.322543,
      3.023394,
      NULL,
      1.909592,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.915818,
      0.539023,
      1,
      0.353029,
      2.484010,
      1,
      0,
      0,
      4.236134,
      1.434924,
      1.688798,
      4,
      3.472629,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.967626,
      NULL,
      0,
      0,
      NULL,
      0,
      0.914241,
      3.295711,
      9.849363,
      3,
      0.703824,
      12,
      24,
      249.881121,
      1.511841,
      1.572894,
      1,
      1,
      1.114700,
      3.704057,
      2.211249,
      NULL,
      3.791768,
      2.997689,
      1.941202,
      2,
      1,
      1,
      10.682490,
      19.948345,
      128,
      73,
      94,
      116,
      NULL,
      NULL,
      1,
      0.706116,
      0,
      NULL,
      1.342937,
      NULL,
      0,
      3,
      5,
      0.324900,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.385505,
      NULL,
      7.028127,
      36,
      60.644736,
      4.162388,
      NULL,
      1,
      '00421',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      0,
      23.944990,
      NULL,
      9.054678,
      1.115780,
      21.605838,
      NULL,
      17,
      0,
      2,
      2.842114,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1.757387,
      1,
      1.715243,
      3.898497,
      2,
      NULL,
      NULL,
      NULL,
      1.484516,
      NULL,
      3.378490,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.643829,
      NULL,
      4,
      1.721576,
      1.470936,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.259046,
      1.520702,
      0,
      1,
      NULL,
      NULL,
      0.571088,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.808575,
      1,
      NULL,
      1.355746,
      0.691302,
      0,
      1,
      0.568639,
      0,
      2,
      0.750486,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.684088,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      1.798916,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.066874,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0.071338,
      NULL,
      NULL,
      9,
      9.552886,
      4.337548,
      1.693604,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5.677722,
      1,
      0.413881,
      0.047728,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.288653,
      NULL,
      NULL,
      0.864923,
      2.151094,
      3,
      2,
      NULL,
      0,
      6.792122,
      3,
      3,
      NULL,
      2.328048,
      1,
      2,
      NULL,
      NULL,
      0,
      0.647780,
      0.011160,
      3.441323,
      3.119091,
      0,
      3,
      NULL,
      2.485989,
      10.772620,
      NULL,
      2.832548,
      1.471066,
      1,
      3.374633,
      1.220795,
      NULL,
      NULL,
      3.405803,
      1.423140,
      0.876789,
      NULL,
      3,
      1.011820,
      5.545071,
      8.130258,
      NULL,
      NULL,
      NULL,
      NULL,
      1.703738,
      NULL,
      NULL,
      1.063207,
      0.905810,
      0.182780,
      NULL,
      1,
      3.598446,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.791861,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.787896,
      2,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      0.357750,
      NULL,
      NULL,
      23,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0.417825,
      1,
      NULL,
      NULL,
      0.845067,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.659328,
      1,
      NULL,
      NULL,
      0.747404,
      NULL,
      NULL,
      NULL,
      0,
      0.214814,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.592306,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.470085,
      2,
      NULL,
      NULL,
      0,
      0.078729,
      NULL,
      NULL,
      3.573718,
      3,
      NULL,
      NULL,
      3.211399,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      1,
      2.913110,
      9.580638,
      3.024265,
      1.431122,
      81.567918,
      4,
      0.366801,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.072193,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.317678,
      13446.212236,
      550.325720,
      1,
      NULL,
      NULL,
      0,
      1.225309,
      1.410198,
      1.310341,
      NULL,
      1.693050,
      NULL,
      1,
      0.930335,
      0.385562,
      0,
      0.012620,
      0.863484,
      1,
      1.759487,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.417392,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.480772,
      0,
      NULL,
      0.739463,
      3,
      3,
      3,
      4,
      15,
      3.245044,
      3,
      NULL,
      0,
      0,
      NULL,
      1.818646,
      NULL,
      1,
      1.875692,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      3.614080,
      0.472520,
      1.594228,
      2.173768,
      0.425217,
      1,
      2,
      3,
      0,
      0,
      NULL,
      1,
      0.345935,
      1,
      0.081685,
      3,
      3.827767,
      1,
      NULL,
      0,
      1,
      1.599338,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      2,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.125231,
      NULL,
      0,
      NULL,
      2,
      NULL,
      2.717743,
      NULL,
      0.501760,
      NULL,
      2,
      NULL,
      2,
      NULL,
      3,
      NULL,
      2.735190,
      NULL,
      NULL,
      18,
      NULL,
      NULL,
      1,
      0.523317,
      0.559115,
      0.948490,
      1,
      1.637859,
      3.667558,
      6,
      5.792929,
      1,
      1.989705,
      NULL,
      58,
      NULL,
      2.807846,
      1,
      NULL,
      '01412',
      '',
      '',
      0.581779,
      '',
      '',
      '',
      1.098370,
      NULL,
      '',
      '');
commit;
end;
/


