set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5715854';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-5-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      25.348119,
      12,
      NULL,
      1,
      1.869354,
      NULL,
      1,
      '2014',
      2,
      0.793165,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.157338,
      ' 7- 3-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 1-18-1998',
      ' 6-20-1995',
      ' 8-21-2000',
      2,
      NULL,
      3.003775,
      0,
      0.508583,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      9,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.602378,
      NULL,
      1.176219,
      NULL,
      0,
      1,
      0.174260,
      1.101158,
      3.095545,
      0.258554,
      NULL,
      0,
      0,
      0.178066,
      9.197163,
      1,
      NULL,
      1.997776,
      0.065724,
      5,
      6,
      NULL,
      NULL,
      0,
      0.272364,
      1.827877,
      10,
      1,
      3.567113,
      2.783823,
      0,
      0.195728,
      NULL,
      NULL,
      1.100462,
      NULL,
      NULL,
      4,
      7.962122,
      2.477781,
      1,
      NULL,
      0,
      2,
      NULL,
      1.378911,
      1,
      3.804248,
      1,
      NULL,
      1,
      NULL,
      3,
      1.791818,
      2,
      2.568474,
      4.439207,
      0,
      1,
      6,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2,
      3.733810,
      NULL,
      5.984691,
      1.105860,
      0,
      NULL,
      0.974020,
      NULL,
      NULL,
      NULL,
      0.889028,
      2.357465,
      NULL,
      NULL,
      0.473854,
      1.399702,
      1.618353,
      NULL,
      NULL,
      0,
      1.545738,
      0.837544,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.334984,
      5.344066,
      0.727382,
      1,
      1.533750,
      1.808002,
      2.603670,
      2.585858,
      2,
      2.883315,
      4,
      3.922482,
      1,
      3,
      3.681979,
      NULL,
      4.995373,
      1.640283,
      1,
      NULL,
      288,
      ' 5-14-1989',
      113,
      2,
      1,
      0.084417,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.609842,
      0.603378,
      0.503339,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.489664,
      NULL,
      NULL,
      NULL,
      NULL,
      0.366035,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      1.321211,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.629887,
      0.838191,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.852255,
      0.863142,
      1,
      1,
      NULL,
      0.365287,
      0,
      NULL,
      15.317380,
      0,
      1.740948,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4,
      3.337638,
      4,
      3,
      2,
      NULL,
      0.908325,
      4,
      1,
      NULL,
      2,
      2,
      0,
      0.064435,
      0.618001,
      1.191146,
      1.546294,
      0,
      1,
      1.577403,
      NULL,
      1,
      1,
      NULL,
      1.644763,
      0,
      5,
      1.598144,
      0.995819,
      0,
      5,
      1.985752,
      3,
      2,
      4.391991,
      NULL,
      4.610876,
      0.684011,
      1,
      NULL,
      NULL,
      2,
      1,
      26,
      NULL,
      43.113522,
      2.502617,
      NULL,
      NULL,
      0,
      NULL,
      '',
      '',
      0,
      NULL,
      '',
      '',
      0.417018,
      '',
      '',
      '',
      1.596109,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.188458,
      2,
      NULL,
      0.389528,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      3,
      1,
      1,
      2.439668,
      3.131775,
      NULL,
      0.773720,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.591984,
      NULL,
      NULL,
      6,
      NULL,
      6,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2.459128,
      NULL,
      NULL,
      3,
      3,
      2,
      3,
      1.401557,
      2,
      1.668017,
      1.200816,
      NULL,
      2,
      1.742819,
      0.707843,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      2,
      NULL,
      2,
      0,
      1,
      2.993050,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.994000,
      6.274699,
      7.203266,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.419514,
      NULL,
      NULL,
      3,
      1,
      1,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      7.379530,
      0.786797,
      NULL,
      NULL,
      2.808654,
      1,
      1.060865,
      NULL,
      NULL,
      3.635847,
      5.715685,
      3,
      1.793053,
      NULL,
      NULL,
      1.373122,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.402373,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.663895,
      NULL,
      NULL,
      3,
      0,
      NULL,
      0.175941,
      NULL,
      NULL,
      2.984271,
      0.734481,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.466342,
      1.287480,
      4.626065,
      3.583176,
      0.691280,
      NULL,
      0,
      0,
      NULL,
      2,
      3,
      NULL,
      NULL,
      2,
      NULL,
      1.835370,
      3,
      2,
      2.064121,
      2,
      NULL,
      NULL,
      3,
      5.949006,
      1.140358,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.721658,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.082769,
      NULL,
      NULL,
      0.719401,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.969014,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.669926,
      1.085722,
      0,
      NULL,
      0.167447,
      1.612816,
      0.175109,
      NULL,
      NULL,
      0.291405,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.311453,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.713784,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.129899,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.431908,
      NULL,
      NULL,
      NULL,
      0.330533,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0.776848,
      NULL,
      NULL,
      1.434365,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.946557,
      NULL,
      NULL,
      0.888354,
      NULL,
      1,
      NULL,
      9.097458,
      0.990894,
      0,
      0,
      1.922993,
      0.226717,
      1,
      0.025787,
      NULL,
      1,
      0.422166,
      1,
      1,
      0,
      1.136354,
      1,
      0.606153,
      1.810146,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.085071,
      NULL,
      1.429086,
      3.472640,
      1,
      NULL,
      5.440670,
      10,
      2,
      0.076227,
      1.159524,
      0.398558,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.984993,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.698611,
      0,
      NULL,
      1.133186,
      0,
      NULL,
      1.777472,
      NULL,
      NULL,
      1,
      0,
      NULL,
      3,
      2.684468,
      NULL,
      3,
      2.815411,
      NULL,
      1.124522,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.898037,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.517148,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.035163,
      5.730246,
      NULL,
      1.080000,
      NULL,
      NULL,
      14.134067,
      NULL,
      1,
      NULL,
      NULL,
      '04401',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.217281,
      '',
      '',
      '');
commit;
end;
/


