set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9658113';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-4-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '43',
      '33',
      NULL,
      NULL,
      '1031031',
      3,
      1.871628,
      NULL,
      3,
      '0124',
      0,
      1,
      NULL,
      NULL,
      NULL,
      17,
      30,
      NULL,
      NULL,
      1.643168,
      ' 3- 7-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      2.358158,
      '10- 7-1982',
      ' 1-20-1996',
      NULL,
      0.249318,
      1,
      1.390611,
      3.986507,
      1,
      0,
      3.032373,
      0.946969,
      NULL,
      NULL,
      NULL,
      4,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      4.432641,
      1.665279,
      NULL,
      1.281873,
      0,
      1,
      1.162741,
      0,
      1.904618,
      1.599739,
      NULL,
      1,
      0,
      NULL,
      0,
      4.855288,
      0.186288,
      3,
      4.365439,
      NULL,
      5.842679,
      1,
      3.545956,
      NULL,
      9,
      NULL,
      4.021693,
      3.939350,
      NULL,
      4.809430,
      2,
      1,
      1,
      NULL,
      1.538083,
      1,
      NULL,
      NULL,
      0.514912,
      NULL,
      NULL,
      2.422631,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.919794,
      2.294664,
      2.062331,
      1.737172,
      1.745671,
      0.662393,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      7,
      3.640497,
      5.485087,
      4.242237,
      1,
      0.514431,
      NULL,
      0,
      8.903226,
      0,
      0.464667,
      0.118740,
      1,
      0,
      NULL,
      1.213183,
      1.273631,
      9.293455,
      4.569172,
      NULL,
      NULL,
      NULL,
      2,
      0.366799,
      1,
      0,
      0,
      0.845945,
      NULL,
      NULL,
      NULL,
      3,
      8.483271,
      NULL,
      3,
      1,
      6,
      6.549778,
      3,
      7.027061,
      5,
      1,
      NULL,
      ' 9-12-1993',
      8,
      NULL,
      3.902815,
      3.311116,
      NULL,
      5.142379,
      5.435452,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.658944,
      NULL,
      5,
      1,
      7,
      0.472218,
      6,
      0,
      6.104898,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.226027,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3.283867,
      2.784604,
      2,
      1.388010,
      1.458821,
      NULL,
      7,
      6,
      2,
      4,
      4,
      NULL,
      2,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.804035,
      NULL,
      0.079438,
      2.654678,
      NULL,
      0,
      1,
      3.233439,
      24,
      0.184317,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.968051,
      0.817496,
      2,
      NULL,
      1,
      1.618894,
      1.745971,
      1.382756,
      3,
      3,
      0.946342,
      0.994117,
      3,
      0.406471,
      1,
      2.571897,
      0,
      1,
      1.654601,
      1,
      1,
      0.159451,
      1,
      1,
      0,
      0,
      1,
      0,
      1,
      0,
      9,
      2,
      0.892170,
      11.517059,
      0.832258,
      4.147493,
      2,
      2.667643,
      6,
      3.745878,
      2,
      0,
      63,
      1,
      3,
      3.220657,
      NULL,
      NULL,
      16,
      0.906780,
      4.730401,
      2,
      '21233',
      NULL,
      '',
      0.153238,
      '',
      '',
      '',
      1.644270,
      '',
      NULL,
      NULL,
      1.807264,
      22,
      2.162192,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.517777,
      NULL,
      24,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.594233,
      14.801496,
      1,
      NULL,
      NULL,
      0.094211,
      NULL,
      NULL,
      0,
      NULL,
      0.292373,
      521.506639,
      NULL,
      0.330990,
      NULL,
      0.547949,
      1.498451,
      0.985359,
      1.509521,
      NULL,
      NULL,
      NULL,
      1.993647,
      1,
      NULL,
      0.986282,
      NULL,
      1,
      NULL,
      0.011652,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.352205,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.964969,
      1.413645,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.262738,
      0.661937,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.424845,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.526140,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.258948,
      1.704333,
      NULL,
      0.769197,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.828319,
      0.447758,
      1,
      NULL,
      1,
      NULL,
      2.668551,
      NULL,
      0.434178,
      NULL,
      0,
      NULL,
      1.483473,
      NULL,
      1,
      0.551791,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2.401624,
      NULL,
      0,
      1,
      1.067687,
      2,
      4,
      NULL,
      2.365637,
      1.951040,
      0.192842,
      0,
      NULL,
      0.379277,
      1,
      NULL,
      1.497284,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      1.849143,
      NULL,
      0.425989,
      1.806713,
      NULL,
      1.214768,
      1.685362,
      NULL,
      0.384424,
      1,
      NULL,
      0.287005,
      NULL,
      NULL,
      1,
      1.023737,
      NULL,
      1.469807,
      0.499504,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.902600,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.649217,
      NULL,
      0,
      0,
      NULL,
      NULL,
      25.342377,
      28,
      NULL,
      3.423846,
      0,
      '03003',
      '',
      '',
      0.569241,
      '',
      NULL,
      '',
      0.054221,
      '',
      '',
      '');
commit;
end;
/


