set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9030654';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-11-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '2',
      NULL,
      NULL,
      '3013030',
      1.968522,
      0.716319,
      2,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.605359,
      1.639634,
      ' 3- 9-1993',
      16.076530,
      4,
      91,
      18.624496,
      3.502905,
      ' 0-16-1995',
      '11-17-1996',
      ' 2-11-1988',
      0,
      NULL,
      1,
      0,
      NULL,
      3,
      0,
      0.684053,
      0,
      78.331388,
      NULL,
      12.479005,
      8,
      17,
      21.970437,
      2.911369,
      18,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      6.601383,
      0,
      0,
      0.219864,
      1.752501,
      1,
      0.842167,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.689952,
      0.973305,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      1,
      0.821709,
      0,
      1.659321,
      NULL,
      3.430574,
      0,
      3.738798,
      0.016564,
      3,
      3.488025,
      1,
      3,
      2,
      0,
      0,
      3,
      0.244946,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.973673,
      3,
      0.050386,
      NULL,
      NULL,
      0.904685,
      NULL,
      NULL,
      1,
      1.954486,
      1.602673,
      0.690507,
      0.496103,
      NULL,
      5,
      1,
      1.116891,
      NULL,
      1,
      0.150073,
      0,
      2,
      1.959592,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.273166,
      1.645927,
      NULL,
      0,
      NULL,
      0.940086,
      2,
      4,
      3.675102,
      1,
      1.519564,
      2.904486,
      NULL,
      5,
      1.398595,
      NULL,
      7,
      0.756177,
      2,
      NULL,
      0,
      NULL,
      4.060556,
      NULL,
      1.798157,
      NULL,
      0.655669,
      0,
      ' 6-17-1999',
      966.032840,
      NULL,
      217.794574,
      3,
      5,
      0,
      2.625305,
      1.827827,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.377237,
      0,
      1.490373,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.255719,
      NULL,
      0.138154,
      NULL,
      NULL,
      NULL,
      NULL,
      1.597288,
      1.681242,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.352649,
      1.625299,
      0.651802,
      0.248701,
      1.227814,
      NULL,
      3.086554,
      8.583508,
      2,
      1.021973,
      NULL,
      NULL,
      NULL,
      0.991707,
      0.803826,
      1.400421,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      3,
      1.362610,
      2.765286,
      2,
      NULL,
      3,
      3.635032,
      0,
      1,
      1,
      NULL,
      1.865101,
      1.574818,
      NULL,
      1.671218,
      NULL,
      2.755218,
      0.840355,
      0,
      1,
      1.983203,
      2.404534,
      0.705417,
      1.679782,
      4.409880,
      6,
      9,
      4.714523,
      2.574197,
      0,
      3,
      6.643558,
      NULL,
      2.881436,
      NULL,
      2,
      3.443958,
      2.677049,
      NULL,
      67.137162,
      70.748917,
      30,
      5.309350,
      1.684605,
      2.251301,
      '30312',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      2,
      NULL,
      25.265554,
      32.489552,
      2,
      19,
      8,
      1,
      1,
      1.878492,
      1.962053,
      NULL,
      1.701192,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.277534,
      NULL,
      NULL,
      1.866471,
      NULL,
      NULL,
      0.848491,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.938531,
      NULL,
      NULL,
      1.631692,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.706768,
      3,
      6,
      NULL,
      1.853593,
      NULL,
      NULL,
      NULL,
      0.551153,
      NULL,
      NULL,
      NULL,
      3,
      1.260419,
      0,
      0.677776,
      NULL,
      NULL,
      1.640109,
      NULL,
      NULL,
      2,
      1.764664,
      0.327937,
      1.784445,
      0.610126,
      3,
      1.308390,
      0,
      NULL,
      3.275148,
      NULL,
      NULL,
      0.122080,
      3.005830,
      1,
      2,
      1.684079,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.633821,
      NULL,
      NULL,
      7,
      2.274688,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.588774,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.437416,
      NULL,
      NULL,
      1.315178,
      1,
      1.092635,
      1.176565,
      NULL,
      NULL,
      1.539465,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.187013,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.327787,
      NULL,
      NULL,
      1,
      0.949503,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      5.286146,
      6.236475,
      6.747124,
      1.545517,
      0.880009,
      NULL,
      NULL,
      3.649554,
      2,
      1,
      3,
      1.691067,
      0,
      1,
      2.573593,
      0.296111,
      1,
      7.795216,
      1,
      1,
      3,
      0,
      1.093786,
      2.912906,
      NULL,
      3.391714,
      1,
      3.013641,
      3.014582,
      3,
      3,
      1.872955,
      9.061482,
      1.533190,
      NULL,
      0.562839,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1.860241,
      1.111805,
      0.314581,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.641081,
      NULL,
      NULL,
      1.364569,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.879489,
      NULL,
      NULL,
      1.170372,
      NULL,
      NULL,
      0.215072,
      NULL,
      NULL,
      0.437411,
      NULL,
      NULL,
      0.915679,
      0,
      NULL,
      NULL,
      0.259741,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.616519,
      NULL,
      NULL,
      NULL,
      0.171502,
      NULL,
      NULL,
      NULL,
      0.877248,
      NULL,
      NULL,
      NULL,
      1.206934,
      NULL,
      NULL,
      NULL,
      0.884212,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.639515,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.158990,
      NULL,
      NULL,
      NULL,
      1.936644,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      5,
      3,
      112,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.169726,
      NULL,
      NULL,
      1.472224,
      NULL,
      NULL,
      0.638890,
      NULL,
      1.075301,
      NULL,
      19,
      1.691343,
      1,
      0,
      1,
      0.065677,
      0,
      NULL,
      0.425783,
      0.095955,
      0,
      0.043368,
      0,
      NULL,
      1.815032,
      0,
      0.248876,
      0.479688,
      1.298872,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0.459832,
      NULL,
      NULL,
      NULL,
      1.451559,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      0.642056,
      NULL,
      NULL,
      1.395605,
      NULL,
      0.173594,
      NULL,
      NULL,
      NULL,
      1.276200,
      NULL,
      1.771720,
      NULL,
      1.530883,
      NULL,
      0.884700,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.469823,
      NULL,
      0.618829,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.295445,
      NULL,
      0,
      NULL,
      0.642307,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.658844,
      0.833584,
      0.853316,
      NULL,
      0,
      0.708776,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.409058,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.149537,
      0.894839,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.080125,
      NULL,
      0,
      NULL,
      NULL,
      0.716592,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.980644,
      NULL,
      2.840163,
      1.489008,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.850594,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.188058,
      NULL,
      0.899038,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      3.506367,
      42,
      NULL,
      3,
      0,
      3,
      '13320',
      '',
      '',
      0.138968,
      '',
      '',
      '',
      0.130674,
      '',
      '',
      '');
commit;
end;
/


