set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9507976';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-3-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '1',
      NULL,
      NULL,
      NULL,
      0.234133,
      1.206314,
      6,
      NULL,
      NULL,
      3,
      1.661381,
      NULL,
      NULL,
      ' 6-28-1980',
      51.395149,
      NULL,
      0,
      0.821594,
      NULL,
      '11- 6-1993',
      17,
      2.878065,
      NULL,
      7.852605,
      2,
      ' 4-15-1988',
      '10-12-1977',
      ' 3-18-1980',
      0,
      0,
      0,
      1.888498,
      0.699390,
      NULL,
      1.676380,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      2.161621,
      12,
      1.225424,
      0,
      3.047035,
      1,
      1.609466,
      NULL,
      0.580389,
      NULL,
      1.076947,
      1.655210,
      1.746291,
      1.295340,
      NULL,
      NULL,
      3,
      3.023330,
      0.934653,
      2,
      7,
      0.941449,
      NULL,
      2,
      8,
      5,
      7.001662,
      NULL,
      7,
      3.226245,
      1.944647,
      1,
      7,
      1.397222,
      NULL,
      0.331846,
      0,
      0.608059,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      0,
      3.029954,
      2.246273,
      0,
      0.832885,
      0.173623,
      1.015816,
      NULL,
      NULL,
      2.025494,
      1,
      1,
      1.120213,
      0.951999,
      NULL,
      1,
      NULL,
      NULL,
      2.569371,
      1.591118,
      1,
      7,
      1,
      NULL,
      1.002043,
      NULL,
      NULL,
      1.047284,
      0,
      0.046917,
      NULL,
      NULL,
      NULL,
      1.194458,
      5,
      1,
      2,
      1,
      3.869828,
      NULL,
      1,
      NULL,
      0,
      0.203056,
      1.088553,
      1.895224,
      NULL,
      NULL,
      5,
      2.755301,
      7,
      0.228749,
      5.169323,
      0.497062,
      NULL,
      3.847605,
      1,
      5,
      9.840920,
      1,
      ' 9-20-1992',
      42.658651,
      ' 6-24-1986',
      18,
      NULL,
      0.689894,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.422488,
      1.928787,
      0,
      10,
      1.432841,
      NULL,
      9.351370,
      1.323813,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.958873,
      NULL,
      4,
      3,
      NULL,
      1,
      3.883912,
      3.473530,
      1.357430,
      NULL,
      4,
      8.416343,
      0,
      0.374688,
      NULL,
      NULL,
      NULL,
      4.454228,
      3,
      5.331101,
      2.305762,
      4.640569,
      1,
      0.264550,
      NULL,
      NULL,
      NULL,
      1,
      0.406317,
      3,
      NULL,
      NULL,
      1,
      1.346799,
      NULL,
      6,
      ' 8-11-1986',
      NULL,
      1,
      NULL,
      1,
      3,
      NULL,
      0,
      0.883334,
      1.553128,
      1,
      0.834046,
      3.498727,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.622163,
      0.484420,
      0,
      1.905971,
      2,
      NULL,
      1,
      2,
      NULL,
      3.902086,
      2.129161,
      2,
      0.367460,
      0.258310,
      3.701685,
      2.855700,
      4,
      0,
      0,
      3,
      1.354768,
      0.776481,
      0,
      NULL,
      1.205646,
      0.837037,
      0,
      0.671243,
      1,
      1,
      NULL,
      0.882218,
      2,
      2,
      3.539801,
      8.025489,
      6.676854,
      1,
      3.636314,
      2,
      3.829453,
      1,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      8,
      NULL,
      69.315554,
      0,
      4.595415,
      2,
      '34203',
      '',
      NULL,
      1,
      '2213',
      '',
      '',
      1.560719,
      '34033',
      NULL,
      '',
      1.820785,
      NULL,
      NULL,
      10.614359,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.637355,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.688491,
      3,
      3,
      0.383608,
      3,
      NULL,
      1,
      NULL,
      0,
      3.216560,
      3,
      NULL,
      0.551871,
      NULL,
      NULL,
      0.051985,
      NULL,
      NULL,
      0.399547,
      NULL,
      NULL,
      0.392318,
      NULL,
      NULL,
      0.394905,
      NULL,
      NULL,
      3,
      NULL,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.680116,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.255403,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.552513,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.113778,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.092895,
      NULL,
      NULL,
      3.542132,
      3,
      0.565112,
      0.763802,
      NULL,
      NULL,
      0.605219,
      NULL,
      NULL,
      1.792533,
      NULL,
      NULL,
      0.128535,
      NULL,
      NULL,
      1.294663,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.966614,
      NULL,
      NULL,
      1.959277,
      NULL,
      NULL,
      0,
      1.377302,
      3.946716,
      NULL,
      0,
      0.942591,
      1.625077,
      5.455154,
      1,
      NULL,
      4,
      1,
      0.345533,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.375708,
      0.732081,
      3.201421,
      0,
      0.650558,
      2.347181,
      3.301633,
      2,
      NULL,
      0.585944,
      3.884492,
      3.237180,
      0.941840,
      NULL,
      NULL,
      0.484623,
      0.595583,
      2.341677,
      1.239793,
      NULL,
      3,
      2,
      1.088660,
      1,
      2,
      NULL,
      1.621770,
      0.862601,
      NULL,
      NULL,
      1,
      0.995456,
      0.690350,
      1,
      0.142820,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.465055,
      0.414429,
      0.676129,
      1.670002,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.727593,
      4.810222,
      2.075320,
      1.316967,
      5,
      3,
      NULL,
      NULL,
      NULL,
      3.286892,
      3,
      1.610225,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.081431,
      NULL,
      0,
      240.015857,
      3,
      1.225696,
      1,
      NULL,
      1.632696,
      NULL,
      0,
      0.143434,
      NULL,
      0.791234,
      1.327639,
      1.011715,
      1.787266,
      1,
      0,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.075249,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.221728,
      5,
      4.834343,
      1,
      0.345010,
      5,
      4.079084,
      1.466638,
      NULL,
      0,
      0.971140,
      1,
      NULL,
      2.595222,
      NULL,
      1,
      NULL,
      NULL,
      3,
      3,
      NULL,
      0.703804,
      0,
      NULL,
      0,
      0.290830,
      NULL,
      1,
      3,
      NULL,
      NULL,
      1.221118,
      NULL,
      1.107715,
      2,
      NULL,
      0.438976,
      0,
      NULL,
      3.224897,
      2,
      NULL,
      NULL,
      1.976931,
      NULL,
      3,
      1.645364,
      1.992906,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.731742,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.532331,
      9.768323,
      6.124402,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      5,
      1,
      '12441',
      '',
      '',
      3,
      '3030',
      '',
      '',
      0,
      '31130',
      '',
      NULL);
commit;
end;
/


