set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9507976';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-6-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2,
      0.588946,
      0,
      1,
      1.718672,
      2.048107,
      3,
      NULL,
      '202',
      '20123203',
      NULL,
      8,
      '0331024',
      0,
      1.556020,
      0,
      2,
      '1404',
      NULL,
      0,
      NULL,
      NULL,
      ' 6-21-1999',
      81,
      7.488889,
      NULL,
      1,
      0.785932,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.518315,
      NULL,
      NULL,
      ' 6-25-1993',
      0.068137,
      1.131593,
      0.446553,
      NULL,
      0,
      1.229885,
      NULL,
      3.846425,
      NULL,
      NULL,
      NULL,
      7.105959,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      7.638949,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      3.522035,
      0,
      1,
      NULL,
      0,
      1.207274,
      NULL,
      0.059980,
      0,
      NULL,
      1,
      0.351046,
      0,
      1.518762,
      1,
      2.570806,
      0,
      0.900814,
      1.341110,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.748522,
      1.586511,
      1.057010,
      0.977139,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.390566,
      0,
      0.092012,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.035092,
      0.141979,
      1,
      0,
      1,
      1,
      1.177835,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      0.213825,
      0.589808,
      0,
      1.121822,
      1.908448,
      NULL,
      0,
      7,
      NULL,
      3,
      0.452183,
      1,
      1.851409,
      4.497190,
      1.943821,
      0.279296,
      NULL,
      1.786105,
      2,
      1.749999,
      2.500413,
      1.824488,
      NULL,
      0,
      NULL,
      4.710231,
      NULL,
      0,
      1,
      3,
      3.990182,
      2.175568,
      NULL,
      1.107813,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.746884,
      1.411596,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.486135,
      1,
      0,
      1,
      0,
      1.732153,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      2,
      2.988332,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.480330,
      1,
      1,
      7.040080,
      1,
      3.533624,
      0.482667,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.333472,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0.765802,
      0,
      1,
      0.756068,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.049727,
      0,
      0.080413,
      2,
      3,
      2,
      2.012652,
      0.491624,
      1.553530,
      0,
      0,
      1,
      1.724692,
      1,
      3,
      2.227097,
      3,
      NULL,
      1.731190,
      1,
      NULL,
      0.727869,
      1.438140,
      1,
      1,
      1,
      0.849365,
      0.640789,
      0,
      1.102433,
      1.986145,
      1.300746,
      NULL,
      11,
      2.350529,
      NULL,
      8.510984,
      2.609810,
      2,
      3.621128,
      3.969399,
      1.021073,
      NULL,
      NULL,
      8.383641,
      1.499572,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.183754,
      NULL,
      '00140',
      '33123',
      '',
      1,
      '11020',
      '',
      NULL,
      1,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      20,
      1.034167,
      27.907492,
      5.933926,
      2.051038,
      NULL,
      3,
      1,
      1,
      1.717245,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      1.534435,
      0,
      0.544479,
      NULL,
      3.965644,
      1.408993,
      1,
      2,
      0,
      3.361020,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.571567,
      NULL,
      NULL,
      NULL,
      8,
      0.597480,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.412460,
      0.797486,
      NULL,
      NULL,
      3,
      0.390295,
      1.586483,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      1.985838,
      0,
      NULL,
      NULL,
      NULL,
      3.319375,
      0,
      4,
      4,
      0.445868,
      1,
      1.160238,
      NULL,
      NULL,
      NULL,
      1.399295,
      1,
      2,
      NULL,
      1,
      NULL,
      NULL,
      0.165720,
      0.976683,
      1,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      4.169976,
      6,
      0.964717,
      3,
      0,
      0.044180,
      0,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.039065,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.848782,
      3.257482,
      3,
      5,
      2,
      5.254274,
      3,
      4,
      NULL,
      11.115322,
      3,
      1.526748,
      NULL,
      NULL,
      3,
      2,
      0.857096,
      3,
      0.489402,
      3.467558,
      7,
      6,
      NULL,
      2,
      1.204647,
      1,
      0,
      NULL,
      1.748648,
      2.565226,
      2.646439,
      3,
      NULL,
      3.364705,
      1,
      4,
      9.204176,
      NULL,
      NULL,
      7.042948,
      4,
      1,
      2,
      6,
      1.518509,
      NULL,
      1.723936,
      1,
      0,
      2.017465,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.403367,
      NULL,
      NULL,
      2,
      NULL,
      3,
      1.322459,
      0.155682,
      3.963611,
      3,
      NULL,
      6.885254,
      6,
      7,
      NULL,
      NULL,
      5,
      2.340655,
      NULL,
      1.388330,
      0.733197,
      NULL,
      NULL,
      0.008928,
      1,
      NULL,
      NULL,
      0.151811,
      0.418407,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.242669,
      1.463161,
      NULL,
      1,
      NULL,
      0.905911,
      NULL,
      1.298257,
      1.504500,
      1.669524,
      NULL,
      NULL,
      0.360025,
      1,
      NULL,
      3,
      2.618993,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.548112,
      0,
      1,
      NULL,
      3,
      NULL,
      3.556340,
      NULL,
      0.035401,
      2,
      2.476662,
      NULL,
      2,
      1.217457,
      0.199130,
      NULL,
      3,
      1.314346,
      1,
      NULL,
      0.716998,
      NULL,
      0,
      NULL,
      4,
      2,
      4,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.025821,
      105.871112,
      18.587903,
      1.326706,
      166,
      8.627982,
      1,
      NULL,
      NULL,
      0.791357,
      2,
      2.121966,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.984639,
      79.902358,
      29,
      0,
      NULL,
      1.630238,
      0.683389,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      0.467673,
      0.007825,
      0,
      1,
      0.599212,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.776895,
      3,
      NULL,
      5,
      2,
      1,
      NULL,
      NULL,
      NULL,
      3.875270,
      1.536977,
      0,
      1.923105,
      1.334443,
      0.714989,
      1.811715,
      2.342403,
      2,
      3.837846,
      NULL,
      0.881463,
      0,
      0,
      1,
      1.749408,
      2.542764,
      3.095467,
      2,
      2,
      1,
      1.773092,
      0,
      NULL,
      0.127703,
      1,
      0.082058,
      0,
      NULL,
      1,
      1,
      0,
      0.925765,
      1.192449,
      0,
      2,
      0.036093,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      4.133860,
      2.355115,
      NULL,
      1,
      NULL,
      NULL,
      49.606616,
      111.754637,
      5.953659,
      0,
      4,
      '04401',
      '03011',
      NULL,
      3,
      '24232',
      '',
      '',
      NULL,
      '11042',
      '',
      '');
commit;
end;
/


